/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.geometry2d;

import com.shavenpuppy.jglib.geometry.geometry2d.CubicBezierSegment;
import com.shavenpuppy.jglib.geometry.geometry2d.ReadablePathSegment;
import java.util.ArrayList;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class PiecewiseBezier {
    private ArrayList segments = new ArrayList();
    private int danglingPoints = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.geometry.geometry2d.PiecewiseBezier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public int numSegments() {
        return this.segments.size();
    }

    public int numPoints() {
        if (this.numSegments() == 0) {
            return 0;
        }
        return 1 + this.numSegments() * 3 - this.danglingPoints;
    }

    public void setPoint(int index, ReadableVector2f newPosition) {
        this.setPointInternal(index, newPosition);
        if (index == this.numPoints() - 1 && this.danglingPoints > 0) {
            this.setPointInternal(index + 1, newPosition);
            if (this.danglingPoints >= 2) {
                this.setPointInternal(index + 2, newPosition);
            }
            if (this.danglingPoints == 3) {
                this.setPointInternal(index + 3, newPosition);
            }
            if (!$assertionsDisabled && this.danglingPoints > 3) {
                throw new AssertionError();
            }
        }
    }

    public void setPointContinuous(int index, ReadableVector2f newPosition) {
        int segIndex = this.segmentIndex(index);
        int pointOffset = this.pointOffset(index, segIndex);
        CubicBezierSegment segment = (CubicBezierSegment)this.segments.get(segIndex);
        if (segIndex == 0 && (pointOffset == 0 || pointOffset == 1)) {
            this.setPoint(index, newPosition);
        } else if (segIndex == this.numSegments() - 1 && (pointOffset == 2 || pointOffset == 3)) {
            this.setPoint(index, newPosition);
        } else {
            switch (pointOffset) {
                case 0: {
                    this.shiftEndPoint(segIndex - 1, segIndex, newPosition);
                    break;
                }
                case 3: {
                    this.shiftEndPoint(segIndex, segIndex + 1, newPosition);
                    break;
                }
                case 1: {
                    segment.setControlPoint1(newPosition);
                    CubicBezierSegment prevSeg = (CubicBezierSegment)this.segments.get(segIndex - 1);
                    Vector2f out = this.findContinuous(segment.getControlPoint1(), segment.getStartPoint(), prevSeg.getControlPoint2());
                    prevSeg.setControlPoint2((ReadableVector2f)out);
                    break;
                }
                case 2: {
                    segment.setControlPoint2(newPosition);
                    CubicBezierSegment nextSeg = (CubicBezierSegment)this.segments.get(segIndex + 1);
                    Vector2f out = this.findContinuous(segment.getControlPoint2(), segment.getEndPoint(), nextSeg.getControlPoint1());
                    nextSeg.setControlPoint1((ReadableVector2f)out);
                }
            }
        }
    }

    private void shiftEndPoint(int startSegmentIndex, int endSegmentIndex, ReadableVector2f newPosition) {
        if (!$assertionsDisabled && startSegmentIndex >= endSegmentIndex) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && endSegmentIndex - startSegmentIndex != 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && startSegmentIndex < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && endSegmentIndex >= this.numSegments()) {
            throw new AssertionError();
        }
        CubicBezierSegment startSeg = (CubicBezierSegment)this.segments.get(startSegmentIndex);
        CubicBezierSegment endSeg = (CubicBezierSegment)this.segments.get(endSegmentIndex);
        Vector2f delta = new Vector2f();
        delta.x = newPosition.getX() - startSeg.getEndPoint().getX();
        delta.y = newPosition.getY() - startSeg.getEndPoint().getY();
        Vector2f shift2 = new Vector2f(startSeg.getControlPoint2());
        Vector2f.add((Vector2f)delta, (Vector2f)shift2, (Vector2f)shift2);
        startSeg.setControlPoint2((ReadableVector2f)shift2);
        Vector2f shift1 = new Vector2f(endSeg.getControlPoint1());
        Vector2f.add((Vector2f)delta, (Vector2f)shift1, (Vector2f)shift1);
        endSeg.setControlPoint1((ReadableVector2f)shift1);
        startSeg.setEndPoint(newPosition);
    }

    private Vector2f findContinuous(ReadableVector2f movedPoint, ReadableVector2f pivotPoint, ReadableVector2f mirrorPoint) {
        float dx = movedPoint.getX() - pivotPoint.getX();
        float dy = movedPoint.getY() - pivotPoint.getY();
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        float nx = dx / length;
        float ny = dy / length;
        if (length > 0.0f) {
            float mirroredLength = this.separation(mirrorPoint, pivotPoint);
            if (mirroredLength == 0.0f) {
                mirroredLength = length;
            }
            Vector2f out = new Vector2f();
            out.x = pivotPoint.getX() + -nx * mirroredLength;
            out.y = pivotPoint.getY() + -ny * mirroredLength;
            return out;
        }
        return null;
    }

    private float separation(ReadableVector2f p1, ReadableVector2f p2) {
        float dx = p1.getX() - p2.getX();
        float dy = p1.getY() - p2.getY();
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public ReadableVector2f getPoint(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index >= this.numPoints()) {
            throw new AssertionError();
        }
        int segIndex = this.segmentIndex(index);
        int pointOffset = this.pointOffset(index, segIndex);
        if (!$assertionsDisabled && segIndex >= this.numSegments()) {
            throw new AssertionError((Object)("Seg index(" + segIndex + ") larger than total number of segments(" + this.numSegments() + ")."));
        }
        CubicBezierSegment segment = (CubicBezierSegment)this.segments.get(segIndex);
        switch (pointOffset) {
            case 0: {
                return segment.getStartPoint();
            }
            case 1: {
                return segment.getControlPoint1();
            }
            case 2: {
                return segment.getControlPoint2();
            }
            case 3: {
                return segment.getEndPoint();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private void setPointInternal(int index, ReadableVector2f newPosition) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index >= this.numPoints() + this.danglingPoints) {
            throw new AssertionError();
        }
        int segIndex = this.segmentIndex(index);
        int pointOffset = this.pointOffset(index, segIndex);
        if (!$assertionsDisabled && segIndex >= this.numSegments()) {
            throw new AssertionError((Object)("Seg index(" + segIndex + ") larger than total number of segments(" + this.numSegments() + ")."));
        }
        CubicBezierSegment segment = (CubicBezierSegment)this.segments.get(segIndex);
        switch (pointOffset) {
            case 0: {
                segment.setStartPoint(newPosition);
                break;
            }
            case 1: {
                segment.setControlPoint1(newPosition);
                break;
            }
            case 2: {
                segment.setControlPoint2(newPosition);
                break;
            }
            case 3: {
                segment.setEndPoint(newPosition);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    private int segmentIndex(int globalIndex) {
        int segIndex = (int)Math.floor((float)globalIndex / 3.0f);
        if (globalIndex % 3 == 0 && globalIndex > 0) {
            --segIndex;
        }
        return segIndex;
    }

    private int pointOffset(int globalIndex, int segmentIndex) {
        return globalIndex - segmentIndex * 3;
    }

    public void addPoint(ReadableVector2f newPoint) {
        int numSegments = this.numSegments();
        if (numSegments == 0) {
            CubicBezierSegment newSeg = new CubicBezierSegment();
            this.segments.add(newSeg);
            newSeg.setStartPoint(newPoint);
            newSeg.setControlPoint1(newPoint);
            newSeg.setControlPoint2(newPoint);
            newSeg.setEndPoint(newPoint);
            this.danglingPoints = 3;
        } else {
            CubicBezierSegment endSegment = (CubicBezierSegment)this.segments.get(numSegments - 1);
            switch (this.danglingPoints) {
                case 0: {
                    CubicBezierSegment newSeg = new CubicBezierSegment(endSegment, null);
                    this.segments.add(newSeg);
                    newSeg.setControlPoint1(newPoint);
                    newSeg.setControlPoint2(newPoint);
                    newSeg.setEndPoint(newPoint);
                    this.danglingPoints = 2;
                    break;
                }
                case 1: {
                    endSegment.setEndPoint(newPoint);
                    --this.danglingPoints;
                    break;
                }
                case 2: {
                    endSegment.setControlPoint2(newPoint);
                    endSegment.setEndPoint(newPoint);
                    --this.danglingPoints;
                    break;
                }
                case 3: {
                    endSegment.setControlPoint1(newPoint);
                    endSegment.setControlPoint2(newPoint);
                    endSegment.setEndPoint(newPoint);
                    --this.danglingPoints;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }
    }

    public ReadablePathSegment getSegment(int index) {
        return (ReadablePathSegment)this.segments.get(index);
    }

    public Vector2f findPositionByDomain(float tValue) {
        return this.findPositionByDomain(tValue, new Vector2f());
    }

    public Vector2f findPositionByDomain(float tValue, Vector2f dest) {
        if (!($assertionsDisabled || tValue >= 0.0f && tValue <= 1.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dest == null) {
            throw new AssertionError();
        }
        float absT = tValue * (float)this.numSegments();
        int segNum = (int)Math.floor(absT);
        if (segNum == this.numSegments()) {
            --segNum;
        }
        if (!$assertionsDisabled && segNum < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && segNum >= this.numSegments()) {
            throw new AssertionError();
        }
        CubicBezierSegment segment = (CubicBezierSegment)this.segments.get(segNum);
        segment.findPosition(absT - (float)segNum, dest);
        return dest;
    }

    public boolean isValidLength(float testLength) {
        return testLength >= 0.0f && testLength <= this.length();
    }

    public void findOffsetByLength(float findLength, Vector2f dest) {
        if (!$assertionsDisabled && !this.isValidLength(findLength)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dest == null) {
            throw new AssertionError();
        }
        float l = this.length();
        if (l == 0.0f) {
            dest.set(0.0f, 0.0f);
            return;
        }
        if (!$assertionsDisabled && this.numPoints() <= 0) {
            throw new AssertionError();
        }
        this.findPositionByLength(findLength, dest);
        CubicBezierSegment firstSeg = (CubicBezierSegment)this.segments.get(0);
        ReadableVector2f startPoint = firstSeg.getStartPoint();
        dest.x -= startPoint.getX();
        dest.y -= startPoint.getY();
    }

    private SegmentResult findSegment(float findLength) {
        if (!$assertionsDisabled && !this.isValidLength(findLength)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(this.length() > 0.0f)) {
            throw new AssertionError();
        }
        float accumLength = 0.0f;
        int i = 0;
        while (i < this.numSegments()) {
            CubicBezierSegment seg = (CubicBezierSegment)this.segments.get(i);
            float segLength = seg.length();
            if (findLength <= accumLength + segLength) {
                float relLength = findLength - accumLength;
                return new SegmentResult(seg, relLength);
            }
            accumLength += segLength;
            ++i;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Vector2f findPositionByLength(float findLength) {
        return this.findPositionByLength(findLength, new Vector2f());
    }

    public Vector2f findPositionByLength(float findLength, Vector2f dest) {
        if (!$assertionsDisabled && !this.isValidLength(findLength)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(this.length() > 0.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dest == null) {
            throw new AssertionError();
        }
        SegmentResult res = this.findSegment(findLength);
        if (!$assertionsDisabled && res == null) {
            throw new AssertionError();
        }
        CubicBezierSegment seg = res.segment;
        float t = seg.getTimeFromPosition(res.relativeLength);
        return seg.findPosition(t, dest);
    }

    public Vector2f findVelocityAtLength(float findLength, Vector2f dest) {
        if (!$assertionsDisabled && !this.isValidLength(findLength)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(this.length() > 0.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dest == null) {
            throw new AssertionError();
        }
        SegmentResult res = this.findSegment(findLength);
        CubicBezierSegment seg = res.segment;
        float t = seg.getTimeFromPosition(res.relativeLength);
        seg.velocity(t, dest);
        return dest;
    }

    public void findCurveData(float findLength, Vector2f outPosition, Vector2f outVelocity) {
        if (!$assertionsDisabled && !this.isValidLength(findLength)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(this.length() > 0.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outPosition == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && outVelocity == null) {
            throw new AssertionError();
        }
        SegmentResult res = this.findSegment(findLength);
        CubicBezierSegment seg = res.segment;
        float t = seg.getTimeFromPosition(res.relativeLength);
        seg.findPosition(t, outPosition);
        seg.velocity(t, outVelocity);
    }

    public float length() {
        float length = 0.0f;
        int i = 0;
        while (i < this.segments.size()) {
            CubicBezierSegment seg = (CubicBezierSegment)this.segments.get(i);
            length += seg.length();
            ++i;
        }
        return length;
    }

    private class SegmentResult {
        public final CubicBezierSegment segment;
        public final float relativeLength;

        public SegmentResult(CubicBezierSegment seg, float len) {
            this.segment = seg;
            this.relativeLength = len;
        }
    }
}

