/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.geometry2d;

import com.shavenpuppy.jglib.geometry.geometry2d.VectorUtil;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class LineSegment2D {
    public Vector2f position;
    public Vector2f direction;

    public LineSegment2D() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public LineSegment2D(float x1, float y1, float x2, float y2) {
        this.position = new Vector2f(x1, y1);
        this.direction = new Vector2f(x2 - x1, y2 - y1);
    }

    public void set(float x1, float y1, float x2, float y2) {
        this.position.set(x1, y1);
        this.direction.set(x2 - x1, y2 - y1);
    }

    public void setStart(ReadableVector2f point) {
        this.setStart(point.getX(), point.getY());
    }

    public void setEnd(ReadableVector2f point) {
        this.setEnd(point.getX(), point.getY());
    }

    public void setStart(float x, float y) {
        this.position.set(x, y);
    }

    public void setEnd(float x, float y) {
        this.direction.set(x - this.position.x, y - this.position.y);
    }

    public boolean intersects(LineSegment2D testSegment) {
        float Bx = this.position.x + this.direction.x;
        float Ax = this.position.x;
        float Dy = testSegment.position.y + testSegment.direction.y;
        float Cy = testSegment.position.y;
        float By = this.position.y + this.direction.y;
        float Ay = this.position.y;
        float Dx = testSegment.position.x + testSegment.direction.x;
        float Cx = testSegment.position.x;
        float denominator = (Bx - Ax) * (Dy - Cy) - (By - Ay) * (Dx - Cx);
        if (denominator == 0.0f) {
            return false;
        }
        float r = (Ay - Cy) * (Dx - Cx) - (Ax - Cx) * (Dy - Cy);
        if ((r /= denominator) < 0.0f || r > 1.0f) {
            return false;
        }
        float s = (Ay - Cy) * (Bx - Ax) - (Ax - Cx) * (By - Ay);
        return !((s /= denominator) < 0.0f) && !(s > 1.0f);
    }

    public Vector2f findIntersect(LineSegment2D testSegment) {
        float Bx = this.position.x + this.direction.x;
        float Ax = this.position.x;
        float Dy = testSegment.position.y + testSegment.direction.y;
        float Cy = testSegment.position.y;
        float By = this.position.y + this.direction.y;
        float Ay = this.position.y;
        float Dx = testSegment.position.x + testSegment.direction.x;
        float Cx = testSegment.position.x;
        float denominator = (Bx - Ax) * (Dy - Cy) - (By - Ay) * (Dx - Cx);
        if (denominator == 0.0f) {
            return null;
        }
        float r = (Ay - Cy) * (Dx - Cx) - (Ax - Cx) * (Dy - Cy);
        if ((r /= denominator) < 0.0f || r > 1.0f) {
            return null;
        }
        float s = (Ay - Cy) * (Bx - Ax) - (Ax - Cx) * (By - Ay);
        if ((s /= denominator) < 0.0f || s > 1.0f) {
            return null;
        }
        Vector2f intersectPoint = new Vector2f();
        intersectPoint.x = this.position.x + this.direction.x * r;
        intersectPoint.y = this.position.y + this.direction.y * r;
        return intersectPoint;
    }

    public float getIntersectTValue(LineSegment2D otherSegment) {
        float Bx = this.position.x + this.direction.x;
        float Ax = this.position.x;
        float Dy = otherSegment.position.y + otherSegment.direction.y;
        float Cy = otherSegment.position.y;
        float By = this.position.y + this.direction.y;
        float Ay = this.position.y;
        float Dx = otherSegment.position.x + otherSegment.direction.x;
        float Cx = otherSegment.position.x;
        float denominator = (Bx - Ax) * (Dy - Cy) - (By - Ay) * (Dx - Cx);
        if (denominator == 0.0f) {
            return 0.0f;
        }
        float t = (Ay - Cy) * (Dx - Cx) - (Ax - Cx) * (Dy - Cy);
        return t / denominator;
    }

    public float distanceSquaredTo(ReadableVector2f point) {
        return this.distanceSquaredTo(point.getX(), point.getY());
    }

    public float distanceSquaredTo(float pointX, float pointY) {
        float wX = pointX - this.position.x;
        float wY = pointY - this.position.y;
        float c1 = VectorUtil.dot((ReadableVector2f)this.direction, wX, wY);
        if (c1 <= 0.0f) {
            return Math.abs(VectorUtil.separationSquared(this.position.x, this.position.y, wX, wY));
        }
        float c2 = Vector2f.dot((Vector2f)this.direction, (Vector2f)this.direction);
        if (c2 <= c1) {
            return Math.abs(VectorUtil.separationSquared(this.position.x + this.direction.x, this.position.y + this.direction.y, pointX, pointY));
        }
        float b = c1 / c2;
        wX = this.position.x + b * this.direction.x;
        wY = this.position.y + b * this.direction.y;
        return VectorUtil.separationSquared(pointX, pointY, wX, wY);
    }

    public Vector2f findClosestPointTo(float pointX, float pointY) {
        double l = (pointX - this.position.x) * this.direction.x + (pointY - this.position.y) * this.direction.y;
        double m = this.direction.x * this.direction.x + this.direction.y * this.direction.y;
        double u = l / m;
        if (u > 1.0) {
            u = 1.0;
        } else if (u < 0.0) {
            u = 0.0;
        }
        float x = (float)((double)this.position.x + u * (double)this.direction.x);
        float y = (float)((double)this.position.y + u * (double)this.direction.y);
        return new Vector2f(x, y);
    }

    public float getCenterX() {
        return this.position.x + this.direction.x / 2.0f;
    }

    public float getCenterY() {
        return this.position.y + this.direction.y / 2.0f;
    }

    public float getStartX() {
        return this.position.x;
    }

    public float getStartY() {
        return this.position.y;
    }

    public float getEndX() {
        return this.position.x + this.direction.x;
    }

    public float getEndY() {
        return this.position.y + this.direction.y;
    }
}

