/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.geometry2d;

import com.shavenpuppy.jglib.geometry.geometry2d.ReadablePathSegment;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CubicBezierSegment
implements ReadablePathSegment {
    private Vector2f startPoint;
    private Vector2f endPoint;
    private Vector2f controlPoint1;
    private Vector2f controlPoint2;
    private CubicBezierSegment prevSegment;
    private CubicBezierSegment nextSegment;
    private float length;
    private boolean lengthInvalid;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.geometry.geometry2d.CubicBezierSegment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CubicBezierSegment() {
        this.startPoint = new Vector2f();
        this.controlPoint1 = new Vector2f();
        this.controlPoint2 = new Vector2f();
        this.endPoint = new Vector2f();
        this.nextSegment = null;
        this.prevSegment = null;
        this.lengthInvalid = true;
    }

    CubicBezierSegment(CubicBezierSegment prev, CubicBezierSegment next) {
        if (!$assertionsDisabled && prev == null && next == null) {
            throw new AssertionError((Object)"Gotta have at least a head or a tail for this constructor!");
        }
        this.controlPoint1 = new Vector2f();
        this.controlPoint2 = new Vector2f();
        if (prev != null) {
            this.startPoint = prev.endPoint;
            this.prevSegment = prev;
        } else {
            this.startPoint = new Vector2f();
            this.prevSegment = null;
        }
        if (next != null) {
            this.endPoint = next.startPoint;
            this.nextSegment = next;
        } else {
            this.endPoint = new Vector2f();
            this.nextSegment = null;
        }
        if (prev != null) {
            if (next != null) {
                this.controlPoint1.set((ReadableVector2f)this.startPoint);
                this.controlPoint2.set((ReadableVector2f)this.endPoint);
            } else {
                this.controlPoint1.set((ReadableVector2f)this.startPoint);
                this.controlPoint2.set((ReadableVector2f)this.startPoint);
                this.endPoint.set((ReadableVector2f)this.startPoint);
            }
        } else {
            if (!$assertionsDisabled && next == null) {
                throw new AssertionError();
            }
            this.startPoint.set((ReadableVector2f)this.endPoint);
            this.controlPoint1.set((ReadableVector2f)this.endPoint);
            this.controlPoint2.set((ReadableVector2f)this.endPoint);
        }
    }

    public ReadableVector2f getStartPoint() {
        return this.startPoint;
    }

    public ReadableVector2f getControlPoint1() {
        return this.controlPoint1;
    }

    public ReadableVector2f getControlPoint2() {
        return this.controlPoint2;
    }

    public ReadableVector2f getEndPoint() {
        return this.endPoint;
    }

    public void setStartPoint(ReadableVector2f point) {
        this.startPoint.set(point);
        this.lengthInvalid = true;
        if (this.prevSegment != null) {
            this.prevSegment.lengthInvalid = true;
        }
    }

    public void setControlPoint1(ReadableVector2f point) {
        this.controlPoint1.set(point);
        this.lengthInvalid = true;
    }

    public void setControlPoint2(ReadableVector2f point) {
        this.controlPoint2.set(point);
        this.lengthInvalid = true;
    }

    public void setEndPoint(ReadableVector2f point) {
        this.endPoint.set(point);
        this.lengthInvalid = true;
        if (this.nextSegment != null) {
            this.nextSegment.lengthInvalid = true;
        }
    }

    public Vector2f findPosition(float t) {
        return this.findPosition(t, new Vector2f());
    }

    public Vector2f findPosition(float t, Vector2f dest) {
        if (!($assertionsDisabled || t >= 0.0f && t <= 1.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dest == null) {
            throw new AssertionError();
        }
        float invT = 1.0f - t;
        float weight0 = invT * invT * invT;
        float weight1 = 3.0f * t * invT * invT;
        float weight2 = 3.0f * t * t * invT;
        float weight3 = t * t * t;
        dest.x = weight0 * this.startPoint.x + weight1 * this.controlPoint1.x + weight2 * this.controlPoint2.x + weight3 * this.endPoint.x;
        dest.y = weight0 * this.startPoint.y + weight1 * this.controlPoint1.y + weight2 * this.controlPoint2.y + weight3 * this.endPoint.y;
        return dest;
    }

    public float length() {
        if (this.lengthInvalid) {
            this.length = this.intergralLength();
            this.lengthInvalid = false;
        }
        return this.length;
    }

    public float dumbLength() {
        float inc;
        this.length = 0.0f;
        float x = this.startPoint.x;
        float y = this.startPoint.y;
        Vector2f newPoint = new Vector2f();
        float t = inc = 0.015625f;
        while (t <= 1.0f) {
            this.findPosition(t, newPoint);
            float dx = newPoint.x - x;
            float dy = newPoint.y - y;
            this.length += (float)Math.sqrt(dx * dx + dy * dy);
            x = newPoint.x;
            y = newPoint.y;
            t += inc;
        }
        return this.length;
    }

    public float speed(float t) {
        Vector2f vel = this.velocity(t);
        return (float)Math.sqrt(vel.x * vel.x + vel.y * vel.y);
    }

    public Vector2f velocity(float t) {
        return this.velocity(t, new Vector2f());
    }

    public Vector2f velocity(float t, Vector2f dest) {
        if (!($assertionsDisabled || t >= 0.0f && t <= 1.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dest == null) {
            throw new AssertionError();
        }
        float t2 = t * t;
        float w0 = -3.0f * t2 + 6.0f * t - 3.0f;
        float w1 = 9.0f * t2 - 12.0f * t + 3.0f;
        float w2 = 6.0f * t - 9.0f * t2;
        float w3 = 3.0f * t2;
        float vx = this.startPoint.x * w0 + this.controlPoint1.x * w1 + this.controlPoint2.x * w2 + this.endPoint.x * w3;
        float vy = this.startPoint.y * w0 + this.controlPoint1.y * w1 + this.controlPoint2.y * w2 + this.endPoint.y * w3;
        dest.set(vx, vy);
        return dest;
    }

    public float intergralLength() {
        return this.gaussianQuadrature(0.0f, 1.0f);
    }

    private float lengthTo(float tMax) {
        if (!($assertionsDisabled || tMax >= 0.0f && tMax <= 1.0f)) {
            throw new AssertionError();
        }
        return this.gaussianQuadrature(0.0f, tMax);
    }

    private float gaussianQuadrature(float fA, float fB) {
        int iDegree = 5;
        float[] s_afRoot = new float[]{-0.90617985f, -0.5384693f, 0.0f, 0.5384693f, 0.90617985f};
        float[] s_afCoeff = new float[]{0.23692688f, 0.47862867f, 0.5688889f, 0.47862867f, 0.23692688f};
        float fRadius = 0.5f * (fB - fA);
        float fCenter = 0.5f * (fB + fA);
        float fResult = 0.0f;
        int i = 0;
        while (i < 5) {
            fResult += s_afCoeff[i] * this.speed(fRadius * s_afRoot[i] + fCenter);
            ++i;
        }
        return fResult *= fRadius;
    }

    public float getTimeFromPosition(float position) {
        if (!$assertionsDisabled && !(position >= 0.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(position <= this.length())) {
            throw new AssertionError();
        }
        if (position == 0.0f) {
            return 0.0f;
        }
        if (position == this.length()) {
            return 1.0f;
        }
        int maxIterations = 128;
        float tolerance = 0.5f;
        float l = this.length();
        float time = position / l;
        float difference = 0.0f;
        int i = 0;
        while (i < 128) {
            difference = this.lengthTo(time) - position;
            if (Math.abs(difference) < 0.5f) {
                return time;
            }
            float s = this.speed(time);
            time -= difference / s;
            time = Math.max(time, 0.0f);
            time = Math.min(time, 1.0f);
            ++i;
        }
        return time;
    }

    public static void test() {
        CubicBezierSegment seg = new CubicBezierSegment();
        seg.setStartPoint((ReadableVector2f)new Vector2f(0.0f, 0.0f));
        seg.setControlPoint1((ReadableVector2f)new Vector2f(10.0f, 0.0f));
        seg.setControlPoint2((ReadableVector2f)new Vector2f(20.0f, 0.0f));
        seg.setEndPoint((ReadableVector2f)new Vector2f(30.0f, 0.0f));
        float dumbL = seg.dumbLength();
        float iLen = seg.intergralLength();
        System.out.println("DumbL: " + dumbL);
        System.out.println("iLen: " + iLen);
        float t = 0.8f;
        System.out.println("Speed @ " + t + ": " + seg.speed(t));
        System.out.println("Position @ " + t + ": " + seg.findPosition(t));
        float searchL = 24.0f;
        float foundT = seg.getTimeFromPosition(searchL);
        System.out.println("For pos " + searchL + " found t:" + foundT);
        System.exit(0);
    }
}

