/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.geometry2d;

import com.shavenpuppy.jglib.geometry.geometry2d.Circle;
import com.shavenpuppy.jglib.geometry.geometry2d.LineSegment2D;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Capsule {
    private LineSegment2D line = new LineSegment2D();
    private float radius = 1.0f;

    public void setStartPoint(ReadableVector2f point) {
        this.line.position.set(point);
    }

    public void setStartPoint(float x, float y) {
        this.line.position.set(x, y);
    }

    public void setEndPoint(ReadableVector2f point) {
        this.line.setEnd(point);
    }

    public void setEndPoint(float x, float y) {
        this.line.setEnd(x, y);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void translate(float xInc, float yInc) {
        this.line.position.x += xInc;
        this.line.position.y += yInc;
    }

    public void translate(float x1, float y1, float x2, float y2) {
        this.line.position.x += x1;
        this.line.position.y += y1;
        this.line.direction.x += x2 - x1;
        this.line.direction.y += y2 - y1;
    }

    public boolean intersectsCircle(float circleX, float circleY, float circleRadius) {
        float sumRadii = this.radius + circleRadius;
        float sepSquared = this.line.distanceSquaredTo(circleX, circleY);
        return sepSquared <= sumRadii * sumRadii;
    }

    public void renderWireframe() {
        Vector2f startPos = this.line.position;
        Vector2f endPos = new Vector2f();
        Vector2f.add((Vector2f)this.line.position, (Vector2f)this.line.direction, (Vector2f)endPos);
        Vector2f norm = new Vector2f();
        norm.x = this.line.direction.y;
        norm.y = -this.line.direction.x;
        norm.normalise();
        norm.scale(this.radius);
        Circle.renderWireframe(startPos.x, startPos.y, 0.0f, this.radius);
        Circle.renderWireframe(endPos.x, endPos.y, 0.0f, this.radius);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)(startPos.x + norm.x), (float)(startPos.y + norm.y));
        GL11.glVertex2f((float)(endPos.x + norm.x), (float)(endPos.y + norm.y));
        GL11.glVertex2f((float)(startPos.x - norm.x), (float)(startPos.y - norm.y));
        GL11.glVertex2f((float)(endPos.x - norm.x), (float)(endPos.y - norm.y));
        GL11.glEnd();
    }

    public float getStartX() {
        return this.line.getStartX();
    }

    public float getStartY() {
        return this.line.getStartY();
    }

    public float getEndX() {
        return this.line.getEndX();
    }

    public float getEndY() {
        return this.line.getEndY();
    }

    public float getRadius() {
        return this.radius;
    }
}

