/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry.geometry2d;

import com.shavenpuppy.jglib.geometry.geometry2d.CubicBezierSegment;
import com.shavenpuppy.jglib.geometry.geometry2d.QuadraticBezierSegment;
import com.shavenpuppy.jglib.geometry.geometry2d.ReadablePathSegment;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BezierCurve
implements ReadablePathSegment {
    public CubicBezierSegment cubicBezier;
    private QuadraticBezierSegment[] quadraticApproximation;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.geometry.geometry2d.BezierCurve");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BezierCurve() {
        this.cubicBezier = new CubicBezierSegment();
        this.quadraticApproximation = new QuadraticBezierSegment[4];
        int i = 0;
        while (i < this.quadraticApproximation.length) {
            this.quadraticApproximation[i] = new QuadraticBezierSegment();
            ++i;
        }
    }

    public BezierCurve(BezierCurve prev, BezierCurve next) {
        CubicBezierSegment prevCubic = prev == null ? null : prev.cubicBezier;
        CubicBezierSegment nextCubic = next == null ? null : next.cubicBezier;
        this.cubicBezier = new CubicBezierSegment(prevCubic, nextCubic);
        this.quadraticApproximation = new QuadraticBezierSegment[4];
        int i = 0;
        while (i < this.quadraticApproximation.length) {
            this.quadraticApproximation[i] = new QuadraticBezierSegment();
            ++i;
        }
    }

    public ReadableVector2f getStartPoint() {
        return this.cubicBezier.getStartPoint();
    }

    public ReadableVector2f getControlPoint1() {
        return this.cubicBezier.getControlPoint1();
    }

    public ReadableVector2f getControlPoint2() {
        return this.cubicBezier.getControlPoint2();
    }

    public ReadableVector2f getEndPoint() {
        return this.cubicBezier.getEndPoint();
    }

    public void setStartPoint(ReadableVector2f point) {
        this.cubicBezier.setStartPoint(point);
        this.recalculateQuadraticApproximation();
    }

    public void setControlPoint1(ReadableVector2f point) {
        this.cubicBezier.setControlPoint1(point);
        this.recalculateQuadraticApproximation();
    }

    public void setControlPoint2(ReadableVector2f point) {
        this.cubicBezier.setControlPoint2(point);
        this.recalculateQuadraticApproximation();
    }

    public void setEndPoint(ReadableVector2f point) {
        this.cubicBezier.setEndPoint(point);
        this.recalculateQuadraticApproximation();
    }

    private void recalculateQuadraticApproximation() {
        ReadableVector2f cubicP0 = this.cubicBezier.getStartPoint();
        ReadableVector2f cubicP1 = this.cubicBezier.getControlPoint1();
        ReadableVector2f cubicP2 = this.cubicBezier.getControlPoint2();
        ReadableVector2f cubicP3 = this.cubicBezier.getEndPoint();
        this.quadraticApproximation[0].setStartPoint(cubicP0);
        this.quadraticApproximation[3].setEndPoint(cubicP3);
        float m1X = (cubicP0.getX() + cubicP1.getX()) * 0.5f;
        float m1Y = (cubicP0.getY() + cubicP1.getY()) * 0.5f;
        float m2X = (cubicP1.getX() + cubicP2.getX()) * 0.5f;
        float m2Y = (cubicP1.getY() + cubicP2.getY()) * 0.5f;
        float m3X = (cubicP2.getX() + cubicP3.getX()) * 0.5f;
        float m3Y = (cubicP2.getY() + cubicP3.getY()) * 0.5f;
        float s1X = (m1X + m2X) * 0.5f;
        float s1Y = (m1Y + m2Y) * 0.5f;
        float s2X = (m2X + m3X) * 0.5f;
        float s2Y = (m2Y + m3Y) * 0.5f;
        Vector2f centerCurvePoint = new Vector2f((s1X + s2X) * 0.5f, (s1Y + s2Y) * 0.5f);
        this.quadraticApproximation[1].setEndPoint((ReadableVector2f)centerCurvePoint);
        this.quadraticApproximation[2].setStartPoint((ReadableVector2f)centerCurvePoint);
        Vector2f control1 = new Vector2f(cubicP0.getX() * 0.25f + m1X * 0.75f, cubicP0.getY() * 0.25f + m1Y * 0.75f);
        this.quadraticApproximation[0].setControlPoint((ReadableVector2f)control1);
        Vector2f control2 = new Vector2f(centerCurvePoint.x * 0.25f + s1X * 0.75f, centerCurvePoint.y * 0.25f + s1Y * 0.75f);
        this.quadraticApproximation[1].setControlPoint((ReadableVector2f)control2);
        Vector2f earlyCurvePoint = new Vector2f((control1.x + control2.x) * 0.5f, (control1.y + control2.y) * 0.5f);
        this.quadraticApproximation[0].setEndPoint((ReadableVector2f)earlyCurvePoint);
        this.quadraticApproximation[1].setStartPoint((ReadableVector2f)earlyCurvePoint);
        Vector2f control3 = new Vector2f(centerCurvePoint.x * 0.25f + s2X * 0.75f, centerCurvePoint.y * 0.25f + s2Y * 0.75f);
        this.quadraticApproximation[2].setControlPoint((ReadableVector2f)control3);
        Vector2f control4 = new Vector2f(cubicP3.getX() * 0.25f + m3X * 0.75f, cubicP3.getY() * 0.25f + m3Y * 0.75f);
        this.quadraticApproximation[3].setControlPoint((ReadableVector2f)control4);
        Vector2f lateCurvePoint = new Vector2f((control3.x + control4.x) * 0.5f, (control3.y + control4.y) * 0.5f);
        this.quadraticApproximation[2].setEndPoint((ReadableVector2f)lateCurvePoint);
        this.quadraticApproximation[3].setStartPoint((ReadableVector2f)lateCurvePoint);
    }

    public Vector2f findPositionByDomain(float tValue, Vector2f dest) {
        if (!$assertionsDisabled && !(tValue >= 0.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(tValue <= 1.0f)) {
            throw new AssertionError();
        }
        if (tValue == 1.0f) {
            return this.quadraticApproximation[3].getPosition(tValue, dest);
        }
        float segIndex = tValue * 4.0f;
        int index = (int)Math.floor(segIndex);
        float relativeT = segIndex - (float)index;
        relativeT = Math.min(relativeT, 1.0f);
        return this.cubicBezier.findPosition(tValue, dest);
    }

    public void drawApproximation() {
        int i = 0;
        while (i < 4) {
            QuadraticBezierSegment quad = this.quadraticApproximation[i];
            GL11.glBegin((int)0);
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            this.plot((ReadableVector2f)quad.getStartPoint());
            this.plot((ReadableVector2f)quad.getControlPoint());
            this.plot((ReadableVector2f)quad.getEndPoint());
            GL11.glEnd();
            ++i;
        }
    }

    private void plot(ReadableVector2f p) {
        GL11.glVertex2f((float)p.getX(), (float)p.getY());
    }
}

