/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry;

import com.shavenpuppy.jglib.geometry.Box;
import com.shavenpuppy.jglib.geometry.Sphere;
import org.lwjgl.util.vector.Vector3f;

public interface Classifier {
    public static final Classification INSIDE = new Classification("Inside"){

        public Classification add(Classification c) {
            if (c == OUTSIDE) {
                return SPANNING;
            }
            if (c == ENCLOSING) {
                return c;
            }
            return this;
        }

        public Classification invert() {
            return ENCLOSING;
        }
    };
    public static final Classification OUTSIDE = new Classification("Outside"){

        public Classification add(Classification c) {
            if (c == INSIDE) {
                return SPANNING;
            }
            if (c == ENCLOSING) {
                return c;
            }
            return this;
        }

        public Classification invert() {
            return this;
        }
    };
    public static final Classification SPANNING = new Classification("Spanning"){

        public Classification add(Classification c) {
            if (c == ENCLOSING) {
                return c;
            }
            return this;
        }

        public Classification invert() {
            return this;
        }
    };
    public static final Classification ENCLOSING = new Classification("Enclosing"){

        public Classification add(Classification c) {
            return this;
        }

        public Classification invert() {
            return INSIDE;
        }
    };

    public Classification classify(float var1, float var2, float var3);

    public Classification classify(float var1, float var2, float var3, float var4);

    public Classification classify(Box var1);

    public Classification classify(Sphere var1);

    public Classification classify(Vector3f var1);

    public static abstract class Classification {
        private final String classification;

        protected Classification(String name) {
            this.classification = name;
        }

        public abstract Classification add(Classification var1);

        public String toString() {
            return this.classification;
        }

        public abstract Classification invert();
    }
}

