/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.geometry;

import com.shavenpuppy.jglib.geometry.Classifier;
import com.shavenpuppy.jglib.geometry.Plane;
import com.shavenpuppy.jglib.geometry.Sphere;
import java.io.Serializable;
import java.util.List;
import org.lwjgl.util.vector.Vector3f;

public class Box
implements Serializable,
Classifier {
    public float px;
    public float py;
    public float pz;
    public float ex;
    public float ey;
    public float ez;

    public Box() {
    }

    public Box(Vector3f position, Vector3f extent) {
        this.px = position.x;
        this.py = position.y;
        this.pz = position.z;
        this.ex = extent.x;
        this.ey = extent.y;
        this.ez = extent.z;
    }

    public Classifier.Classification classify(float x, float y, float z) {
        if (x >= this.px && y >= this.py && z >= this.pz && x <= this.ex && y <= this.ey && z <= this.ez) {
            return INSIDE;
        }
        return OUTSIDE;
    }

    public Classifier.Classification classify(float x, float y, float z, float radius) {
        if (x >= this.px - radius && y >= this.py - radius && z >= this.pz - radius && x <= this.ex + radius && y <= this.ey + radius && z <= this.ez + radius) {
            return INSIDE;
        }
        return OUTSIDE;
    }

    public Classifier.Classification classify(Box b) {
        if ((this.px <= b.px && this.ex >= b.ex || this.px >= b.px && this.px <= b.ex || this.ex >= b.px && this.ex <= b.ex) && (this.py <= b.py && this.ey >= b.ey || this.py >= b.py && this.py <= b.ey || this.ey >= b.py && this.ey <= b.ey) && (this.pz <= b.pz && this.ez >= b.ez || this.pz >= b.pz && this.pz <= b.ez || this.ez >= b.pz && this.ez <= b.ez)) {
            if (this.px <= b.px && this.py <= b.py && this.pz <= b.pz && this.ex >= b.ex && this.ey >= b.ey && this.ez >= b.ez) {
                return INSIDE;
            }
            if (this.px > b.px && this.py > b.py && this.pz > b.pz && this.ex < b.ex && this.ey < b.ey && this.ez < b.ez) {
                return ENCLOSING;
            }
            return SPANNING;
        }
        return OUTSIDE;
    }

    public Plane.Classification classify(Plane p) {
        Plane.Classification classification = p.classify(this.px, this.py, this.pz);
        if ((classification = classification.add(p.classify(this.px, this.py, this.ez))) == Plane.SPANNING) {
            return Plane.SPANNING;
        }
        if ((classification = classification.add(p.classify(this.px, this.ey, this.pz))) == Plane.SPANNING) {
            return Plane.SPANNING;
        }
        if ((classification = classification.add(p.classify(this.px, this.ey, this.ez))) == Plane.SPANNING) {
            return Plane.SPANNING;
        }
        if ((classification = classification.add(p.classify(this.ex, this.py, this.pz))) == Plane.SPANNING) {
            return Plane.SPANNING;
        }
        if ((classification = classification.add(p.classify(this.ex, this.py, this.ez))) == Plane.SPANNING) {
            return Plane.SPANNING;
        }
        if ((classification = classification.add(p.classify(this.ex, this.ey, this.pz))) == Plane.SPANNING) {
            return Plane.SPANNING;
        }
        classification = classification.add(p.classify(this.ex, this.ey, this.ez));
        return classification;
    }

    public Classifier.Classification classify(Sphere s) {
        if (s.x >= this.px - s.radius && s.y >= this.py - s.radius && s.z >= this.pz - s.radius && s.x <= this.ex + s.radius && s.y <= this.ey + s.radius && s.z <= this.ez + s.radius) {
            return INSIDE;
        }
        Classifier.Classification c = s.classify(this.px, this.py, this.pz);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.ex, this.py, this.pz);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.px, this.ey, this.pz);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.ex, this.ey, this.pz);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.px, this.py, this.ez);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.ex, this.py, this.ez);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.px, this.ey, this.ez);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        c = s.classify(this.ex, this.ey, this.ez);
        if (c == Classifier.INSIDE) {
            return Classifier.SPANNING;
        }
        return OUTSIDE;
    }

    public Classifier.Classification classify(Vector3f v) {
        if (v.x >= this.px && v.y >= this.py && v.z >= this.pz && v.x <= this.ex && v.y <= this.ey && v.z <= this.ez) {
            return INSIDE;
        }
        return OUTSIDE;
    }

    public void setExtent(float x, float y, float z) {
        this.ex = x;
        this.ey = y;
        this.ez = z;
    }

    public void setPosition(float x, float y, float z) {
        this.px = x;
        this.py = y;
        this.pz = z;
    }

    public static Box computeAABB(List coords) {
        Box ret = new Box();
        int n = coords.size();
        int i = 0;
        while (i < n) {
            Vector3f c = (Vector3f)coords.get(i);
            if (c.x < ret.px || i == 0) {
                ret.px = c.x;
            } else if (c.x > ret.ex || i == 0) {
                ret.ex = c.x;
            }
            if (c.y < ret.py || i == 0) {
                ret.py = c.y;
            } else if (c.y > ret.ey || i == 0) {
                ret.ey = c.y;
            }
            if (c.z < ret.pz || i == 0) {
                ret.pz = c.z;
            } else if (c.z > ret.ez || i == 0) {
                ret.ez = c.z;
            }
            ++i;
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("Box[");
        sb.append(this.px);
        sb.append(", ");
        sb.append(this.py);
        sb.append(", ");
        sb.append(this.pz);
        sb.append(", ");
        sb.append(this.ex - this.px);
        sb.append(", ");
        sb.append(this.ey - this.py);
        sb.append(", ");
        sb.append(this.ez - this.pz);
        sb.append(']');
        return sb.toString();
    }
}

