/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.algorithms;

import com.shavenpuppy.jglib.algorithms.PathFinder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class AStar
implements PathFinder {
    private final int maxNodes;
    private final NodeList openList;
    private final NodeList closedList;
    private final PathFinder.Map map;
    private ArrayList neighbours = new ArrayList(8);
    private Node end;
    private Node start;
    private int steps;
    private ArrayList path;
    private int state = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.algorithms.AStar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AStar(PathFinder.Map map, int maxNodes) {
        this.map = map;
        this.maxNodes = maxNodes;
        this.openList = new NodeList(maxNodes);
        this.closedList = new NodeList(maxNodes);
    }

    public synchronized void findPath(PathFinder.State startState, PathFinder.State endState, ArrayList path) {
        this.cleanup();
        this.steps = 0;
        this.path = path;
        this.state = 6;
        this.start = new Node(startState, null);
        this.openList.addNode(this.start);
        this.start.g = 0;
        this.start.f = this.start.h = this.map.getDistance(startState, endState);
        this.end = new Node(endState, null);
    }

    public synchronized void cancel() {
        this.state = 5;
        this.cleanup();
    }

    private void cleanup() {
        this.openList.clear();
        this.closedList.clear();
        this.neighbours.clear();
    }

    public synchronized int nextStep() {
        if (this.state == 2 || this.state == 1 || this.state == 5) {
            return this.state;
        }
        if (!$assertionsDisabled && this.state != 6) {
            throw new AssertionError();
        }
        if (this.openList.isEmpty()) {
            this.state = 2;
            this.cleanup();
            return this.state;
        }
        ++this.steps;
        Node n = this.openList.popHead();
        if (n.equals(this.end)) {
            this.goalFound(n);
        } else {
            this.goalNotFound(n);
        }
        return this.state;
    }

    private void goalFound(Node n) {
        this.end.parent = n.parent;
        this.path.clear();
        if (n != this.start) {
            Node nodeChild = n;
            Node nodeParent = n.parent;
            do {
                nodeParent.child = nodeChild;
                nodeChild = nodeParent;
                nodeParent = nodeParent.parent;
            } while (!nodeChild.equals(this.start));
            n = this.start;
            do {
                if ((n = n.child) == null) continue;
                this.path.add(n.userState);
            } while (!n.equals(this.end));
        }
        this.state = 1;
        this.cleanup();
    }

    private void goalNotFound(Node n) {
        this.map.getNeighbours(n.userState, n.parent != null ? n.parent.userState : null, this.neighbours);
        int numNeighbours = this.neighbours.size();
        int i = 0;
        while (i < numNeighbours) {
            Node foundOnClosedList;
            PathFinder.State newState = (PathFinder.State)this.neighbours.get(i);
            int newg = n.g + this.map.getCost(n.userState, newState);
            Node foundOnOpenList = this.openList.getNode(newState);
            if (!(foundOnOpenList != null && foundOnOpenList.g <= newg || (foundOnClosedList = this.closedList.getNode(newState)) != null && foundOnClosedList.g <= newg)) {
                if (foundOnClosedList != null) {
                    this.closedList.removeNode(foundOnClosedList.userState);
                }
                if (foundOnOpenList != null) {
                    this.openList.removeNode(foundOnOpenList.userState);
                }
                Node newNode = new Node(newState, n);
                newNode.g = newg;
                newNode.h = this.map.getDistance(newState, this.end.userState);
                newNode.f = newNode.g + newNode.h;
                if (!this.openList.addNode(newNode)) {
                    this.state = 2;
                    this.cleanup();
                    break;
                }
            }
            ++i;
        }
        if (!this.closedList.addNode(n)) {
            this.state = 2;
            this.cleanup();
        }
    }

    private static class NodeList {
        final Node[] node;
        int count;
        boolean f_sorted;
        HashMap stateMap = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.shavenpuppy.jglib.algorithms.AStar$NodeList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        NodeList(int size) {
            this.node = new Node[size];
        }

        boolean addNode(Node newNode) {
            if (this.count == this.node.length) {
                return false;
            }
            this.f_sorted = false;
            this.node[this.count++] = newNode;
            return true;
        }

        void removeNode(PathFinder.State userState) {
            int index = this.findNode(userState);
            if (!$assertionsDisabled && index == -1) {
                throw new AssertionError();
            }
            this.f_sorted = false;
            this.node[index] = this.node[--this.count];
            this.node[this.count] = null;
        }

        int findNode(PathFinder.State userState) {
            int i = 0;
            while (i < this.count) {
                if (this.node[i].userState.equals(userState)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        Node getNode(PathFinder.State userState) {
            int index = this.findNode(userState);
            if (index == -1) {
                return null;
            }
            return this.node[index];
        }

        void clear() {
            int i = 0;
            while (i < this.count) {
                this.node[i] = null;
                ++i;
            }
            this.count = 0;
        }

        int size() {
            return this.count;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        Node popHead() {
            if (this.count > 0 && !this.f_sorted) {
                Arrays.sort(this.node, 0, this.count);
                this.f_sorted = true;
            }
            Node ret = this.node[0];
            this.node[0] = this.node[--this.count];
            this.node[this.count] = null;
            return ret;
        }
    }

    private static class Node
    implements Comparable {
        Node parent;
        Node child;
        int g;
        int h;
        int f;
        PathFinder.State userState;

        Node(PathFinder.State userState, Node parent) {
            this.userState = userState;
            this.parent = parent;
        }

        public boolean equals(Object obj) {
            return ((Node)obj).userState.equals(this.userState);
        }

        public int compareTo(Object o) {
            Node n2 = (Node)o;
            if (this == n2) {
                return 0;
            }
            if (n2 == null) {
                return 1;
            }
            return this.f > n2.f ? 1 : (this.f == n2.f ? 0 : -1);
        }

        void dup(Node src) {
            this.g = src.g;
            this.h = src.h;
            this.f = src.f;
        }
    }
}

