/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.LinuxDisplayPeerInfo;
import org.lwjgl.opengl.LinuxPbufferPeerInfo;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;

final class LinuxDisplay
implements DisplayImplementation {
    private static final int NUM_BUTTONS = 3;
    private static int display_connection_usage_count = 0;
    private static PeerInfo peer_info;

    LinuxDisplay() {
    }

    static native void lockAWT();

    static native void unlockAWT();

    static void incDisplay() throws LWJGLException {
        if (display_connection_usage_count == 0) {
            GLContext.loadOpenGLLibrary();
            LinuxDisplay.openDisplay();
        }
        ++display_connection_usage_count;
    }

    static void decDisplay() {
        if (--display_connection_usage_count < 0) {
            throw new InternalError("display_connection_usage_count < 0: " + display_connection_usage_count);
        }
        if (display_connection_usage_count == 0) {
            LinuxDisplay.closeDisplay();
            GLContext.unloadOpenGLLibrary();
        }
    }

    private static native void openDisplay() throws LWJGLException;

    private static native void closeDisplay();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWindow(DisplayMode mode, boolean fullscreen, int x, int y) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            ByteBuffer handle = peer_info.lockAndGetHandle();
            try {
                LinuxDisplay.nCreateWindow(handle, mode, fullscreen, x, y);
            }
            finally {
                peer_info.unlock();
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nCreateWindow(ByteBuffer var0, DisplayMode var1, boolean var2, int var3, int var4) throws LWJGLException;

    public void destroyWindow() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyWindow();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyWindow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchDisplayMode(DisplayMode mode) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSwitchDisplayMode(mode);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSwitchDisplayMode(DisplayMode var0) throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDisplayMode() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nResetDisplayMode();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nResetDisplayMode();

    public int getGammaRampLength() {
        LinuxDisplay.lockAWT();
        int length = LinuxDisplay.nGetGammaRampLength();
        LinuxDisplay.unlockAWT();
        return length;
    }

    private static native int nGetGammaRampLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGammaRamp(FloatBuffer gammaRamp) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nSetGammaRamp(gammaRamp);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nSetGammaRamp(FloatBuffer var0) throws LWJGLException;

    public String getAdapter() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode init() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode mode;
            DisplayMode displayMode = mode = LinuxDisplay.nInit();
            return displayMode;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode nInit() throws LWJGLException;

    public void setTitle(String title) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nSetTitle(title);
        LinuxDisplay.unlockAWT();
    }

    private static native void nSetTitle(String var0);

    public boolean isCloseRequested() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsCloseRequested();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsCloseRequested();

    public boolean isVisible() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsVisible();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsVisible();

    public boolean isActive() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsActive();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsActive();

    public boolean isDirty() {
        LinuxDisplay.lockAWT();
        boolean result = LinuxDisplay.nIsDirty();
        LinuxDisplay.unlockAWT();
        return result;
    }

    private static native boolean nIsDirty();

    public PeerInfo createPeerInfo(PixelFormat pixel_format) throws LWJGLException {
        peer_info = new LinuxDisplayPeerInfo(pixel_format);
        return peer_info;
    }

    public void update() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nUpdate();
        LinuxDisplay.unlockAWT();
    }

    private static native void nUpdate();

    public void reshape(int x, int y, int width, int height) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nReshape(x, y, width, height);
        LinuxDisplay.unlockAWT();
    }

    private static native void nReshape(int var0, int var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            DisplayMode[] modes;
            DisplayMode[] displayModeArray = modes = LinuxDisplay.nGetAvailableDisplayModes();
            return displayModeArray;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native DisplayMode[] nGetAvailableDisplayModes() throws LWJGLException;

    public boolean hasWheel() {
        return true;
    }

    public int getButtonCount() {
        return 3;
    }

    public void createMouse() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nCreateMouse();
        LinuxDisplay.unlockAWT();
    }

    private static native void nCreateMouse();

    public void destroyMouse() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyMouse();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyMouse();

    public void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nPollMouse(coord_buffer, buttons);
        LinuxDisplay.unlockAWT();
    }

    private static native void nPollMouse(IntBuffer var0, ByteBuffer var1);

    public int readMouse(IntBuffer buffer, int buffer_position) {
        LinuxDisplay.lockAWT();
        int count = LinuxDisplay.nReadMouse(buffer, buffer_position);
        LinuxDisplay.unlockAWT();
        return count;
    }

    private static native int nReadMouse(IntBuffer var0, int var1);

    public void setCursorPosition(int x, int y) {
        LinuxDisplay.lockAWT();
        this.nSetCursorPosition(x, y);
        LinuxDisplay.unlockAWT();
    }

    private native void nSetCursorPosition(int var1, int var2);

    public void grabMouse(boolean grab) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nGrabMouse(grab);
        LinuxDisplay.unlockAWT();
    }

    private static native void nGrabMouse(boolean var0);

    public int getNativeCursorCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int caps = LinuxDisplay.nGetNativeCursorCapabilities();
            LinuxDisplay.decDisplay();
            int n = caps;
            return n;
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetNativeCursorCapabilities() throws LWJGLException;

    public void setNativeCursor(Object handle) throws LWJGLException {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nSetNativeCursor(handle);
        LinuxDisplay.unlockAWT();
    }

    private static native void nSetNativeCursor(Object var0) throws LWJGLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int min_size = LinuxDisplay.nGetMinCursorSize();
            LinuxDisplay.decDisplay();
            int n = min_size;
            return n;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred in getMinCursorSize: " + e);
            int n = 0;
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMinCursorSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCursorSize() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int max_size = LinuxDisplay.nGetMaxCursorSize();
            LinuxDisplay.decDisplay();
            int n = max_size;
            return n;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred in getMaxCursorSize: " + e);
            int n = 0;
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetMaxCursorSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createKeyboard() throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.nCreateKeyboard();
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native void nCreateKeyboard() throws LWJGLException;

    public void destroyKeyboard() {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyKeyboard();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyKeyboard();

    public void pollKeyboard(ByteBuffer keyDownBuffer) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nPollKeyboard(keyDownBuffer);
        LinuxDisplay.unlockAWT();
    }

    private static native void nPollKeyboard(ByteBuffer var0);

    public int readKeyboard(IntBuffer buffer, int buffer_position) {
        LinuxDisplay.lockAWT();
        int count = LinuxDisplay.nReadKeyboard(buffer, buffer_position);
        LinuxDisplay.unlockAWT();
        return count;
    }

    private static native int nReadKeyboard(IntBuffer var0, int var1);

    public int isStateKeySet(int key) {
        return 2;
    }

    private static native ByteBuffer nCreateCursor(int var0, int var1, int var2, int var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8) throws LWJGLException;

    public Object createCursor(int width, int height, int xHotspot, int yHotspot, int numImages, IntBuffer images, IntBuffer delays) throws LWJGLException {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            try {
                ByteBuffer byteBuffer = LinuxDisplay.nCreateCursor(width, height, xHotspot, yHotspot, numImages, images, images.position(), delays, delays != null ? delays.position() : -1);
                return byteBuffer;
            }
            catch (LWJGLException e) {
                LinuxDisplay.decDisplay();
                throw e;
            }
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    public void destroyCursor(Object cursorHandle) {
        LinuxDisplay.lockAWT();
        LinuxDisplay.nDestroyCursor(cursorHandle);
        LinuxDisplay.decDisplay();
        LinuxDisplay.unlockAWT();
    }

    private static native void nDestroyCursor(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPbufferCapabilities() {
        LinuxDisplay.lockAWT();
        try {
            LinuxDisplay.incDisplay();
            int caps = LinuxDisplay.nGetPbufferCapabilities();
            LinuxDisplay.decDisplay();
            int n = caps;
            return n;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred in getPbufferCapabilities: " + e);
            int n = 0;
            return n;
        }
        finally {
            LinuxDisplay.unlockAWT();
        }
    }

    private static native int nGetPbufferCapabilities();

    public boolean isBufferLost(PeerInfo handle) {
        return false;
    }

    public PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, IntBuffer pixelFormatCaps, IntBuffer pBufferAttribs) throws LWJGLException {
        return new LinuxPbufferPeerInfo(width, height, pixel_format);
    }

    public void setPbufferAttrib(PeerInfo handle, int attrib, int value) {
        throw new UnsupportedOperationException();
    }

    public void bindTexImageToPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public void releaseTexImageFromPbuffer(PeerInfo handle, int buffer) {
        throw new UnsupportedOperationException();
    }

    public int setIcon(ByteBuffer[] icons) {
        for (int i = 0; i < icons.length; ++i) {
            int size = icons[i].limit() / 4;
            if ((int)Math.sqrt(size) != 32) continue;
            LinuxDisplay.nSetWindowIcon(icons[i]);
            return 1;
        }
        return 0;
    }

    private static native int nSetWindowIcon(ByteBuffer var0);
}

