/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.SysImplementation;
import org.lwjgl.input.Mouse;

public final class Sys {
    public static final String VERSION = "0.98";
    private static final String LIBRARY_NAME = "lwjgl";
    private static final SysImplementation implementation = Sys.createImplementation();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;

    private static SysImplementation createImplementation() {
        String class_name;
        switch (LWJGLUtil.getPlatform()) {
            case 1: {
                class_name = "org.lwjgl.LinuxSysImplementation";
                break;
            }
            case 3: {
                class_name = "org.lwjgl.Win32SysImplementation";
                break;
            }
            case 2: {
                class_name = "org.lwjgl.MacOSXSysImplementation";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported platform");
            }
        }
        try {
            Class<?> impl_class = Class.forName(class_name);
            return (SysImplementation)impl_class.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private Sys() {
    }

    public static void initialize() {
    }

    public static long getTimerResolution() {
        return implementation.getTimerResolution();
    }

    public static long getTime() {
        return implementation.getTime() & Long.MAX_VALUE;
    }

    public static void alert(String title, String message) {
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed) {
            Mouse.setGrabbed(false);
        }
        if (title == null) {
            title = "";
        }
        if (message == null) {
            message = "";
        }
        implementation.alert(title, message);
        if (grabbed) {
            Mouse.setGrabbed(true);
        }
    }

    public static boolean openURL(String url) {
        try {
            final Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return serviceManagerClass.getMethod("lookup", class$java$lang$String == null ? (class$java$lang$String = Sys.class$("java.lang.String")) : class$java$lang$String);
                }
            });
            Object basicService = lookupMethod.invoke(serviceManagerClass, "javax.jnlp.BasicService");
            final Class<?> basicServiceClass = Class.forName("javax.jnlp.BasicService");
            Method showDocumentMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return basicServiceClass.getMethod("showDocument", class$java$net$URL == null ? (class$java$net$URL = Sys.class$("java.net.URL")) : class$java$net$URL);
                }
            });
            try {
                Boolean ret = (Boolean)showDocumentMethod.invoke(basicService, new URL(url));
                return ret;
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        catch (Exception ue) {
            return implementation.openURL(url);
        }
    }

    public static String getClipboard() {
        return implementation.getClipboard();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary(Sys.LIBRARY_NAME);
                return null;
            }
        });
        String native_version = implementation.getNativeLibraryVersion();
        if (!native_version.equals(VERSION)) {
            throw new LinkageError("Version mismatch: jar version is '0.98', native libary version is '" + native_version + "'");
        }
        implementation.setDebug(LWJGLUtil.DEBUG);
    }
}

