/*
 * Decompiled with CFR 0.152.
 */
package king.lib.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import king.lib.browser.BrowserCommandLexer;

public class Browser {
    protected static BrowserDialog dialog;
    protected static ResourceBundle labels;
    public static String[] exec;
    private static JTextArea description;
    private static JTextArea commandLinesArea;
    private static JButton resetButton;
    private static JButton browseButton;
    private static JLabel commandLinesLabel;
    private static JFileChooser fileChooser;
    private static JPanel dialogPanel;
    private static Window dialogParent;

    public static void setLocale(Locale locale) {
        labels = ResourceBundle.getBundle("king.lib.browser.Browser", locale);
    }

    public static void init() {
        exec = Browser.defaultCommands();
    }

    public static String[] defaultCommands() {
        Object object = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            object = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            Vector<String> vector = new Vector<String>();
            try {
                Process process = Runtime.getRuntime().exec("which open");
                if (process.waitFor() == 0) {
                    vector.add("open {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = vector.size() == 0 ? null : vector.toArray(new String[0]);
        } else if (System.getProperty("os.name").startsWith("SunOS")) {
            object = new String[]{"/usr/dt/bin/sdtwebclient {0}"};
        } else {
            Process process;
            Vector<String> vector = new Vector<String>();
            try {
                process = Runtime.getRuntime().exec("which firebird");
                if (process.waitFor() == 0) {
                    vector.add("firebird -remote openURL({0})");
                    vector.add("firebird {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which mozilla");
                if (process.waitFor() == 0) {
                    vector.add("mozilla -remote openURL({0})");
                    vector.add("mozilla {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which opera");
                if (process.waitFor() == 0) {
                    vector.add("opera -remote openURL({0})");
                    vector.add("opera {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which galeon");
                if (process.waitFor() == 0) {
                    vector.add("galeon {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which konqueror");
                if (process.waitFor() == 0) {
                    vector.add("konqueror {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which netscape");
                if (process.waitFor() == 0) {
                    vector.add("netscape -remote openURL({0})");
                    vector.add("netscape {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process = Runtime.getRuntime().exec("which xterm");
                if (process.waitFor() == 0 && (process = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    vector.add("xterm -e lynx {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = vector.size() == 0 ? null : vector.toArray(new String[0]);
        }
        return object;
    }

    public static void save(Properties properties) {
        int n;
        Object object;
        boolean bl = false;
        if (exec != null && exec.length > 0) {
            object = Browser.defaultCommands();
            if (object != null && ((String[])object).length == exec.length) {
                for (n = 0; n < ((Object)object).length; ++n) {
                    if (((String)object[n]).equals(exec[n])) continue;
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            object = new StringBuffer();
            for (n = 0; exec != null && n < exec.length; ++n) {
                ((StringBuffer)object).append(exec[n]).append('\n');
            }
            properties.put("com.Ostermiller.util.Browser.open", ((StringBuffer)object).toString());
        } else {
            properties.remove("com.Ostermiller.util.Browser.open");
        }
    }

    public static void load(Properties properties) {
        if (properties.containsKey("com.Ostermiller.util.Browser.open")) {
            StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("com.Ostermiller.util.Browser.open"), "\r\n", false);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            exec = stringArray;
        } else {
            Browser.init();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void displayURL(String string) throws IOException {
        if (exec == null || exec.length == 0) {
            Class<?> clazz;
            Object object;
            if (!System.getProperty("os.name").startsWith("Mac")) throw new IOException(labels.getString("nocommand"));
            boolean bl = false;
            try {
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    object = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                    clazz = Class.forName("com.apple.cocoa.application.NSWorkspace", true, (ClassLoader)object);
                } else {
                    clazz = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                object = clazz.getMethod("sharedWorkspace", new Class[0]);
                Object object2 = ((Method)object).invoke(null, new Object[0]);
                Method method = clazz.getMethod("openURL", Class.forName("java.net.URL"));
                bl = (Boolean)method.invoke(object2, new URL(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) return;
            try {
                clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                object = clazz.getMethod("openURL", Class.forName("java.lang.String"));
                ((Method)object).invoke(null, string);
                return;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                throw new IOException(labels.getString("failed"));
            }
        }
        new URL(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                stringBuffer.append(c);
                continue;
            }
            if ((c = (char)(c & 0xFF)) < '\u0010') {
                stringBuffer.append("%0" + Integer.toHexString(c));
                continue;
            }
            stringBuffer.append("%" + Integer.toHexString(c));
        }
        String[] stringArray = new String[]{stringBuffer.toString()};
        String string2 = null;
        boolean bl = false;
        try {
            for (int i = 0; i < exec.length && !bl; ++i) {
                try {
                    Object object;
                    String string3;
                    string2 = MessageFormat.format(exec[i], stringArray);
                    Vector<String> vector = new Vector<String>();
                    BrowserCommandLexer browserCommandLexer = new BrowserCommandLexer(new StringReader(string2));
                    while ((string3 = browserCommandLexer.getNextToken()) != null) {
                        vector.add(string3);
                    }
                    String[] stringArray2 = new String[vector.size()];
                    stringArray2 = vector.toArray(stringArray2);
                    boolean bl2 = false;
                    if (stringArray2[0].equals("rundll32") && stringArray2[1].equals("url.dll,FileProtocolHandler")) {
                        if (stringArray2[2].startsWith("file:/")) {
                            if (stringArray2[2].charAt(6) != '/') {
                                stringArray2[2] = "file://" + stringArray2[2].substring(6);
                            }
                            if (stringArray2[2].charAt(7) != '/') {
                                stringArray2[2] = "file:///" + stringArray2[2].substring(7);
                            }
                            bl2 = true;
                        } else if (stringArray2[2].toLowerCase().endsWith("html") || stringArray2[2].toLowerCase().endsWith("htm")) {
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        object = File.createTempFile("OpenInBrowser", ".url");
                        object = ((File)object).getCanonicalFile();
                        ((File)object).deleteOnExit();
                        PrintWriter printWriter = new PrintWriter(new FileWriter((File)object));
                        printWriter.println("[InternetShortcut]");
                        printWriter.println("URL=" + stringArray2[2]);
                        printWriter.close();
                        stringArray2[2] = ((File)object).getCanonicalPath();
                    }
                    object = Runtime.getRuntime().exec(stringArray2);
                    for (int j = 0; j < 2; ++j) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (((Process)object).exitValue() != 0) continue;
                    bl = true;
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println(labels.getString("warning") + " " + iOException.getMessage());
                }
            }
            if (bl) return;
            throw new IOException(labels.getString("failed"));
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void displayURLs(String[] stringArray) throws IOException {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (stringArray.length == 1) {
            Browser.displayURL(stringArray[0]);
            return;
        }
        File file = File.createTempFile("DisplayURLs", ".html");
        file = file.getCanonicalFile();
        file.deleteOnExit();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("<!-- saved from url=(0014)about:internet -->");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + labels.getString("html.openurls") + "</title>");
        printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
        printWriter.println("function displayURLs(){");
        for (n = 1; n < stringArray.length; ++n) {
            printWriter.println("window.open(\"" + stringArray[n] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        printWriter.println("location.href=\"" + stringArray[0] + "\";");
        printWriter.println("}");
        printWriter.println("</script>");
        printWriter.println("</head>");
        printWriter.println("<body onload=\"javascript:displayURLs()\">");
        printWriter.println("<noscript>");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.println("<a target=\"_blank\" href=\"" + stringArray[n] + "\">" + stringArray[n] + "</a><br>");
        }
        printWriter.println("</noscript>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
        Browser.displayURL(file.toURL().toString());
    }

    public static void displayURLinNew(String string) throws IOException {
        Browser.displayURLsinNew(new String[]{string});
    }

    public static void displayURLsinNew(String[] stringArray) throws IOException {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        File file = File.createTempFile("DisplayURLs", ".html");
        file.deleteOnExit();
        file = file.getCanonicalFile();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("<!-- saved from url=(0014)about:internet -->");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + labels.getString("html.openurls") + "</title>");
        printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
        printWriter.println("function displayURLs(){");
        printWriter.println("var hlength = 0;");
        printWriter.println("try {");
        printWriter.println("hlength = history.length;");
        printWriter.println("} catch (e) {}");
        printWriter.println("if (hlength>0) {");
        printWriter.println("window.open(\"" + stringArray[0] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        printWriter.println("}");
        for (n = 1; n < stringArray.length; ++n) {
            printWriter.println("window.open(\"" + stringArray[n] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        printWriter.println("if (hlength==0) {");
        printWriter.println("location.href=\"" + stringArray[0] + "\";");
        printWriter.println("} else {");
        printWriter.println("history.back()");
        printWriter.println("}");
        printWriter.println("}");
        printWriter.println("</script>");
        printWriter.println("</head>");
        printWriter.println("<body onload=\"javascript:displayURLs()\">");
        printWriter.println("<noscript>");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.println("<a target=\"_blank\" href=\"" + stringArray[n] + "\">" + stringArray[n] + "</a><br>");
        }
        printWriter.println("</noscript>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
        Browser.displayURL(file.toURL().toString());
    }

    public static void displayURL(String string, String string2) throws IOException {
        Browser.displayURLs(new String[]{string}, new String[]{string2});
    }

    public static void displayURLs(String[] stringArray, String[] stringArray2) throws IOException {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        File file = File.createTempFile("DisplayURLs", ".html");
        file.deleteOnExit();
        file = file.getCanonicalFile();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("<!-- saved from url=(0014)about:internet -->");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>" + labels.getString("html.openurls") + "</title>");
        printWriter.println("<base target=\"" + (stringArray2 == null || stringArray2.length == 0 || stringArray2[0] == null ? "_blank" : stringArray2[0]) + "\">");
        printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
        for (n = 1; n < stringArray.length; ++n) {
            printWriter.println("window.open(\"" + stringArray[n] + "\", \"" + (stringArray2 == null || stringArray2.length <= n || stringArray2[n] == null ? "_blank" : stringArray2[n]) + "\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        printWriter.println("location.href=\"" + stringArray[0] + "\";");
        printWriter.println("</script>");
        printWriter.println("</head>");
        printWriter.println("<body onload=\"javascript:displayURLs()\">");
        printWriter.println("<noscript>");
        for (n = 0; n < stringArray.length; ++n) {
            printWriter.println("<a target=\"" + (stringArray2 == null || stringArray2.length == 0 || stringArray2[0] == null ? "_blank" : stringArray2[0]) + "\" href=\"" + stringArray[n] + "\">" + stringArray[n] + "</a><br>");
        }
        printWriter.println("</noscript>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
        Browser.displayURL(file.toURL().toString());
    }

    public static void displayURLs(String[] stringArray, String string) throws IOException {
        Browser.displayURLs(stringArray, new String[]{string});
    }

    public static void main(String[] stringArray) {
        try {
            Browser.init();
            if (Browser.dialogConfiguration(null)) {
                if (stringArray.length == 0) {
                    Browser.displayURLs(new String[]{"http://www.google.com/", "http://dmoz.org/", "http://ostermiller.org"}, "fun");
                } else if (stringArray.length == 1) {
                    Browser.displayURL(stringArray[0], "fun");
                } else {
                    Browser.displayURLs(stringArray, "fun");
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        System.exit(0);
    }

    public static boolean dialogConfiguration(Frame frame) {
        Browser.dialogConfiguration(frame, null);
        return dialog.changed();
    }

    public static boolean dialogConfiguration(Frame frame, Properties properties) {
        if (dialog == null) {
            dialog = new BrowserDialog(frame);
        }
        if (properties != null) {
            Browser.dialog.setProps(properties);
        }
        dialog.show();
        return dialog.changed();
    }

    public static JPanel getDialogPanel(Window window) {
        dialogParent = window;
        if (dialogPanel == null) {
            commandLinesArea = new JTextArea("", 8, 40);
            JScrollPane jScrollPane = new JScrollPane(commandLinesArea);
            resetButton = new JButton(labels.getString("dialog.reset"));
            browseButton = new JButton(labels.getString("dialog.browse"));
            commandLinesLabel = new JLabel(labels.getString("dialog.commandLines"));
            description = new JTextArea(labels.getString("dialog.description"));
            description.setEditable(false);
            description.setOpaque(false);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object == resetButton) {
                        Browser.setCommands(Browser.defaultCommands());
                    } else if (object == browseButton) {
                        if (fileChooser == null) {
                            fileChooser = new JFileChooser();
                        }
                        if (fileChooser.showOpenDialog(dialogParent) == 0) {
                            String string;
                            String string2 = fileChooser.getSelectedFile().getPath();
                            StringBuffer stringBuffer = new StringBuffer(2 * string2.length());
                            for (int i = 0; i < string2.length(); ++i) {
                                char c = string2.charAt(i);
                                if (c == '\"' || c == '\\') {
                                    stringBuffer.append('\\');
                                }
                                stringBuffer.append(c);
                            }
                            string2 = stringBuffer.toString();
                            if (string2.indexOf(" ") != -1) {
                                string2 = '\"' + string2 + '\"';
                            }
                            if ((string = commandLinesArea.getText()).length() != 0 && !string.endsWith("\n") && !string.endsWith("\r")) {
                                string = string + "\n";
                            }
                            commandLinesArea.setText(string + string2 + " {0}");
                        }
                    }
                }
            };
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 5;
            dialogPanel = new JPanel(gridBagLayout);
            dialogPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 20));
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(description, gridBagConstraints);
            dialogPanel.add(description);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(commandLinesLabel, gridBagConstraints);
            dialogPanel.add(commandLinesLabel);
            JPanel jPanel = new JPanel();
            gridBagConstraints.anchor = 13;
            browseButton.addActionListener(actionListener);
            jPanel.add(browseButton);
            resetButton.addActionListener(actionListener);
            jPanel.add(resetButton);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            dialogPanel.add(jPanel);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            dialogPanel.add(jScrollPane);
        }
        return dialogPanel;
    }

    private static void setCommands(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append('\n');
        }
        commandLinesArea.setText(stringBuffer.toString());
    }

    public static void initPanel() {
        Browser.setCommands(exec);
    }

    public static void userOKedPanelChanges() {
        StringTokenizer stringTokenizer = new StringTokenizer(commandLinesArea.getText(), "\r\n", false);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        exec = stringArray;
    }

    static {
        labels = ResourceBundle.getBundle("king.lib.browser.Browser", Locale.getDefault());
        exec = null;
        dialogPanel = null;
        dialogParent = null;
    }

    private static class BrowserDialog
    extends JDialog {
        private JButton okButton;
        private JButton cancelButton;
        private JLabel commandLinesLabel;
        private boolean pressed_OK = false;

        private void setProps(Properties properties) {
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.title")) {
                this.setTitle(properties.getProperty("com.Ostermiller.util.BrowserDialog.title"));
            }
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.description")) {
                description.setText(properties.getProperty("com.Ostermiller.util.BrowserDialog.description"));
            }
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.label")) {
                this.commandLinesLabel.setText(properties.getProperty("com.Ostermiller.util.BrowserDialog.label"));
            }
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.defaults")) {
                resetButton.setText(properties.getProperty("com.Ostermiller.util.BrowserDialog.defaults"));
            }
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.browse")) {
                browseButton.setText(properties.getProperty("com.Ostermiller.util.BrowserDialog.browse"));
            }
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.ok")) {
                this.okButton.setText(properties.getProperty("com.Ostermiller.util.BrowserDialog.ok"));
            }
            if (properties.containsKey("com.Ostermiller.util.BrowserDialog.cancel")) {
                this.cancelButton.setText(properties.getProperty("com.Ostermiller.util.BrowserDialog.cancel"));
            }
            this.pack();
        }

        public boolean changed() {
            return this.pressed_OK;
        }

        public BrowserDialog(Frame frame) {
            super(frame, labels.getString("dialog.title"), true);
            this.setLocationRelativeTo(frame);
        }

        protected void dialogInit() {
            super.dialogInit();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)Browser.getDialogPanel(this), "Center");
            JPanel jPanel = new JPanel(new FlowLayout());
            this.okButton = new JButton(labels.getString("dialog.ok"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserDialog.this.pressed_OK = true;
                    BrowserDialog.this.setVisible(false);
                }
            });
            jPanel.add(this.okButton);
            this.cancelButton = new JButton(labels.getString("dialog.cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BrowserDialog.this.pressed_OK = false;
                    BrowserDialog.this.setVisible(false);
                }
            });
            jPanel.add(this.cancelButton);
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
        }

        public void show() {
            this.setVisible(true);
        }

        public void setVisible(boolean bl) {
            if (bl) {
                Browser.initPanel();
                super.setVisible(true);
                if (this.pressed_OK) {
                    Browser.userOKedPanelChanges();
                }
            } else {
                super.setVisible(false);
            }
        }
    }
}

