/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.api.launcher.Variables;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class LauncherVariables {
    private static boolean installerVariablesError = false;

    public static String replaceVariables(String string) {
        string = StringUtil.replaceVariable(string, "${", "}", new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                if (string.startsWith("installer:")) {
                    return LauncherVariables.getInstallerVariable(string.substring("installer:".length()));
                }
                if (string.indexOf(58) == -1) {
                    return (String)VersionSpecificHelper.getenv().get(string);
                }
                return null;
            }
        });
        return string;
    }

    public static Properties replaceVariables(Properties properties) {
        Properties properties2 = new Properties();
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = LauncherVariables.replaceVariables((String)entry.getValue());
            properties2.put(string, string2);
        }
        return properties2;
    }

    public static void init(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = LauncherVariables.replaceVariables(stringArray[i]);
            }
        }
        LauncherVariables.replaceSystemProperties();
    }

    private static String getInstallerVariable(String string) {
        if (installerVariablesError) {
            return null;
        }
        try {
            Object object = Variables.getInstallerVariable(string);
            if (object == null) {
                return "null";
            }
            return object.toString();
        }
        catch (IOException iOException) {
            installerVariablesError = true;
            iOException.printStackTrace();
            return null;
        }
    }

    private static void replaceSystemProperties() {
        Properties properties = System.getProperties();
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.size());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = LauncherVariables.replaceVariables(System.getProperty(string));
            System.setProperty(string, string2);
        }
    }
}

