/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.update.UpdateScheduleRegistry;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.launcher.WindowChecker;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.w3c.dom.Element;

public class LauncherIntegration {
    public static final String PROPNAME_LAUNCHER_ID = "install4j.launcherId";
    public static final String FILE_NAME = "launchers.xml";
    public static final String ELEMENT_ROOT = "launcherIntegrations";
    public static final String ELEMENT_LAUNCHER = "launcher";
    public static final String ELEMENT_APPLICATION = "application";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_LAUNCH_MODE = "launchMode";
    public static final String ATTRIBUTE_LAUNCH_IN_NEW_PROCESS = "launchInNewProcess";
    public static final String ATTRIBUTE_LAUNCH_SCHEDULE = "launchSchedule";
    public static final String LAUNCH_MODE_STARTUP_SYNC = "startupSync";
    public static final String LAUNCH_MODE_STARTUP_ASNYC = "startupAsync";
    public static final String LAUNCH_MODE_FIRST_WINDOW = "startupFirstWindow";
    public static final String LAUNCH_SCHEDULE_UPDATE_SCHEDULE = "updateSchedule";
    public static final String LAUNCH_SCHEDULE_ALWAYS = "always";
    public static final String LAUNCH_SCHEDULE_FIRST_RUN = "firstRun";

    private LauncherIntegration() {
    }

    public static void checkIntegrations() {
        File file;
        String string = System.getProperty(PROPNAME_LAUNCHER_ID);
        if (string != null && (file = InstallerUtil.getInstallerFile(FILE_NAME)).exists()) {
            try {
                LauncherIntegration.processLauncherIntegrations(file, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void processLauncherIntegrations(File file, String string) throws IOException {
        Element element = XmlHelper.parseFile(file).getDocumentElement();
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string2 = XmlHelper.readAttribute(element2, ATTRIBUTE_ID, "");
            if (!string2.equals(string)) continue;
            LauncherIntegration.processLauncherIntegrations(element2);
        }
    }

    private static void processLauncherIntegrations(Element element) throws IOException {
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            LauncherIntegration.processLauncherIntegration(element2);
        }
    }

    private static void processLauncherIntegration(Element element) throws IOException {
        final String string = XmlHelper.readAttribute(element, ATTRIBUTE_ID, "");
        String string2 = XmlHelper.readAttribute(element, ATTRIBUTE_LAUNCH_MODE, "");
        final boolean bl = XmlHelper.readAttribute(element, ATTRIBUTE_LAUNCH_IN_NEW_PROCESS, false);
        String string3 = XmlHelper.readAttribute(element, ATTRIBUTE_LAUNCH_SCHEDULE, "");
        if (string3.equals(LAUNCH_SCHEDULE_FIRST_RUN) ? !Boolean.getBoolean("install4j.firstRun") : string3.equals(LAUNCH_SCHEDULE_UPDATE_SCHEDULE) && !UpdateScheduleRegistry.checkAndReset()) {
            return;
        }
        if (string2.equals(LAUNCH_MODE_FIRST_WINDOW)) {
            WindowChecker.onFirstWindowShown(new Runnable(){

                public void run() {
                    try {
                        if (bl) {
                            ApplicationLauncher.launchApplication(string, null, false, null);
                        } else {
                            ApplicationLauncher.launchApplicationInProcess(string, null, null, ApplicationLauncher.WindowMode.FRAME, null);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        } else {
            boolean bl2 = string2.equals(LAUNCH_MODE_STARTUP_SYNC);
            if (bl) {
                ApplicationLauncher.launchApplication(string, null, bl2, null);
            } else {
                GUIHelper.setLaF();
                Runnable runnable = new Runnable(){

                    public void run() {
                        ApplicationLauncher.launchApplicationInProcess(string, null, null, ApplicationLauncher.WindowMode.FRAME, null);
                    }
                };
                if (bl2) {
                    runnable.run();
                } else {
                    new Thread(runnable).start();
                }
            }
        }
    }
}

