/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileCommunicationBackend
implements CommunicationBackend {
    private static final int RETRY_TIME = 100;
    private static final int TIMEOUT = 3000;
    private static final String SPAWNED_SUFFIX = ".spawned";
    private static final String LISTENER_SUFFIX = ".listener";
    private static final String AVAILABLE_SUFFIX = ".a";
    private String baseFile;
    private boolean listener = false;

    public boolean writeDataBlock(byte[] byArray, boolean bl) {
        try {
            String string = this.baseFile + (this.listener ? LISTENER_SUFFIX : SPAWNED_SUFFIX);
            File file = new File(string);
            File file2 = new File(string + AVAILABLE_SUFFIX);
            this.waitForFile(file2, false, bl);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            this.setContent(file2, 2L);
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return false;
    }

    public byte[] readDataBlock(boolean bl) {
        try {
            String string = this.baseFile + (this.listener ? SPAWNED_SUFFIX : LISTENER_SUFFIX);
            File file = new File(string);
            File file2 = new File(string + AVAILABLE_SUFFIX);
            this.waitForFile(file2, true, bl);
            byte[] byArray = new byte[(int)file.length()];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            this.setContent(file2, 1L);
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return null;
    }

    public void sendKeepAlive() {
        String string = this.baseFile + (this.listener ? LISTENER_SUFFIX : SPAWNED_SUFFIX);
        File file = new File(string + AVAILABLE_SUFFIX);
        try {
            this.waitForFile(file, false, false);
            this.setContent(file, file.length() + 2L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void waitForFile(File file, boolean bl, boolean bl2) throws InterruptedException, IOException {
        int n = 0;
        long l = file.length();
        while (bl && l % 2L == 1L || !bl && l % 2L == 0L) {
            Thread.sleep(100L);
            if (bl2 && ++n > 3000) {
                throw new IOException("timeout waiting for " + file);
            }
            long l2 = file.length();
            if (l2 != l) {
                n = 0;
            }
            l = l2;
        }
    }

    private void setContent(File file, long l) throws IOException {
        boolean bl = !file.exists();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        randomAccessFile.setLength(l);
        randomAccessFile.close();
        if (bl) {
            UnixFileSystem.setMode("666", file);
            file.deleteOnExit();
        }
    }

    public String createListener() {
        try {
            this.listener = true;
            File file = Util.isMacOS() ? new File("/var/tmp") : null;
            File file2 = File.createTempFile("i4c", ".com", file);
            file2.deleteOnExit();
            String string = file2.getAbsolutePath();
            while (new File(string + LISTENER_SUFFIX).exists() || new File(string + LISTENER_SUFFIX + AVAILABLE_SUFFIX).exists() || new File(string + SPAWNED_SUFFIX).exists() || new File(string + SPAWNED_SUFFIX + AVAILABLE_SUFFIX).exists()) {
                file2 = File.createTempFile("i4c", ".com", file);
                file2.deleteOnExit();
                string = file2.getAbsolutePath();
            }
            this.baseFile = string;
            this.setContent(new File(string + LISTENER_SUFFIX), 1L);
            this.setContent(new File(string + LISTENER_SUFFIX + AVAILABLE_SUFFIX), 1L);
            this.setContent(new File(string + SPAWNED_SUFFIX), 1L);
            this.setContent(new File(string + SPAWNED_SUFFIX + AVAILABLE_SUFFIX), 1L);
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public boolean connect(String string) {
        if (string == null) {
            if (this.baseFile == null) {
                return false;
            }
        } else {
            this.baseFile = string;
        }
        return true;
    }

    public boolean isProcessAlive(int n) {
        return true;
    }

    public int getProcessId() {
        return -1;
    }
}

