/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

public class MacosUserInfo {
    public static final String ELEVATION_EXECUTABLE = "install4j";

    public static boolean isAdminUser() {
        try {
            String string;
            if (UnixUserInfo.ROOT_USER) {
                return true;
            }
            Process process = Runtime.getRuntime().exec("groups");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("admin") <= -1) continue;
                bl = true;
            }
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return true;
        }
    }

    public static boolean executeElevated(String string, String string2, String string3, Map map) {
        File file = InstallerUtil.getInstallerFile(ELEVATION_EXECUTABLE);
        if (!file.exists()) {
            return false;
        }
        try {
            File file2 = MacosUserInfo.createScriptFile(string, string2, map);
            Integer n = LaunchHelper.launchApplication(new LaunchDescriptor(file).workingDirectory(new File(string3)).arguments(new String[]{file2.getAbsolutePath()}).wait(true));
            if (n == null || n != 0) {
                Logger.getInstance().error(MacosUserInfo.class, "return value is " + n);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            Logger.getInstance().info(MacosUserInfo.class, iOException.toString());
            iOException.printStackTrace();
            return false;
        }
    }

    private static File createScriptFile(String string, String string2, Map map) throws IOException {
        File file = File.createTempFile("i4j", ".sh");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"));
        printWriter.println("#!/bin/sh");
        printWriter.println("echo running >> /test");
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter.println(entry.getKey() + "=\"" + entry.getValue() + "\"");
                printWriter.println("export " + entry.getKey());
            }
        }
        printWriter.print("\"" + string + "\"");
        if (string2 != null) {
            printWriter.print(" " + string2);
        }
        printWriter.println();
        printWriter.println("rm $0");
        printWriter.println("exit 0");
        printWriter.close();
        return file;
    }
}

