/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.versionspecific.ConsoleAccess;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class SimpleConsoleAccess
implements ConsoleAccess {
    private static final String EXE4J_PROP_CONSOLE_CODEPAGE = "exe4j.consoleCodepage";
    private static final String INSTALL4J_PROP_CONSOLE_ENCODING = "install4j.consoleEncoding";
    private BufferedReader stdin;
    private PrintWriter stdout;
    private Thread ioThread;

    public SimpleConsoleAccess() {
        String string = System.getProperty(INSTALL4J_PROP_CONSOLE_ENCODING);
        if (string == null) {
            string = System.getProperty(EXE4J_PROP_CONSOLE_CODEPAGE);
        }
        if (string == null) {
            this.stdout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
            this.stdin = new BufferedReader(new InputStreamReader(new FileInputStream(FileDescriptor.in)));
        } else {
            try {
                this.stdout = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), string));
                this.stdin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.stdout = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
                this.stdin = new BufferedReader(new InputStreamReader(new FileInputStream(FileDescriptor.in)));
            }
        }
    }

    public void print(String string) {
        this.stdout.print(string);
    }

    public void println(String string) {
        this.stdout.println(string);
    }

    public void println() {
        this.stdout.println();
    }

    public void flush() {
        this.stdout.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String string) throws UserCanceledException {
        this.ioThread = Thread.currentThread();
        try {
            InputReaderThread inputReaderThread = new InputReaderThread();
            inputReaderThread.start();
            try {
                inputReaderThread.join();
                String string2 = inputReaderThread.getResult();
                if (string2 == null) {
                    throw new UserCanceledException();
                }
                String string3 = string2;
                return string3;
            }
            catch (InterruptedException interruptedException) {
                throw new UserCanceledException();
            }
        }
        finally {
            SimpleConsoleAccess simpleConsoleAccess = this;
            synchronized (simpleConsoleAccess) {
                Thread.interrupted();
                this.ioThread = null;
            }
        }
    }

    public String readPassword(String string) throws UserCanceledException {
        return this.readLine(string);
    }

    public PrintWriter getWriter() {
        return this.stdout;
    }

    public void cancel() {
        if (this.ioThread != null) {
            this.ioThread.interrupt();
        }
    }

    private class InputReaderThread
    extends Thread {
        private String result;

        public InputReaderThread() {
            super("console input reader thread");
        }

        public String getResult() {
            return this.result;
        }

        public void run() {
            try {
                this.defaultRead();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.result = "";
            }
            catch (Exception exception) {
                this.result = null;
            }
        }

        private void defaultRead() throws IOException {
            int n;
            String string = SimpleConsoleAccess.this.stdin.readLine();
            for (n = 0; n < string.length() && Character.isISOControl(string.charAt(n)); ++n) {
            }
            if (n > 0) {
                string = string.substring(n);
            } else if (n == string.length()) {
                string = "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\u007f') {
                    if (stringBuffer.length() <= 0) continue;
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            this.result = stringBuffer.toString();
        }
    }
}

