/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.api.Util;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.beans.actions.misc.ExecutionType;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ProcessCommunication;
import com.install4j.runtime.installer.helper.launching.LaunchApplicationAction;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class LaunchHelper {
    public static final long LAUNCH_EXIT_DELTA_TIME = 10000L;
    private static long lastLaunchTime;
    private static char[] SPECIAL_BATCH_FILE_CHARACTERS;

    public static long getLastLaunchTime() {
        return lastLaunchTime;
    }

    private LaunchHelper() {
    }

    public static boolean launchFinishExecutable(File file, String[] stringArray, File file2) {
        Integer n = Util.isWindows() || Util.isMacOS() ? LaunchHelper.launchApplication(new LaunchDescriptor(file).workingDirectory(file2).arguments(stringArray).executionType(ExecutionType.ORIGINAL_USER)) : LaunchHelper.launchApplication(new LaunchDescriptor(new File("/bin/sh")).workingDirectory(file2).arguments(new String[]{"-c", "nohup \"" + (file.exists() ? file.getAbsolutePath() : file.getPath()) + "\" " + StringUtil.makeCommandLine(stringArray) + " > /dev/null 2>&1"}));
        if (n != null) {
            lastLaunchTime = System.currentTimeMillis();
        }
        return n != null;
    }

    public static Integer launchApplication(LaunchDescriptor launchDescriptor) {
        block24: {
            Object object;
            Object object2;
            try {
                object2 = ProcessCommunication.getInstance();
                if (launchDescriptor.getExecutionType() == ExecutionType.ORIGINAL_USER && ((ProcessCommunication)object2).isElevatedAndApplicable() || launchDescriptor.getExecutionType() == ExecutionType.ADMIN && ((ProcessCommunication)object2).isUnelevatedAndApplicable()) {
                    Logger.getInstance().info(LaunchHelper.class, "trigger process launch from helper process.");
                    object = (LaunchApplicationAction.LaunchResponse)((ProcessCommunication)object2).sendAction(new LaunchApplicationAction(launchDescriptor));
                    if (object != null) {
                        return ((LaunchApplicationAction.LaunchResponse)object).getExitCode();
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            object2 = launchDescriptor.getExecutable();
            object = LaunchHelper.getEnvironmentVariables(launchDescriptor.getSpecificEnvironmentVariables(), launchDescriptor.isIncludeParentEnvironmentVariables());
            try {
                if (object2 == null) {
                    Logger.getInstance().error(null, "executable is null");
                    break block24;
                }
                Process process = null;
                OutputStream outputStream = LaunchHelper.createOutputStream(launchDescriptor.getStdoutFile());
                OutputStream outputStream2 = LaunchHelper.createOutputStream(launchDescriptor.getStderrFile());
                InputStream inputStream = LaunchHelper.createInputStream(launchDescriptor.getStdinFile());
                if (InstallerUtil.isMacOS()) {
                    process = LaunchHelper.launchOnMacOS(launchDescriptor);
                } else if (!((File)object2).exists() || ((File)object2).isFile()) {
                    if (launchDescriptor.isFailOnRedirectionError() && (outputStream == null && launchDescriptor.getStdoutFile() != null || outputStream2 == null && launchDescriptor.getStderrFile() != null || inputStream == null && launchDescriptor.getStdinFile() != null)) {
                        LaunchHelper.closeStreams(inputStream, outputStream, outputStream2);
                        return null;
                    }
                    launchDescriptor.useNohup(launchDescriptor.isUseNohup() && outputStream == null && outputStream2 == null && inputStream == null);
                    String string = ((File)object2).exists() ? ((File)object2).getAbsolutePath() : ((File)object2).getPath();
                    process = Util.isWindows() && (string.toLowerCase().endsWith(".bat") || string.toLowerCase().endsWith(".cmd") || Util.isAtLeastWindowsVista() || launchDescriptor.isShowWindowsConsole()) ? LaunchHelper.launchOnWindows(launchDescriptor, string, (String[])object) : LaunchHelper.launchOtherwise(launchDescriptor, string, (String[])object);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                } else {
                    Logger.getInstance().error(null, "executable is not a file: " + object2);
                }
                if (process == null) {
                    Logger.getInstance().error(LaunchHelper.class, "process could not be created");
                    LaunchHelper.closeStreams(inputStream, outputStream, outputStream2);
                    return null;
                }
                new ConsumerThread(process.getInputStream(), outputStream).start();
                new ConsumerThread(process.getErrorStream(), outputStream2).start();
                if (inputStream != null) {
                    new WriterThread(process.getOutputStream(), inputStream).start();
                }
                if (launchDescriptor.isReceiveProcess()) {
                    launchDescriptor.setProcess(process);
                }
                if (!launchDescriptor.isWait()) {
                    return new Integer(1);
                }
                try {
                    int n = process.waitFor();
                    if (n != 0) {
                        Logger.getInstance().error(LaunchHelper.class, "return value is " + n);
                    }
                    return new Integer(n);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getInstance().info(LaunchHelper.class, interruptedException.toString());
                    interruptedException.printStackTrace();
                    return null;
                }
            }
            catch (IOException iOException) {
                try {
                    Logger.getInstance().error(null, iOException.getMessage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iOException.printStackTrace();
            }
        }
        return null;
    }

    private static Process launchOnMacOS(LaunchDescriptor launchDescriptor) throws IOException {
        String[] stringArray;
        File file = launchDescriptor.getExecutable();
        if ((file = LaunchHelper.checkDmg(file)) == null) {
            return null;
        }
        if (file.isDirectory()) {
            if (launchDescriptor.getArguments() != null) {
                stringArray = new String[launchDescriptor.getArguments().length + 2];
                stringArray[0] = file.getAbsolutePath();
                stringArray[1] = "--args";
                System.arraycopy(launchDescriptor.getArguments(), 0, stringArray, 2, launchDescriptor.getArguments().length);
                launchDescriptor.arguments(stringArray);
            } else {
                launchDescriptor.arguments(new String[]{file.getAbsolutePath()});
            }
            file = new File("/usr/bin/open");
        }
        stringArray = LaunchHelper.createMacStartScript(launchDescriptor, file);
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = InstallerUtil.getInstallerFile("install4j");
        if (file2.exists() && launchDescriptor.getRunAsUser() != null && UnixUserInfo.ROOT_USER && !launchDescriptor.getRunAsUser().equals("root")) {
            arrayList.add(file2.getAbsolutePath());
            arrayList.add("__i4j_setuid");
        }
        arrayList.add("/bin/sh");
        arrayList.add(stringArray.getAbsolutePath());
        Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), null, launchDescriptor.getWorkingDirectory());
        if (process == null) {
            Logger.getInstance().error(null, "process is null");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return process;
    }

    private static File createMacStartScript(LaunchDescriptor launchDescriptor, File file) throws IOException {
        Object object;
        String[] stringArray = launchDescriptor.getArguments();
        File file2 = File.createTempFile("i4j", ".sh", new File("/tmp"));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file2)), "UTF-8"));
        printWriter.println("#!/bin/sh");
        if (launchDescriptor.getWorkingDirectory() != null) {
            printWriter.println("old_pwd=`pwd`");
            printWriter.println("cd \"" + launchDescriptor.getWorkingDirectory() + "\"");
        }
        if (launchDescriptor.getSpecificEnvironmentVariables() != null) {
            Iterator iterator = launchDescriptor.getSpecificEnvironmentVariables().entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                printWriter.println(object.getKey() + "=\"" + object.getValue() + "\"");
                printWriter.println("export " + object.getKey());
            }
        }
        boolean bl = false;
        if (launchDescriptor.getRunAsUser() != null && UnixUserInfo.ROOT_USER) {
            if (launchDescriptor.getRunAsUser().equals("root") && Util.isMacOS()) {
                object = InstallerUtil.getInstallerFile("install4j");
                if (((File)object).exists()) {
                    printWriter.print("\"" + ((File)object).getAbsolutePath() + "\" __i4j_setuid ");
                }
            } else {
                printWriter.print("su \"" + launchDescriptor.getRunAsUser() + "\" -c '");
                bl = true;
            }
        }
        printWriter.print("\"" + file.getAbsolutePath() + "\"");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.print(" \"" + stringArray[i] + "\"");
            }
        }
        if (bl) {
            printWriter.print("'");
        }
        printWriter.println();
        printWriter.println("exitCode=$?");
        if (launchDescriptor.getWorkingDirectory() != null) {
            printWriter.println("  cd \"$old_pwd\"");
        }
        printWriter.println("rm $0");
        printWriter.println("exit $exitCode");
        printWriter.close();
        return file2;
    }

    private static Process launchOnWindows(LaunchDescriptor launchDescriptor, String string, String[] stringArray) throws IOException {
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Util.isWindows9X()) {
            arrayList.add(new File(WinFileSystem.getWindowsDirectory(), "command.com").getAbsolutePath());
        } else {
            try {
                arrayList.add(new File(WinFileSystem.getSystemDirectory(), "cmd.exe").getAbsolutePath());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                arrayList.add("cmd.exe");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                arrayList.add("cmd.exe");
            }
        }
        boolean bl2 = bl = launchDescriptor.isShowWindowsConsole() && !Util.isWindows9X();
        if (bl && launchDescriptor.isKeepConsoleWindow()) {
            arrayList.add("/K");
        } else {
            arrayList.add("/C");
        }
        String string2 = string;
        try {
            string2 = FolderInfo.getShortPathName(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File file = LaunchHelper.createWindowsStartScript(launchDescriptor, string2);
        arrayList.add("\"" + file.getAbsolutePath() + "\"");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(" ");
        }
        String string3 = stringBuffer.toString();
        if (bl) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("start \"");
            stringBuffer2.append(string);
            stringBuffer2.append("\" /WAIT ");
            stringBuffer2.append(string3);
            return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", stringBuffer2.toString()}, stringArray, launchDescriptor.getWorkingDirectory());
        }
        return Runtime.getRuntime().exec(string3, stringArray, launchDescriptor.getWorkingDirectory());
    }

    private static File createWindowsStartScript(LaunchDescriptor launchDescriptor, String string) throws IOException {
        File file = File.createTempFile("i4j", ".bat");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.println("@ECHO OFF");
        printWriter.print("\"" + string + "\"");
        String[] stringArray = launchDescriptor.getArguments();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = StringUtil.replace(stringArray[i], "%", "%%");
                if (LaunchHelper.needsQuotes(string2)) {
                    printWriter.print(" \"" + string2 + "\"");
                    continue;
                }
                printWriter.print(" " + string2);
            }
        }
        printWriter.println();
        printWriter.close();
        file.deleteOnExit();
        return file;
    }

    private static boolean needsQuotes(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= 'z' && Arrays.binarySearch(SPECIAL_BATCH_FILE_CHARACTERS, c) < 0) continue;
            return true;
        }
        return false;
    }

    private static Process launchOtherwise(LaunchDescriptor launchDescriptor, String string, String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (launchDescriptor.isUseNohup()) {
            arrayList.add("/bin/sh");
            arrayList.add("-c");
            arrayList.add("nohup \"" + string + "\" " + StringUtil.makeCommandLine(launchDescriptor.getArguments()) + " > /dev/null 2>&1");
        } else {
            arrayList.add(string);
            String[] stringArray2 = launchDescriptor.getArguments();
            if (stringArray2 != null) {
                arrayList.addAll(Arrays.asList(stringArray2));
            }
        }
        return Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), stringArray, launchDescriptor.getWorkingDirectory());
    }

    private static String[] getEnvironmentVariables(Map map, boolean bl) {
        String string;
        String string2;
        Map.Entry entry;
        if (map == null || map.isEmpty()) {
            if (bl) {
                return null;
            }
            return new String[0];
        }
        Map map2 = VersionSpecificHelper.getenv();
        Map map3 = LaunchHelper.getUpperCaseVariables(map2);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = InstallerUtil.isWindows();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string2 = InstallerVariables.replaceVariables((String)entry.getKey());
            string = InstallerVariables.replaceVariables((String)entry.getValue());
            hashSet.add(bl2 ? string2.toUpperCase() : string2);
            arrayList.add(string2 + "=" + LaunchHelper.replaceEnvironmentVariables(string, bl2 ? map3 : map2));
        }
        if (bl) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = (String)entry.getKey();
                string = (String)entry.getValue();
                if (hashSet.contains(bl2 ? string2.toUpperCase() : string2)) continue;
                arrayList.add(string2 + "=" + string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static Map getUpperCaseVariables(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        return hashMap;
    }

    private static String replaceEnvironmentVariables(String string, final Map map) {
        return StringUtil.replaceVariable(string, "${", "}", new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                return (String)map.get(InstallerUtil.isWindows() ? string.toUpperCase() : string);
            }
        });
    }

    private static File checkDmg(File file) throws IOException {
        if ((file = file.getCanonicalFile()).getName().endsWith(".dmg")) {
            Integer n = LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/hdiutil")).arguments(new String[]{"attach", file.getAbsolutePath()}).wait(true));
            if (n == null) {
                Logger.getInstance().error(null, "could not execute hdiutil");
                return null;
            }
            if (n == 0) {
                Map map = VolumeInfo.getMountPointToDiskFile();
                if (map != null) {
                    for (int i = 0; i < 5; ++i) {
                        Iterator iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            File file2;
                            File[] fileArray;
                            Map.Entry entry = iterator.next();
                            if (!new File((String)entry.getValue()).getCanonicalFile().equals(file) || (fileArray = (file2 = new File((String)entry.getKey())).listFiles()) == null) continue;
                            for (int j = 0; j < fileArray.length; ++j) {
                                File file3 = fileArray[j];
                                if (!file3.isDirectory() || !file3.getName().endsWith(".app")) continue;
                                return file3;
                            }
                            Logger.getInstance().error(null, "could not find app bundle");
                            return null;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        map = VolumeInfo.getNewMountPointToDiskFile();
                    }
                    Logger.getInstance().error(null, "could not find mount point");
                } else {
                    Logger.getInstance().error(null, "could not retrieve mount points");
                }
            } else {
                Logger.getInstance().error(null, "could not mount dmg file");
            }
            return null;
        }
        return file;
    }

    private static void closeStreams(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static OutputStream createOutputStream(File file) {
        if (file != null) {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                Logger.getInstance().error(LaunchHelper.class, "output file " + file.getPath() + " could not be created");
            }
        }
        return null;
    }

    private static InputStream createInputStream(File file) {
        if (file != null) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                Logger.getInstance().error(LaunchHelper.class, "input file " + file.getPath() + " could not be opened");
            }
        }
        return null;
    }

    static {
        SPECIAL_BATCH_FILE_CHARACTERS = new char[]{' ', '&', '(', ')', '[', ']', '{', '}', '^', '=', ';', '!', '+', '`', '~', '<', '>', '@', '|'};
        Arrays.sort(SPECIAL_BATCH_FILE_CHARACTERS);
    }

    public static class ConsumerThread
    extends Thread {
        private boolean canceled;
        private InputStream stream;
        private OutputStream outputStream;

        public ConsumerThread(InputStream inputStream, OutputStream outputStream) {
            this.stream = inputStream;
            this.outputStream = outputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            while (!this.canceled) {
                try {
                    int n = this.stream.read(byArray);
                    if (n == -1) {
                        this.cancel();
                        continue;
                    }
                    if (this.outputStream == null) continue;
                    this.outputStream.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class WriterThread
    extends Thread {
        private boolean canceled;
        private OutputStream processOutput;
        private InputStream inputStream;

        public WriterThread(OutputStream outputStream, InputStream inputStream) {
            this.processOutput = outputStream;
            this.inputStream = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            while (!this.canceled) {
                try {
                    int n = this.inputStream.read(byArray);
                    if (n == -1) {
                        this.cancel();
                        continue;
                    }
                    this.processOutput.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    this.cancel();
                }
            }
        }

        public synchronized void cancel() {
            this.canceled = true;
            try {
                this.inputStream.close();
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

