/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.runtime.beans.actions.misc.ExecutionType;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class LaunchDescriptor
implements Serializable {
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean includeParentEnvironmentVariables = true;
    private Map specificEnvironmentVariables;
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;
    private boolean useNohup = false;
    private File stdoutFile;
    private File stderrFile;
    private File stdinFile;
    private boolean failOnRedirectionError = false;
    private boolean wait = false;
    private Process process;
    private boolean receiveProcess = false;
    private String runAsUser;
    private ExecutionType executionType = ExecutionType.AS_IS;

    public LaunchDescriptor(File file) {
        this.executable = file;
    }

    public File getExecutable() {
        return this.executable;
    }

    public LaunchDescriptor executable(File file) {
        this.executable = file;
        return this;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public LaunchDescriptor workingDirectory(File file) {
        this.workingDirectory = file;
        return this;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public LaunchDescriptor arguments(String[] stringArray) {
        if (stringArray != null && (stringArray.length == 0 || stringArray.length == 1 && (stringArray[0] == null || stringArray[0].length() == 0))) {
            stringArray = null;
        }
        this.arguments = stringArray;
        return this;
    }

    public LaunchDescriptor runAsUser(String string) {
        this.runAsUser = string;
        return this;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public boolean isUseNohup() {
        return this.useNohup;
    }

    public LaunchDescriptor useNohup(boolean bl) {
        this.useNohup = bl;
        return this;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.includeParentEnvironmentVariables;
    }

    public LaunchDescriptor includeParentEnvironmentVariables(boolean bl) {
        this.includeParentEnvironmentVariables = bl;
        return this;
    }

    public Map getSpecificEnvironmentVariables() {
        return this.specificEnvironmentVariables;
    }

    public LaunchDescriptor specificEnvironmentVariables(Map map) {
        this.specificEnvironmentVariables = map;
        return this;
    }

    public boolean isShowWindowsConsole() {
        return this.showWindowsConsole;
    }

    public LaunchDescriptor showWindowsConsole(boolean bl) {
        this.showWindowsConsole = bl;
        return this;
    }

    public boolean isKeepConsoleWindow() {
        return this.keepConsoleWindow;
    }

    public LaunchDescriptor keepConsoleWindow(boolean bl) {
        this.keepConsoleWindow = bl;
        return this;
    }

    public LaunchDescriptor stdoutFile(File file) {
        this.stdoutFile = file;
        return this;
    }

    public LaunchDescriptor stderrFile(File file) {
        this.stderrFile = file;
        return this;
    }

    public LaunchDescriptor stdinFile(File file) {
        this.stdinFile = file;
        return this;
    }

    public LaunchDescriptor failOnRedirectionError(boolean bl) {
        this.failOnRedirectionError = bl;
        return this;
    }

    public LaunchDescriptor wait(boolean bl) {
        this.wait = bl;
        return this;
    }

    public File getStdoutFile() {
        return this.stdoutFile;
    }

    public File getStderrFile() {
        return this.stderrFile;
    }

    public File getStdinFile() {
        return this.stdinFile;
    }

    public boolean isFailOnRedirectionError() {
        return this.failOnRedirectionError;
    }

    public boolean isWait() {
        return this.wait;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public boolean isReceiveProcess() {
        return this.receiveProcess;
    }

    public LaunchDescriptor receiveProcess(boolean bl) {
        this.receiveProcess = bl;
        return this;
    }

    public String toString() {
        return "LaunchDescriptor{executable=" + this.executable + ", workingDirectory=" + this.workingDirectory + ", arguments=" + (this.arguments == null ? null : Arrays.asList(this.arguments)) + ", runAsUser=" + this.runAsUser + ", includeParentEnvironmentVariables=" + this.includeParentEnvironmentVariables + ", specificEnvironmentVariables=" + this.specificEnvironmentVariables + ", showWindowsConsole=" + this.showWindowsConsole + ", keepConsoleWindow=" + this.keepConsoleWindow + ", useNohup=" + this.useNohup + ", stdoutFile=" + this.stdoutFile + ", stderrFile=" + this.stderrFile + ", stdinFile=" + this.stdinFile + ", failOnRedirectionError=" + this.failOnRedirectionError + ", wait=" + this.wait + ", process=" + this.process + ", receiveProcess=" + this.receiveProcess + ", executionType=" + this.executionType + '}';
    }

    public LaunchDescriptor executionType(ExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }
}

