/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.UninstallMode;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Element;

public class FileLogger {
    private SortedSet createdDirs = new TreeSet(new ReverseComparator());
    private Set createdFiles = new HashSet();
    private List replacedFiles = new ArrayList();
    private static final String ELEMENT_FILELOG = "fileLog";
    private static final String ELEMENT_CREATED_FILES = "createdFiles";
    private static final String ELEMENT_CREATED_DIRS = "createdDirs";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SHARED = "shared";
    private static final String ATTRIBUTE_DONT_UNINSTALL = "dontUninstall";
    private static final String ATTRIBUTE_UNINSTALL_MODE = "uninstallMode";

    public void write(File file, FileLogger fileLogger) throws IOException {
        Object object;
        Object object2;
        if (fileLogger != null) {
            object2 = fileLogger.getCreatedFilesIterator();
            while (object2.hasNext()) {
                object = (InstallFile)object2.next();
                this.addCreatedFile((InstallFile)object);
            }
            object2 = fileLogger.getCreatedDirsIterator();
            while (object2.hasNext()) {
                object = (InstallFile)object2.next();
                this.addCreatedDir((InstallFile)object);
            }
        }
        object2 = this.replacedFiles.iterator();
        while (object2.hasNext()) {
            object = (BackupPair)object2.next();
            UninstallMode uninstallMode = ((BackupPair)object).getOriginalFile().getUninstallMode();
            if (uninstallMode == UninstallMode.ALWAYS || uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                this.addCreatedFile(((BackupPair)object).getOriginalFile());
                continue;
            }
            if (((BackupPair)object).isPreviouslyCreated()) continue;
            this.addOverwrittenFile(((BackupPair)object).getOriginalFile());
        }
        object2 = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"));
        ((PrintWriter)object2).println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        ((PrintWriter)object2).println("<fileLog>");
        ((PrintWriter)object2).println("<createdFiles>");
        this.addEntries((PrintWriter)object2, this.createdFiles);
        ((PrintWriter)object2).println("</createdFiles>");
        ((PrintWriter)object2).println("<createdDirs>");
        this.addEntries((PrintWriter)object2, this.createdDirs);
        ((PrintWriter)object2).println("</createdDirs>");
        ((PrintWriter)object2).println("</fileLog>");
        ((PrintWriter)object2).close();
    }

    private void addEntries(PrintWriter printWriter, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.addEntry(printWriter, file);
        }
    }

    private void addEntry(PrintWriter printWriter, File file) {
        int n;
        printWriter.print("<entry name=\"");
        String string = file.getAbsolutePath();
        String string2 = ContextImpl.getSingleContextImpl().getInstallationDirectory().getPath();
        if (string.startsWith(string2 + File.separator)) {
            for (n = string2.length(); n < string.length() && string.charAt(n) == File.separatorChar; n += 1) {
            }
            string = string.substring(n);
        } else if (string.equals(string2)) {
            string = ".";
        }
        printWriter.print(string.replaceAll("&", "&amp;"));
        printWriter.print("\" shared=\"");
        n = 0;
        UninstallMode uninstallMode = UninstallMode.IF_CREATED;
        if (file instanceof InstallFile) {
            InstallFile installFile = (InstallFile)file;
            uninstallMode = installFile.getUninstallMode();
            n = installFile.isShared();
        }
        printWriter.print(n != 0);
        printWriter.print("\" uninstallMode=\"");
        printWriter.print(uninstallMode.getIntValue());
        printWriter.println("\"/>");
    }

    public void read(File file) throws IOException {
        Element element = XmlHelper.parseFile(file).getDocumentElement();
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.getTagName().equals(ELEMENT_CREATED_FILES)) {
                this.readEntries(element2, this.createdFiles);
                continue;
            }
            if (!element2.getTagName().equals(ELEMENT_CREATED_DIRS)) continue;
            this.readEntries(element2, this.createdDirs);
        }
    }

    private void readEntries(Element element, Collection collection) {
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            int n = XmlHelper.readAttribute(element2, ATTRIBUTE_UNINSTALL_MODE, -1);
            if (n == -1) {
                boolean bl = XmlHelper.readAttribute(element2, ATTRIBUTE_DONT_UNINSTALL, false);
                n = bl ? 1 : 0;
            }
            String string = XmlHelper.readAttribute(element2, ATTRIBUTE_NAME, "");
            File file = ContextImpl.getSingleContextImpl().getInstallationDirectory().getAbsoluteFile();
            if (string.equals(".")) {
                string = file.getPath();
            } else if (!new File(string).isAbsolute()) {
                File file2 = new File(file, string);
                string = file2.getPath();
            }
            collection.add(new InstallFile(string, XmlHelper.readAttribute(element2, ATTRIBUTE_SHARED, false), UninstallMode.getFromIntValue(n)));
        }
    }

    public Iterator getCreatedDirsIterator() {
        return this.createdDirs.iterator();
    }

    public Iterator getCreatedFilesIterator() {
        return this.createdFiles.iterator();
    }

    public List getReplacedFiles() {
        return this.replacedFiles;
    }

    public int getCreatedDirsSize() {
        return this.createdDirs.size();
    }

    public int getCreatedFilesSize() {
        return this.createdFiles.size();
    }

    public void addCreatedDir(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), installFile.getUninstallMode());
        this.createdDirs.add(installFile);
    }

    public void addCreatedFile(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), installFile.getUninstallMode());
        this.createdFiles.add(installFile);
    }

    private void addOverwrittenFile(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), UninstallMode.NEVER);
        this.createdFiles.add(installFile);
    }

    public void addReplacedFile(BackupPair backupPair) {
        this.replacedFiles.add(backupPair);
    }

    public boolean containsCreatedFile(File file) {
        return this.createdFiles.contains(file.getAbsoluteFile());
    }

    public boolean hasFiles() {
        return this.createdDirs.size() > 0 || this.createdFiles.size() > 0 || this.replacedFiles.size() > 0;
    }

    private static class ReverseComparator
    implements Comparator {
        private ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }
    }
}

