/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ReadIOException;
import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerFileEvent;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ProcessCommunication;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.win32.FileVersion;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class FileInstaller {
    public static final int SUCCESS = 0;
    public static final int ERROR = 1;
    public static final int CANCELED = 2;
    public static final String DS_STORE_NAME = ".DS_Store";
    private static final String LOG_FILENAME = "files.log";
    private static final String KEY_SHARED_DLLS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDLLs";
    private static FileInstaller fileInstaller = new FileInstaller();
    private Set parentFoldersOfDeletedFiles = new HashSet();
    private boolean respondedOverwriteNever = false;
    private boolean respondedOverwriteAlways = false;
    private ProgressInterface defaultProgressInterface = new ProgressAdapter(null, false);
    private File logDir;
    private FileLogger newFileLogger = new FileLogger();
    private FileLogger oldFileLogger = new FileLogger();
    private FileLogger rollbackFileLogger = new FileLogger();
    private List cleanupFiles = new ArrayList();
    private List undeletedFiles = new ArrayList();
    private List undeletedDirs = new ArrayList();
    private boolean isUninstalling = false;
    private boolean uninstallForUpgrade = false;
    private boolean hasUnrollbackedFiles = false;
    private String lastOptionsVerbose;
    private Map ownerInfoCache = new HashMap();
    private Set classPathFiles;

    public static FileInstaller getInstance() {
        FileInstaller.fileInstaller.lastOptionsVerbose = null;
        return fileInstaller;
    }

    public static void clearFileInstaller() {
        fileInstaller = new FileInstaller();
    }

    private BackupPair backupFile(InstallFile installFile) throws IOException {
        Object object;
        long l = installFile.lastModified();
        Object object2 = File.createTempFile("i4b", null);
        ((File)object2).delete();
        if (!installFile.renameTo((File)object2)) {
            try {
                object = File.createTempFile("i4b", null, installFile.getParentFile());
                ((File)object).delete();
            }
            catch (IOException iOException) {
                object = object2;
            }
            if (installFile.renameTo((File)object)) {
                object2 = object;
            } else {
                FileUtil.copyFile(installFile, (File)object2);
            }
        }
        object = new BackupPair(installFile, (File)object2, l);
        this.newFileLogger.addReplacedFile((BackupPair)object);
        this.rollbackFileLogger.addReplacedFile((BackupPair)object);
        return object;
    }

    private static boolean isFirstFileNewer(File file, File file2) {
        if (InstallerUtil.isWindows()) {
            int n = FileVersion.compare(file, file2);
            if (n == 1) {
                Logger.getInstance().info(null, "Windows version info marks file as newer.");
                return true;
            }
            if (n == 3) {
                Logger.getInstance().info(null, "File times: " + file.lastModified() + ", " + file2.lastModified());
                return file.lastModified() > file2.lastModified();
            }
            Logger.getInstance().info(null, "Windows version info marks file as older.");
            return false;
        }
        Logger.getInstance().info(null, "File times: " + file.lastModified() + ", " + file2.lastModified());
        return file.lastModified() > file2.lastModified();
    }

    private boolean checkFile(File file, InstallFile installFile, int n, UninstallMode uninstallMode, boolean bl, ProgressInterface progressInterface) throws IOException, UserCanceledException {
        this.createDirectory(installFile.getParentFile(), FileInstaller.getParentUninstallMode(uninstallMode));
        if (installFile.exists()) {
            boolean bl2;
            if (n == 0 || (n == 4 || n == 5) && this.respondedOverwriteNever) {
                Logger.getInstance().info(null, "Don't overwrite because file exists (ron: " + this.respondedOverwriteNever + ")");
                return false;
            }
            boolean bl3 = bl2 = n != 4 && n != 5;
            if (n == 2 || n == 3) {
                boolean bl4 = FileInstaller.isFirstFileNewer(file, installFile);
                if (!bl4 && (n == 2 || this.respondedOverwriteNever)) {
                    Logger.getInstance().info(null, "Don't overwrite because existing file is newer (ron: " + this.respondedOverwriteNever + ")");
                    return false;
                }
                bl2 = bl4;
            }
            if (n == 1 || this.respondedOverwriteAlways || bl && n != 5) {
                bl2 = true;
            }
            if (!bl2) {
                switch (progressInterface.askOverwrite(installFile)) {
                    case 4: {
                        this.respondedOverwriteNever = true;
                        Logger.getInstance().info(null, "Don't overwrite because of user action (never)");
                        return false;
                    }
                    case 1: {
                        Logger.getInstance().info(null, "Don't overwrite because of user action (no)");
                        return false;
                    }
                    case 3: {
                        this.respondedOverwriteAlways = true;
                    }
                }
            }
            BackupPair backupPair = this.backupFile(installFile);
            backupPair.setPreviouslyCreated(bl);
        } else {
            this.newFileLogger.addCreatedFile(installFile);
            this.rollbackFileLogger.addCreatedFile(installFile);
        }
        return true;
    }

    public void registerUninstallFile(File file) {
        InstallFile installFile = new InstallFile(file, false);
        if (file.isDirectory()) {
            this.newFileLogger.addCreatedDir(installFile);
            this.rollbackFileLogger.addCreatedDir(installFile);
        } else {
            this.newFileLogger.addCreatedFile(installFile);
            this.rollbackFileLogger.addCreatedFile(installFile);
        }
    }

    public void createDirectory(File file, UninstallMode uninstallMode) throws IOException {
        File file2;
        int n;
        Serializable serializable;
        File file3 = file.getCanonicalFile();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file3.getParentFile(); serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = FileInstaller.getParentUninstallMode(uninstallMode);
        for (n = arrayList.size() - 1; n >= 0; --n) {
            file2 = (File)arrayList.get(n);
            boolean bl = file2.mkdir();
            if (bl || serializable == UninstallMode.ALWAYS || serializable == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                InstallFile installFile = new InstallFile(file2, false, (UninstallMode)serializable);
                this.newFileLogger.addCreatedDir(installFile);
                this.rollbackFileLogger.addCreatedDir(installFile);
            }
            if (!bl) continue;
            this.setOwner(file2);
        }
        n = file3.mkdir() ? 1 : 0;
        if (n != 0 || uninstallMode == UninstallMode.ALWAYS || uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            file2 = new InstallFile(file3, false, uninstallMode);
            this.newFileLogger.addCreatedDir((InstallFile)file2);
            this.rollbackFileLogger.addCreatedDir((InstallFile)file2);
        }
        if (n != 0) {
            this.setOwner(file3);
        }
    }

    public void createDirectory(File file) throws IOException {
        this.createDirectory(file, UninstallMode.IF_CREATED);
    }

    public boolean install(File file, File file2) throws UserCanceledException {
        return this.install(file, file2, new FileOptions(file.lastModified()));
    }

    public boolean install(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return this.install(file, file2, fileOptions, null);
    }

    public boolean install(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface) throws UserCanceledException {
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        boolean bl = false;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bl = this.install(bufferedInputStream, file2, fileOptions, progressInterface, file.length(), false);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not read " + file);
            progressInterface.showFailure(string);
        }
        return bl;
    }

    public boolean install(InputStream inputStream, File file, FileOptions fileOptions) throws UserCanceledException, ReadIOException {
        return this.install(inputStream, file, fileOptions, null, 0L, false);
    }

    private void copyTemp(File file, File file2, FileOptions fileOptions) throws IOException {
        if (file2.exists() && !file2.delete()) {
            throw new IOException("could not delete " + file2);
        }
        FileUtil.rename(file, file2);
        file2.setLastModified(fileOptions.getFileTime());
        if (!InstallerUtil.isWindows()) {
            UnixFileSystem.setMode(fileOptions.getMode(), file2);
        }
        this.setOwner(file2);
    }

    private void setOwner(File file) {
        String string;
        String string2;
        if (InstallerUtil.isMacOS() && ProcessCommunication.getInstance().isElevatedAndApplicable() && (string2 = (String)InstallerVariables.getVariable("sys.userName")) != null && (string = this.getOwnerInfo(file.getParentFile())) != null && (string.equals(string2) || string.startsWith(string2 + ":"))) {
            UnixFileSystem.setOwner(string, file);
            if (file.isDirectory()) {
                try {
                    this.ownerInfoCache.put(file.getCanonicalFile(), string);
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                }
            }
        }
    }

    private String getOwnerInfo(File file) {
        try {
            UnixFileSystem.FileInformationImpl fileInformationImpl;
            file = file.getCanonicalFile();
            String string = (String)this.ownerInfoCache.get(file);
            if (string == null && (fileInformationImpl = UnixFileSystem.getFileInformation(file)) != null && fileInformationImpl.getOwnerInfo() != null) {
                string = fileInformationImpl.getOwnerInfo();
                this.ownerInfoCache.put(file, string);
            }
            return string;
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return null;
        }
    }

    private static Object addSharedCount(Object object, int n) {
        int n2 = 1;
        try {
            if (object instanceof Integer) {
                n2 = (Integer)object + n;
                object = new Integer(n2);
            } else if (object instanceof String) {
                n2 = Integer.parseInt((String)object) + n;
                object = String.valueOf(n2);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (byArray.length < 1 || byArray.length > 4) {
                    throw new NumberFormatException();
                }
                int[] nArray = new int[4];
                for (int i = 0; i < byArray.length; ++i) {
                    nArray[i] = byArray[i];
                }
                n2 = (nArray[3] << 24) + (nArray[2] << 16) + (nArray[1] << 8) + (nArray[0] << 0);
                byArray[0] = (byte)((n2 += n) >>> 0 & 0xFF);
                byArray[1] = (byte)(n2 >>> 8 & 0xFF);
                byArray[2] = (byte)(n2 >>> 16 & 0xFF);
                byArray[3] = (byte)(n2 >>> 24 & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = new Integer(n2);
        }
        if (n2 <= 0) {
            return null;
        }
        return object;
    }

    private void registerShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return;
        }
        Object object = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            object = new Integer(0);
        }
        object = FileInstaller.addSharedCount(object, 1);
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
    }

    private static boolean unregisterShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        Object object = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            return true;
        }
        if ((object = FileInstaller.addSharedCount(object, -1)) == null) {
            WinRegistry.deleteValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
            return true;
        }
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean install(InputStream inputStream, File file, FileOptions fileOptions, ProgressInterface progressInterface, long l, boolean bl) throws UserCanceledException, ReadIOException {
        ContextImpl contextImpl;
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        if ((contextImpl = ContextImpl.getSingleContextImpl()) != null) {
            contextImpl.fireInstallerEvent(new InstallerFileEvent(contextImpl.getEventSource(), contextImpl, EventType.BEFORE_INSTALL_FILE, file, l));
        }
        String string = fileOptions.toString();
        if (this.lastOptionsVerbose == null || !this.lastOptionsVerbose.equals(string)) {
            Logger.getInstance().info(null, "File options set to: [" + string + "]");
            this.lastOptionsVerbose = string;
        }
        boolean bl2 = false;
        try {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            while (bl5 && !bl4) {
                boolean bl6;
                ProgressAdapter progressAdapter;
                File file2;
                block38: {
                    boolean bl7;
                    block39: {
                        this.createDirectory(file.getParentFile(), FileInstaller.getParentUninstallMode(fileOptions.getUninstallMode()));
                        file2 = File.createTempFile("i4j", null, file.getParentFile());
                        progressAdapter = new ProgressAdapter(progressInterface, false);
                        bl6 = file.getName().endsWith(".jar");
                        if (bl && bl6) {
                            progressAdapter.setMaxCopyProgress(l * 3L);
                        } else {
                            progressAdapter.setMaxCopyProgress(l);
                        }
                        if (FileUtil.extractFile(inputStream, file2, progressAdapter, true)) break block38;
                        file2.delete();
                        bl7 = false;
                        if (bl3) break block39;
                        file2.delete();
                    }
                    return bl7;
                }
                try {
                    file2.setLastModified(fileOptions.getFileTime());
                    bl4 = true;
                    InstallFile installFile = new InstallFile(file, fileOptions.isShared(), fileOptions.getUninstallMode());
                    boolean bl8 = this.oldFileLogger.containsCreatedFile(file);
                    if (this.checkFile(file2, installFile, fileOptions.getOverwriteMode().getIntValue(), fileOptions.getUninstallMode(), bl8, progressInterface)) {
                        if (bl && bl6) {
                            File file3 = File.createTempFile("i4j", null, file.getParentFile());
                            try {
                                if (!VersionSpecificHelper.unpack(file2, file3, progressAdapter)) {
                                    FileUtil.rename(file2, file3);
                                }
                            }
                            catch (IOException iOException) {
                                Logger.getInstance().log(iOException);
                                progressInterface.showFailure("Corrupted .pack file for " + file.getPath() + ".\nPossibly the minimum Java version requirement for this installer has not been configured correctly.");
                                throw iOException;
                            }
                            file2.delete();
                            file2 = file3;
                        }
                        boolean bl9 = true;
                        while (bl9 && !bl2) {
                            try {
                                this.copyTemp(file2, installFile, fileOptions);
                                bl2 = true;
                            }
                            catch (IOException iOException) {
                                if (InstallerUtil.isWindows() && Util.hasFullAdminRights() && fileOptions.isDelayIfNecessary()) {
                                    bl3 = true;
                                    bl2 = true;
                                    this.newFileLogger.addCreatedFile(new InstallFile(file2, false, UninstallMode.ALWAYS));
                                    WinFileSystem.moveWithDelayUntilReboot(installFile, null);
                                    WinFileSystem.moveWithDelayUntilReboot(file2, installFile);
                                    contextImpl.setVariable("sys.rebootRequired", Boolean.TRUE);
                                    Logger.getInstance().info(null, "Delayed installation of " + file.getPath() + " from " + file2.getPath() + " until reboot.");
                                    continue;
                                }
                                System.err.println(iOException.getMessage());
                                switch (progressInterface.askRetry(installFile)) {
                                    case 1: {
                                        bl9 = false;
                                        break;
                                    }
                                    case 3: {
                                        throw new UserCanceledException();
                                    }
                                }
                            }
                        }
                    } else {
                        Logger.getInstance().info(null, "Did not replace " + file.getPath());
                        bl2 = true;
                    }
                    if (!fileOptions.isShared() || bl8) continue;
                    this.registerShared(file);
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        if (bl3) continue;
                        file2.delete();
                    }
                }
                catch (IOException iOException) {
                    if (iOException instanceof ReadIOException) {
                        throw (ReadIOException)iOException;
                    }
                    System.err.println(iOException.getMessage());
                    switch (progressInterface.askRetry(file)) {
                        case 1: {
                            bl5 = false;
                            break;
                        }
                        case 3: {
                            throw new UserCanceledException();
                        }
                    }
                }
            }
            if (!bl2) {
                Logger.getInstance().error(null, "Could not write " + file.getPath());
            }
            boolean bl10 = bl2;
            return bl10;
        }
        finally {
            if (contextImpl != null) {
                contextImpl.fireInstallerEvent(new InstallerFileEvent(contextImpl.getEventSource(), contextImpl, EventType.AFTER_INSTALL_FILE, bl2, file, l));
            }
        }
    }

    private static UninstallMode getParentUninstallMode(UninstallMode uninstallMode) {
        if (uninstallMode == UninstallMode.ALWAYS) {
            return UninstallMode.IF_CREATED;
        }
        if (uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            return UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE;
        }
        return uninstallMode;
    }

    public void uninstall(ProgressInterface progressInterface, boolean bl) throws IOException {
        File file = InstallerUtil.getInstallerFile(LOG_FILENAME);
        FileLogger fileLogger = new FileLogger();
        fileLogger.read(file);
        if (!bl) {
            this.deleteFile(file);
        }
        this.isUninstalling = true;
        this.uninstallForUpgrade = bl;
        if (InstallerUtil.isWindows()) {
            WinDel.prepareDeletion(InstallerUtil.getInstallerFile("i4jdel.exe"));
        }
        this.rollback(progressInterface, fileLogger);
        if (bl) {
            this.writeUninstallLog(fileLogger, file);
        }
    }

    private void writeUninstallLog(FileLogger fileLogger, File file) throws IOException {
        InstallFile installFile;
        HashSet hashSet = new HashSet();
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            installFile = (InstallFile)iterator.next();
            if (installFile.getUninstallMode() == UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE || installFile.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                this.addDirs(installFile.getParentFile(), hashSet);
                continue;
            }
            iterator.remove();
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            installFile = (InstallFile)iterator.next();
            if (installFile.getUninstallMode() != UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE && installFile.getUninstallMode() != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            this.addDirs(installFile, hashSet);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            installFile = (InstallFile)iterator.next();
            if (hashSet.contains(installFile.getCanonicalFile())) continue;
            iterator.remove();
        }
        fileLogger.write(file, null);
    }

    private void addDirs(File file, Set set) throws IOException {
        if (file != null) {
            set.add(file.getCanonicalFile());
            this.addDirs(file.getParentFile(), set);
        }
    }

    public void finishUninstall() throws IOException {
        if (InstallerUtil.isWindows() && (this.undeletedFiles.size() > 0 || this.undeletedDirs.size() > 0)) {
            if (WinDel.isUsed()) {
                WinDel.scheduleDeletion(this.undeletedFiles, this.undeletedDirs, true);
            } else {
                WinDel.setUsed(true);
                Runtime.getRuntime().addShutdownHook(new Thread("temp_deletion_starter"){

                    public void run() {
                        try {
                            WinDel.scheduleDeletion(FileInstaller.this.undeletedFiles, FileInstaller.this.undeletedDirs, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    public void setRollbackBarrier() {
        if (!this.hasUnrollbackedFiles) {
            this.hasUnrollbackedFiles = this.rollbackFileLogger.hasFiles();
        }
        this.rollbackFileLogger = new FileLogger();
    }

    public void rollback(ProgressInterface progressInterface) {
        this.rollback(progressInterface, this.rollbackFileLogger);
    }

    public void rollback(ProgressInterface progressInterface, FileLogger fileLogger) {
        Object object;
        int n = fileLogger.getCreatedFilesSize() + fileLogger.getCreatedDirsSize() + fileLogger.getReplacedFiles().size();
        int n2 = 0;
        for (int i = fileLogger.getReplacedFiles().size() - 1; i >= 0; --i) {
            object = (BackupPair)fileLogger.getReplacedFiles().get(i);
            try {
                ((BackupPair)object).getOriginalFile().delete();
                if (!((BackupPair)object).getBackupFile().renameTo(((BackupPair)object).getOriginalFile())) {
                    FileUtil.copyFile(((BackupPair)object).getBackupFile(), ((BackupPair)object).getOriginalFile());
                }
                ((BackupPair)object).getOriginalFile().setLastModified(((BackupPair)object).getModTime());
            }
            catch (IOException iOException) {
                String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not restore " + ((BackupPair)object).getOriginalFile());
                progressInterface.showFailure(string);
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            object = (InstallFile)iterator.next();
            if (!this.isUninstalling || ((InstallFile)object).checkUninstall(this.uninstallForUpgrade)) {
                if (((InstallFile)object).isShared()) {
                    if (FileInstaller.unregisterShared((File)object)) {
                        this.deleteFile((File)object);
                    }
                } else {
                    this.deleteFile((File)object);
                }
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            object = (InstallFile)iterator.next();
            if (!this.isUninstalling || ((InstallFile)object).checkUninstall(this.uninstallForUpgrade)) {
                this.deleteDir((File)object);
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        this.deleteParentFolders();
    }

    private void deleteParentFolders() {
        ContextImpl contextImpl = ContextImpl.getSingleContextImpl();
        ArrayList arrayList = new ArrayList(this.parentFoldersOfDeletedFiles);
        Collections.sort(arrayList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file = (File)arrayList.get(i);
            if (!FileUtil.isContainedInOrEquals(file, contextImpl.getInstallationDirectory())) continue;
            this.preDeleteDir(file);
            if (file.delete() || !file.exists() || !Util.isWindows() || this.undeletedDirs.contains(file)) continue;
            this.undeletedDirs.add(file);
        }
    }

    public void deleteFile(File file) {
        if (!this.handleClassPathFile(file) && !this.doDeleteFile(file)) {
            this.undeletedFiles.add(file);
        }
        this.parentFoldersOfDeletedFiles.add(file.getParentFile());
    }

    private boolean doDeleteFile(File file) {
        if (!file.delete() && !Util.isWindows() && file.exists()) {
            System.setProperty("install4j.noDefaultChmod", "false");
            UnixFileSystem.setMode(file.isDirectory() ? "755" : "644", file);
            file.delete();
        }
        return !file.exists();
    }

    private boolean handleClassPathFile(File file) {
        if (this.classPathFiles == null) {
            this.classPathFiles = new HashSet();
            FileInstaller.addFiles(this.classPathFiles, System.getProperty("java.class.path"));
            FileInstaller.addFiles(this.classPathFiles, System.getProperty("sun.boot.class.path"));
        }
        try {
            if (this.classPathFiles.contains(file.getCanonicalFile())) {
                Logger.getInstance().info(this, "postponing deletion of " + file);
                this.undeletedFiles.add(file);
                return true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }

    private static void addFiles(Set set, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                set.add(new File(stringTokenizer.nextToken()).getCanonicalFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void deleteDir(File file) {
        this.preDeleteDir(file);
        if (!file.delete() && file.exists()) {
            this.undeletedDirs.add(file);
        }
        this.parentFoldersOfDeletedFiles.add(file.getParentFile());
    }

    private void preDeleteDir(File file) {
        File[] fileArray;
        if (InstallerUtil.isMacOS() && file.exists() && (fileArray = file.listFiles()) != null && fileArray.length == 1 && fileArray[0].getName().equals(DS_STORE_NAME)) {
            fileArray[0].delete();
        }
    }

    public void cleanup(ProgressInterface progressInterface) {
        int n;
        List list = this.newFileLogger.getReplacedFiles();
        for (n = 0; n < list.size(); ++n) {
            BackupPair backupPair = (BackupPair)list.get(n);
            backupPair.getBackupFile().delete();
            progressInterface.setPercentCompleted((n + 1) * 100 / list.size());
        }
        for (n = 0; n < this.cleanupFiles.size(); ++n) {
            ((File)this.cleanupFiles.get(n)).delete();
        }
        this.deleteUndeleted();
    }

    public void setDefaultProgressInterface(ProgressInterface progressInterface) {
        this.defaultProgressInterface = new ProgressAdapter(progressInterface, true);
    }

    public void setLogDir(File file) {
        if (this.logDir == null) {
            this.logDir = file;
            try {
                this.oldFileLogger.read(new File(file, LOG_FILENAME));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeLog() throws IOException {
        this.newFileLogger.write(new File(this.logDir, LOG_FILENAME), this.oldFileLogger);
    }

    public List getUndeletedFiles() {
        return this.undeletedFiles;
    }

    public List getUndeletedDirs() {
        return this.undeletedDirs;
    }

    public boolean wasPreviouslyCreated(File file) {
        return this.oldFileLogger.containsCreatedFile(file);
    }

    public boolean hasRollbackFiles() {
        return this.rollbackFileLogger.hasFiles();
    }

    public boolean hasUnrollbackedFiles() {
        return this.hasUnrollbackedFiles;
    }

    public void registerCleanupFile(File file) {
        this.cleanupFiles.add(file);
    }

    public void deleteUndeleted() {
        File file;
        Iterator iterator = this.undeletedFiles.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (!this.doDeleteFile(file)) continue;
            iterator.remove();
        }
        iterator = this.undeletedDirs.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (!this.doDeleteFile(file)) continue;
            iterator.remove();
        }
        this.deleteParentFolders();
    }
}

