/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.util.NumericTextField;
import com.install4j.runtime.util.StandardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class ProxyDialog
extends StandardDialog {
    protected static final int RADIO_BUTTON_WIDTH = new JRadioButton((String)"").getPreferredSize().width + 1;
    private JRadioButton rdoConnectionDirect;
    private JRadioButton rdoConnectionProxy;
    private JTextField txtHost;
    private NumericTextField txtPort;
    private JCheckBox chkAuth;
    private JTextField txtAuthUser;
    private JTextField txtAuthPassword;
    private JLabel lblHost;
    private JLabel lblPort;
    private JLabel lblUser;
    private JLabel lblPassword;
    private static final int FRAME_WIDTH = 420;
    private ProxyConfig proxyConfig;
    private boolean passwordOnly;

    public static ProxyDialog create(ProxyConfig proxyConfig, Window window) {
        if (window instanceof Frame) {
            return new ProxyDialog(proxyConfig, (Frame)window);
        }
        return new ProxyDialog(proxyConfig, (Dialog)window);
    }

    private ProxyDialog(ProxyConfig proxyConfig, Frame frame) {
        super(frame);
        this.init(proxyConfig);
    }

    private ProxyDialog(ProxyConfig proxyConfig, Dialog dialog) {
        super(dialog);
        this.init(proxyConfig);
    }

    private void init(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
        this.init();
    }

    protected int getFrameHeight() {
        return -1;
    }

    protected int getFrameWidth() {
        return 420;
    }

    public void setPasswordOnly(boolean bl) {
        this.passwordOnly = bl;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateFromProxyConfig();
            if (this.passwordOnly) {
                this.chkAuth.setSelected(true);
                this.checkEnabled();
            }
        }
        super.setVisible(bl);
    }

    protected void doOk() {
        if (this.checkProxySettings()) {
            this.proxyConfig.setProxySet(this.rdoConnectionProxy.isSelected());
            this.proxyConfig.setAuth(this.chkAuth.isSelected());
            this.proxyConfig.setAuthPassword(this.txtAuthPassword.getText());
            this.proxyConfig.setAuthUser(this.txtAuthUser.getText());
            this.proxyConfig.setPort(this.txtPort.getText());
            this.proxyConfig.setHost(this.txtHost.getText());
            super.doOk();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.rdoConnectionDirect || object == this.rdoConnectionProxy || object == this.chkAuth) {
            this.checkEnabled();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void setupControls() {
        super.setupControls();
        this.rdoConnectionDirect = new JRadioButton(" " + Messages.getMessages().getString("DirectConnection"), !this.proxyConfig.isProxySet());
        this.rdoConnectionProxy = new JRadioButton(" " + Messages.getMessages().getString("ProxyConnection"), this.proxyConfig.isProxySet());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdoConnectionDirect);
        buttonGroup.add(this.rdoConnectionProxy);
        this.txtHost = new JTextField();
        this.txtPort = new NumericTextField("", 5);
        this.chkAuth = new JCheckBox(Messages.getMessages().getString("ProxyAuthentication"));
        this.txtAuthUser = new JTextField(15);
        this.txtAuthPassword = new JPasswordField(15);
        this.lblHost = new JLabel(Messages.getMessages().getString("ProxyHost") + ":");
        this.lblPort = new JLabel(Messages.getMessages().getString("ProxyPort") + ":");
        this.lblUser = new JLabel(Messages.getMessages().getString("UserName") + ":");
        this.lblPassword = new JLabel(Messages.getMessages().getString("Password") + ":");
        this.updateFromProxyConfig();
    }

    protected void setupComponent() {
        super.setupComponent();
        this.setTitle(Messages.getMessages().getString("InternetConnection") + " - " + InstallerConfig.getCurrentInstance().getApplicationName());
    }

    private void updateFromProxyConfig() {
        this.txtHost.setText(this.proxyConfig.getHost());
        this.txtPort.setText(this.proxyConfig.getPort());
        this.chkAuth.setSelected(this.proxyConfig.isAuth());
        this.txtAuthUser.setText(this.proxyConfig.getAuthUser());
        this.txtAuthPassword.setText(this.proxyConfig.getAuthPassword());
        this.checkEnabled();
    }

    protected void setupEventHandlers() {
        super.setupEventHandlers();
        this.rdoConnectionDirect.addActionListener(this);
        this.rdoConnectionProxy.addActionListener(this);
        this.chkAuth.addActionListener(this);
        this.txtPort.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                int n = 0;
                try {
                    n = Integer.parseInt(ProxyDialog.this.txtPort.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n < 1 || n > 65536) {
                    GUIHelper.showMessage(ProxyDialog.this.getOwner(), Messages.getMessages().getString("PortValueError"), 0);
                    ProxyDialog.this.txtPort.setText("80");
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                if (ProxyDialog.this.passwordOnly) {
                    if (ProxyDialog.this.txtAuthUser.getText().trim().length() == 0) {
                        ProxyDialog.this.txtAuthUser.requestFocus();
                    } else {
                        ProxyDialog.this.txtAuthPassword.requestFocus();
                    }
                    ProxyDialog.this.passwordOnly = false;
                }
            }
        });
    }

    protected void addScreenContent(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("DownloadError")), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Messages.getMessages().getString("ConnectionParametersRequest")), gridBagConstraints);
        gridBagConstraints.insets.top = 10;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rdoConnectionDirect, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.rdoConnectionProxy, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.left += RADIO_BUTTON_WIDTH;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.createProxySettingsPanel(), gridBagConstraints);
    }

    protected boolean isFillVertical() {
        return false;
    }

    private JPanel createProxySettingsPanel() {
        JPanel jPanel = this.createBorderPanel(Messages.getMessages().getString("ProxySettings"), new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        jPanel.add((Component)this.lblHost, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.lblPort, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.chkAuth, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left += RADIO_BUTTON_WIDTH;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.lblUser, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.lblPassword, gridBagConstraints);
        gridBagConstraints.insets.left -= RADIO_BUTTON_WIDTH;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.txtHost, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.txtPort, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.txtAuthUser, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.txtAuthPassword, gridBagConstraints);
        return jPanel;
    }

    private void checkEnabled() {
        boolean bl = this.rdoConnectionProxy.isSelected();
        this.txtHost.setEnabled(bl);
        this.txtPort.setEnabled(bl);
        this.chkAuth.setEnabled(bl);
        this.lblHost.setEnabled(bl);
        this.lblPort.setEnabled(bl);
        bl = bl && this.chkAuth.isSelected();
        this.txtAuthUser.setEnabled(bl);
        this.lblUser.setEnabled(bl);
        this.txtAuthPassword.setEnabled(bl);
        this.lblPassword.setEnabled(bl);
    }

    private boolean checkProxySettings() {
        return this.rdoConnectionDirect.isSelected() || this.checkTextField(this.txtHost) && (!this.chkAuth.isSelected() || this.checkTextField(this.txtAuthUser) && this.checkTextField(this.txtAuthPassword));
    }
}

