/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerDownloadEvent;
import com.install4j.api.events.InstallerEvent;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class Downloader {
    public static final int MODE_GUI = 1;
    public static final int MODE_CONSOLE = 2;
    public static final int MODE_UNATTENDED = 3;
    private static final String SYSPROP_SHOW_PROXY_CONFIG = "install4j.showProxyConfig";
    private static ProxyConfig proxyConfig = new ProxyConfig();
    private long totalProgress = 0L;
    private long totalSize;
    private String totalSizeVerbose;
    private NumberFormat numberFormat;
    private ProgressInterface progressInterface;
    private Context context;
    private boolean askForProxy;
    long startTime;
    long lastProgressUpdateTime = 0L;
    long currentFileProgress;
    long fileSize;
    private URLConnection connection;
    private MessageDigest md;
    private int mode;

    public static ProxyConfig getProxyConfig() {
        return proxyConfig;
    }

    public Downloader(Context context, ProgressInterface progressInterface, boolean bl) {
        this(context.isUnattended() ? 3 : (context.isConsole() ? 2 : 1), progressInterface);
        this.context = context;
        this.askForProxy = bl;
    }

    public Downloader(int n, ProgressInterface progressInterface) {
        this.progressInterface = progressInterface;
        this.mode = n;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumFractionDigits(1);
        this.totalSize = -1L;
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println(noSuchAlgorithmException.getMessage());
        }
    }

    public void setTotalSize(long l) {
        this.totalSize = l;
    }

    public Downloader connect(String string) throws IOException, UserCanceledException {
        this.currentFileProgress = 0L;
        URL uRL = new URL(string);
        this.connection = this.getURLConnection(uRL);
        this.fileSize = this.connection.getContentLength();
        this.connection.getInputStream();
        return this;
    }

    public void disconnect() throws IOException {
        this.connection.getInputStream().close();
    }

    public byte[] digest() {
        return this.md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(File file, long l, boolean bl) throws IOException, UserCanceledException {
        Set set;
        Object object;
        ContextImpl contextImpl;
        if (this.fileSize == -1L) {
            this.fileSize = l;
        }
        if (this.totalSize == -1L) {
            this.totalSize = this.fileSize;
        }
        if ((contextImpl = ContextImpl.getContextImpl(this.context)) != null) {
            object = new InstallerDownloadEvent(contextImpl.getEventSource(), this.context, EventType.BEFORE_DOWNLOAD, this.connection.getURL(), file, this.totalSize);
            contextImpl.fireInstallerEvent((InstallerEvent)object);
            set = ((InstallerDownloadEvent)object).getDownloadProgressListeners();
        } else {
            set = Collections.EMPTY_SET;
        }
        this.totalSizeVerbose = this.format(this.totalSize, 0x100000L);
        try {
            if (this.progressInterface != null) {
                this.progressInterface.setIndeterminateProgress(false);
            }
            this.updateProgress(true, set);
            this.md.reset();
            object = new DigestOutputStream(new FileOutputStream(file), this.md);
            try {
                this.startTime = System.currentTimeMillis();
                this.currentFileProgress = 0L;
                long l2 = FileUtil.pumpStream(this.connection.getInputStream(), (OutputStream)object, new FileUtil.CopyProgressListener(){

                    public boolean progressPerformed(long l) {
                        Downloader.this.currentFileProgress += l;
                        Downloader.this.totalProgress += l;
                        if (Downloader.this.context != null && Downloader.this.context.isCancelling()) {
                            return false;
                        }
                        Downloader.this.updateProgress(false, set);
                        return true;
                    }
                });
                if (this.context != null && this.context.isCancelling()) {
                    Logger.getInstance().info(contextImpl.getEventSource(), "Download was canceled by the user");
                    this.fireAfterDownloadEvent(contextImpl, EventType.AFTER_DOWNLOAD, file, false);
                    throw new UserCanceledException();
                }
                if (l2 != this.fileSize && this.fileSize != -1L) {
                    throw new IOException("file size not correct: " + l2 + ", expected: " + this.fileSize);
                }
                this.updateProgress(true, set);
                this.fireAfterDownloadEvent(contextImpl, EventType.AFTER_DOWNLOAD, file, true);
            }
            finally {
                ((OutputStream)object).close();
                try {
                    this.connection.getInputStream().close();
                }
                catch (Throwable throwable) {}
                if (bl) {
                    file.deleteOnExit();
                }
            }
        }
        catch (IOException iOException) {
            if (this.mode == 3) {
                System.err.println(iOException.getMessage());
            }
            this.fireAfterDownloadEvent(contextImpl, EventType.AFTER_DOWNLOAD, file, false);
            this.resetLastDownload();
            throw iOException;
        }
    }

    private void fireAfterDownloadEvent(ContextImpl contextImpl, EventType eventType, File file, boolean bl) {
        if (contextImpl != null) {
            contextImpl.fireInstallerEvent(new InstallerDownloadEvent(contextImpl.getEventSource(), this.context, eventType, bl, this.connection.getURL(), file, this.totalSize));
        }
    }

    private void updateProgress(boolean bl, Set set) {
        if (this.progressInterface == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.totalSize > -1L && (bl || l - this.lastProgressUpdateTime > 500L)) {
            long l2 = (long)((double)this.currentFileProgress / (double)(l - this.startTime) * 1000.0);
            this.progressInterface.setDetailMessage(MessageFormat.format(Messages.getMessages().getString("DownloadProgress"), this.format(this.totalProgress, 0x100000L), this.totalSizeVerbose, this.format(100L * this.totalProgress, this.totalSize), this.format(l2, 1024L)));
            this.progressInterface.setPercentCompleted((int)(this.totalProgress * 100L / this.totalSize));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                InstallerDownloadEvent.DownloadProgressListener downloadProgressListener = (InstallerDownloadEvent.DownloadProgressListener)iterator.next();
                downloadProgressListener.downloadCompleted(this.totalProgress);
            }
            this.lastProgressUpdateTime = l;
        }
    }

    private String format(long l, long l2) {
        double d = (double)l / (double)l2;
        return this.numberFormat.format(d);
    }

    private URLConnection getURLConnection(URL uRL) throws IOException, UserCanceledException {
        Object object;
        if (!Boolean.getBoolean("install4j.noProxyAutoDetect") && (object = VersionSpecificHelper.getProxyHostInfo(uRL)) != null) {
            proxyConfig.update((ProxyHostInfo)object);
        }
        HttpAuthenticator.setDownloader(this);
        while (true) {
            if (this.context != null && this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                if (Boolean.getBoolean(SYSPROP_SHOW_PROXY_CONFIG) || !InstallerUtil.isAtLeastJava15() && proxyConfig.isProxySet() && proxyConfig.isPasswordRequired()) {
                    System.setProperty(SYSPROP_SHOW_PROXY_CONFIG, "false");
                    this.askForProxyPassword();
                }
                object = uRL.openConnection();
                proxyConfig.updateConnection((URLConnection)object);
                ((URLConnection)object).connect();
                return object;
            }
            catch (IOException iOException) {
                if (this.mode == 3 || !this.askForProxy) {
                    throw iOException;
                }
                proxyConfig.show(this.mode == 2, false);
                if (!proxyConfig.isCanceled()) continue;
                throw new UserCanceledException();
            }
            break;
        }
    }

    public void askForProxyPassword() throws IOException, UserCanceledException {
        if (this.mode == 3 && System.getProperty("proxyAuthPassword") != null) {
            return;
        }
        if (this.mode == 3 || !this.askForProxy) {
            throw new IOException(Messages.getMessages().getString("ProxyPasswordRequired"));
        }
        proxyConfig.show(this.mode == 2, true);
        if (proxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void resetLastDownload() {
        this.totalProgress -= this.currentFileProgress;
        this.currentFileProgress = 0L;
    }
}

