/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ContentStats;
import com.install4j.runtime.installer.helper.content.CountingInputStream;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.installer.helper.content.Md5Checker;
import com.install4j.runtime.installer.helper.content.PartialFileInputStream;
import com.install4j.runtime.installer.helper.content.SplittedFileInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

class ContentCollector {
    private static final String DATA_DIR_NAME = "data";
    private ProgressInterface progressInterface;
    private InstallerContext context;
    private boolean saveDownloadedFiles;

    public ContentCollector(ProgressInterface progressInterface, InstallerContext installerContext, boolean bl) {
        this.progressInterface = progressInterface;
        this.context = installerContext;
        this.saveDownloadedFiles = bl;
    }

    public Map collectContentStreams(String string) throws UserCanceledException, IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ContentStats contentStats = ContentStats.getInstance();
        String string2 = System.getProperty("exe4j.moduleName");
        Map map = this.initUnextractedFiles();
        Set set = contentStats.getSelectedContentNumbers(string);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            String string3 = (String)iterator.next();
            String string4 = contentStats.getFileName(string3);
            UnextractedInfo unextractedInfo = (UnextractedInfo)map.get(string4);
            if (unextractedInfo != null) {
                object2 = new PartialFileInputStream(new File(string2), unextractedInfo.position, unextractedInfo.length);
                hashMap.put(string3, object2);
                continue;
            }
            object2 = string2 == null ? new File(".") : new File(string2).getAbsoluteFile().getParentFile();
            File file = this.getContentFile(contentStats, string3, string4, (File)object2);
            if (!file.exists() && Util.isMacosInstaller() && (object = (String)this.context.getVariable("sys.mediaDir")) != null) {
                file = this.getContentFile(contentStats, string3, string4, new File((String)object));
            }
            if (!file.exists()) {
                object = InstallerConfig.getCurrentInstance().getDownloadURL();
                if (((String)object).trim().length() == 0) {
                    String string5 = Messages.getMessages().getString("ErrorReadingSource") + "\n" + string4;
                    GUIHelper.showMessage(null, string5, 0);
                    throw new UserCanceledException();
                }
                arrayList.add(string3);
                continue;
            }
            object = new SplittedFileInputStream(file);
            hashMap.put(string3, object);
        }
        hashMap.putAll(this.downloadContentFiles(arrayList));
        return hashMap;
    }

    private File getContentFile(ContentStats contentStats, String string, String string2, File file) {
        File file2 = new File(string2).getAbsoluteFile();
        if (!file2.exists()) {
            file2 = new File(new File(file, contentStats.getDirName()), string2).getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(file, string2).getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(new File(file, DATA_DIR_NAME), string2).getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(new File(file, "common_files.dat"), "common_files." + contentStats.getComponentListString(string) + ".dat").getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(new File(file, DATA_DIR_NAME), "common_files." + contentStats.getComponentListString(string) + ".dat").getAbsoluteFile();
        }
        if (!file2.exists()) {
            file2 = new File(file, "common_files." + contentStats.getComponentListString(string) + ".dat").getAbsoluteFile();
        }
        return file2;
    }

    private Map initUnextractedFiles() throws IOException {
        HashMap<String, UnextractedInfo> hashMap = new HashMap<String, UnextractedInfo>();
        String string = System.getProperty("exe4j.moduleName");
        if (!Util.isMacosInstaller() && string != null) {
            Object object;
            long l;
            int n = Integer.getInteger("exe4j.unextractedPositionRestart", 0);
            if (n == 0) {
                n = Integer.getInteger("exe4j.unextractedPosition", 0);
            }
            if (n == 0) {
                l = Long.getLong("exe4j.totalDataLength", 0L);
                object = new File(string);
                if (l > 0L && ((File)object).exists()) {
                    n = (int)(((File)object).length() - l);
                }
            }
            if (n > 0) {
                l = 0L;
                object = new CountingInputStream(new BufferedInputStream(new FileInputStream(string)));
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                dataInputStream.skipBytes(n);
                if (dataInputStream.readInt() == -387705899) {
                    UnextractedInfo unextractedInfo;
                    int n2 = dataInputStream.readInt();
                    for (int i = 0; i < n2; ++i) {
                        unextractedInfo = new UnextractedInfo();
                        String string2 = dataInputStream.readUTF();
                        unextractedInfo.length = dataInputStream.readLong();
                        unextractedInfo.position = l;
                        l += unextractedInfo.length;
                        hashMap.put(string2, unextractedInfo);
                    }
                    Iterator iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        unextractedInfo = (UnextractedInfo)iterator.next();
                        unextractedInfo.position += ((CountingInputStream)object).getCount();
                    }
                } else {
                    throw new IOException("wrong magic number");
                }
                dataInputStream.close();
            }
        }
        return hashMap;
    }

    private Map downloadContentFiles(List list) throws IOException, UserCanceledException {
        Object object;
        Downloader downloader = new Downloader(this.context, this.progressInterface, true);
        this.progressInterface.setStatusMessage(Messages.getMessages().getString("Downloading"));
        ContentStats contentStats = ContentStats.getInstance();
        long l = 0L;
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            l += contentStats.getFileSize((String)object);
        }
        downloader.setTotalSize(l);
        object2 = new HashMap();
        object = list.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            boolean bl = true;
            while (bl) {
                try {
                    File file = this.downloadSingleFile(string, downloader);
                    object2.put(string, new FileInputStream(file));
                    bl = false;
                }
                catch (IOException iOException) {
                    downloader.resetLastDownload();
                    Logger.getInstance().info(this, iOException.toString());
                    this.askRetry("DownloadContentError");
                }
            }
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadSingleFile(String string, Downloader downloader) throws IOException, UserCanceledException {
        ContentStats contentStats = ContentStats.getInstance();
        File file = null;
        try {
            boolean bl;
            String string2 = InstallerConfig.getCurrentInstance().getDownloadURL().trim();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            String string3 = null;
            do {
                String string4;
                String string5 = null;
                do {
                    bl = false;
                    string4 = this.connect(string, string2, downloader);
                    String string6 = (String)this.context.getVariable("sys.mediaDir");
                    if (this.saveDownloadedFiles && string6 != null) {
                        try {
                            File file2 = File.createTempFile("i4jc", ".tst", new File(string6));
                            if (!file2.delete()) {
                                file2.deleteOnExit();
                            }
                            file = new File(string6, string4);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (file == null) {
                        file = File.createTempFile("i4jc", ".dat");
                    }
                    try {
                        downloader.download(file, contentStats.getFileSize(string), !this.saveDownloadedFiles);
                        string5 = Md5Checker.getHexStringFromBytes(downloader.digest());
                    }
                    catch (IOException iOException) {
                        Logger.getInstance().error(this, "could not download file");
                        Logger.getInstance().log(iOException);
                        this.askRetry("DownloadInterrupted");
                        bl = true;
                    }
                } while (bl);
                bl = false;
                if (string3 == null) {
                    string3 = Md5Checker.getExpectedMd5(this.context, true, string2 + "md5sums", string4);
                }
                if ("".equals(string3)) continue;
                Logger.getInstance().info(this, "expected md5 " + string3 + ", real md5 " + string5);
                if (string3.equals(string5)) continue;
                downloader.resetLastDownload();
                this.askRetry("DownloadFileCorrupt");
                bl = true;
            } while (bl);
        }
        finally {
            if (!this.saveDownloadedFiles && file != null) {
                file.deleteOnExit();
            }
        }
        return file;
    }

    private String connect(String string, String string2, Downloader downloader) throws UserCanceledException, IOException {
        ContentStats contentStats = ContentStats.getInstance();
        String string3 = contentStats.getFileName(string);
        String string4 = string2 + string3;
        try {
            Logger.getInstance().info(this, "Trying to load " + string4);
            downloader.connect(string4);
        }
        catch (IOException iOException) {
            Logger.getInstance().info(this, iOException.toString());
            string3 = "common_files." + contentStats.getComponentListString(string) + ".dat";
            string4 = string2 + string3;
            Logger.getInstance().info(this, "Trying to load " + string4);
            downloader.connect(string4);
        }
        Logger.getInstance().info(this, "connected");
        return string3;
    }

    private void askRetry(String string) throws UserCanceledException {
        ResourceBundle resourceBundle = Messages.getMessages();
        switch (GUIHelper.showOptionDialog(GUIHelper.getParentWindow(), resourceBundle.getString(string), new String[]{resourceBundle.getString("ButtonOK"), resourceBundle.getString("ButtonCancel")}, 2)) {
            case -1: 
            case 1: {
                throw new UserCanceledException();
            }
        }
    }

    private static class UnextractedInfo {
        private long position;
        private long length;

        private UnextractedInfo() {
        }
    }
}

