/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm;

import com.install4j.api.Util;
import com.install4j.api.windows.Elevation;
import com.install4j.api.windows.ElevationState;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import com.install4j.runtime.installer.helper.comm.CommunicationReceiver;
import com.install4j.runtime.installer.helper.comm.Response;
import com.install4j.runtime.installer.helper.comm.SetProcessIdAction;
import com.install4j.runtime.installer.helper.comm.TerminateAction;
import com.install4j.runtime.installer.helper.launching.LaunchApplicationAction;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.platform.unix.FileCommunicationBackend;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ProcessCommunication {
    private static ProcessCommunication instance = new ProcessCommunication();
    private CommunicationBackend backend = Util.isAtLeastWindowsVista() ? new Win32CommunicationBackend() : new FileCommunicationBackend();
    private boolean exitNow = false;
    private int exitCode = 1;
    private int senderProcessId = 0;
    private boolean hasHelper = false;
    private boolean connected = false;
    private boolean terminated = false;
    private String createdListener = null;

    public static ProcessCommunication getInstance() {
        return instance;
    }

    private ProcessCommunication() {
    }

    private String getParentIdentifier() {
        String string = System.getProperty("install4j.commIdentifier");
        if ("null".equals(string)) {
            return null;
        }
        return string;
    }

    public boolean isElevatedAndApplicable() {
        try {
            return this.isSender() && this.connected && (Util.isAtLeastWindowsVista() && Elevation.getElevationState() == ElevationState.ELEVATION_STATE_FULL || Util.isMacosInstaller() && UnixUserInfo.ROOT_USER);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isUnelevatedAndApplicable() {
        try {
            return this.isSender() && this.connected && (Util.isAtLeastWindowsVista() && Elevation.getElevationState() == ElevationState.ELEVATION_STATE_LIMITED || Util.isMacosInstaller() && !UnixUserInfo.ROOT_USER);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean isSpawnedProcess() {
        return this.backend != null && this.getParentIdentifier() != null;
    }

    public boolean isSender() {
        return this.isSpawnedProcess() && !this.isHelper() || this.hasHelper;
    }

    private boolean isHelper() {
        return Boolean.getBoolean("install4j.elevatedHelper") || Boolean.getBoolean("install4j.unelevatedHelper");
    }

    void setSenderProcessId(int n) {
        if (this.senderProcessId == 0) {
            System.out.println("setting sender proc id to " + n);
            this.senderProcessId = n;
        }
    }

    void setExitCode(int n) {
        this.exitCode = n;
    }

    public Response sendAction(CommunicationAction communicationAction) {
        if (!this.isSender() || !this.connected) {
            return null;
        }
        Response response = this.sendData(communicationAction);
        return response;
    }

    public boolean sendActionAndCheck(CommunicationAction communicationAction) {
        Response response = this.sendAction(communicationAction);
        return response != null && response.isSuccess();
    }

    private Response sendData(Serializable serializable) {
        if (this.backend != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.close();
                if (!this.backend.writeDataBlock(byteArrayOutputStream.toByteArray(), this.isSender())) {
                    return null;
                }
                if (this.isSender()) {
                    block10: {
                        try {
                            Response response = (Response)ProcessCommunication.getDataObject(this.backend.readDataBlock(true));
                            if (response != null && response.getLog() != null && response.getLog().length() > 0) {
                                Logger.getInstance().logString("---------------------------- Helper Process Log ----------------------------\n" + response.getLog() + "----------------------------------------------------------------------------\n");
                            }
                            return response;
                        }
                        catch (IOException iOException) {
                            if (!(serializable instanceof TerminateAction)) {
                                iOException.printStackTrace();
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (serializable instanceof TerminateAction) break block10;
                            classNotFoundException.printStackTrace();
                        }
                    }
                    return null;
                }
                return new Response(true, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public boolean terminateReceiver(int n) {
        try {
            if (!this.terminated && this.isSender()) {
                this.terminated = true;
                Response response = this.sendAction(new TerminateAction(n));
                if (InstallerUtil.isWindows()) {
                    Thread.sleep(2000L);
                }
                return response != null && response.isSuccess();
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean connect() {
        if (this.backend.connect(this.getParentIdentifier())) {
            this.connected = true;
            if (this.isSender()) {
                this.senderProcessId = this.backend.getProcessId();
                if (this.sendAction(new SetProcessIdAction(this.senderProcessId)) == null) {
                    this.connected = false;
                    return false;
                }
                Runtime.getRuntime().addShutdownHook(new Thread("_proc_comm_shutdown"){

                    public void run() {
                        ProcessCommunication.this.terminateReceiver(1);
                    }
                });
            }
            return true;
        }
        return false;
    }

    public String createListener(boolean bl) {
        if (this.backend != null) {
            if (this.createdListener == null) {
                this.createdListener = this.backend.createListener();
            }
            if (this.createdListener != null) {
                this.hasHelper = bl;
            }
            return this.createdListener;
        }
        return null;
    }

    public void receiveActions(final CommunicationReceiver communicationReceiver) {
        if (this.backend != null) {
            new Thread("process_comm"){

                public void run() {
                    if (ProcessCommunication.this.connect()) {
                        byte[] byArray = ProcessCommunication.this.backend.readDataBlock(false);
                        while (byArray != null && ProcessCommunication.this.handleData(byArray, communicationReceiver)) {
                            byArray = ProcessCommunication.this.backend.readDataBlock(false);
                        }
                    }
                    ProcessCommunication.this.exitNow = true;
                }
            }.start();
        }
    }

    public int waitForFinish() {
        if (this.backend != null) {
            int n = 0;
            while (!this.exitNow && (this.senderProcessId == 0 && n < 1200 || this.senderProcessId != 0 && this.backend.isProcessAlive(this.senderProcessId))) {
                try {
                    Thread.sleep(200L);
                    ++n;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        return this.exitCode;
    }

    private boolean handleData(byte[] byArray, CommunicationReceiver communicationReceiver) {
        if (communicationReceiver == null) {
            communicationReceiver = new CommunicationReceiver(){

                public void actionReceived(CommunicationAction communicationAction) {
                }
            };
        }
        try {
            Object object = ProcessCommunication.getDataObject(byArray);
            if (object instanceof CommunicationAction) {
                Logger.getInstance().switchToString();
                CommunicationAction communicationAction = (CommunicationAction)object;
                communicationReceiver.actionReceived(communicationAction);
                KeepAliveThread keepAliveThread = new KeepAliveThread();
                keepAliveThread.start();
                Response response = communicationAction.execute(this);
                keepAliveThread.finish();
                String string = Logger.getInstance().switchBackFromString();
                if (response != null) {
                    if (response.getLog() == null) {
                        response.setLog(string);
                    }
                    this.sendData(response);
                    return true;
                }
                this.sendData(new Response());
                return false;
            }
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return false;
    }

    private static Object getDataObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    class KeepAliveThread
    extends Thread {
        private final Object waiter = new Object();
        private boolean running = false;
        private boolean finished = false;

        KeepAliveThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = this.waiter;
                synchronized (object) {
                    this.running = true;
                    while (!this.finished) {
                        this.waiter.wait(60000L);
                        ProcessCommunication.this.backend.sendKeepAlive();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            this.finished = true;
            Object object = this.waiter;
            synchronized (object) {
                if (!this.running) {
                    return;
                }
                this.waiter.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static class ProcCommChildTest {
        public static void main(String[] stringArray) throws InterruptedException {
            ProcessCommunication processCommunication = ProcessCommunication.getInstance();
            System.setProperty("install4j.commIdentifier", "\\\\.\\pipe\\i4jcomm0");
            System.setProperty("install4j.commIdentifier", "C:\\Users\\hannes\\AppData\\Local\\Temp\\i4c3687871065797089418.com");
            System.out.println("sending child test");
            System.out.println(processCommunication.connect());
            System.out.println(processCommunication.sendAction(new LaunchApplicationAction(new LaunchDescriptor(new File("test")))));
            System.out.println(processCommunication.sendAction(new LaunchApplicationAction(new LaunchDescriptor(new File("test")))));
            System.out.println(processCommunication.sendAction(new LaunchApplicationAction(new LaunchDescriptor(new File("test")))));
            System.out.println(processCommunication.sendAction(new WaitLongAction()));
            System.out.println(processCommunication.terminateReceiver(23));
        }
    }

    public static class ProcCommParentTest {
        public static void main(String[] stringArray) throws InterruptedException {
            ProcessCommunication processCommunication = ProcessCommunication.getInstance();
            System.out.println("receiving parent test");
            System.out.println(processCommunication.createListener(false));
            processCommunication.receiveActions(new CommunicationReceiver(){

                public void actionReceived(CommunicationAction communicationAction) {
                }
            });
            System.exit(processCommunication.waitForFinish());
        }
    }

    public static class ProcCommReceivingChildTest {
        public static void main(String[] stringArray) {
            ProcessCommunication processCommunication = ProcessCommunication.getInstance();
            System.out.println("receiving child test");
            System.setProperty("install4j.elevatedHelper", "true");
            System.setProperty("install4j.commIdentifier", "\\\\.\\pipe\\i4jcomm0");
            processCommunication.receiveActions(new CommunicationReceiver(){

                public void actionReceived(CommunicationAction communicationAction) {
                }
            });
            System.exit(processCommunication.waitForFinish());
        }
    }

    public static class ProcCommSendingParentTest {
        public static void main(String[] stringArray) throws InterruptedException {
            System.out.println("sending parent test");
            ProcessCommunication processCommunication = ProcessCommunication.getInstance();
            System.out.println(processCommunication.createListener(true));
            Thread.sleep(10000L);
            System.out.println("connecting");
            System.out.println(processCommunication.connect());
            System.out.println(processCommunication.sendAction(new LaunchApplicationAction(new LaunchDescriptor(new File("test")))));
            System.out.println(processCommunication.sendAction(new LaunchApplicationAction(new LaunchDescriptor(new File("test")))));
            System.out.println(processCommunication.sendAction(new LaunchApplicationAction(new LaunchDescriptor(new File("test")))));
            System.out.println(processCommunication.terminateReceiver(23));
        }
    }

    private static class WaitLongAction
    implements CommunicationAction {
        private WaitLongAction() {
        }

        public Response execute(ProcessCommunication processCommunication) {
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return new Response(true);
        }
    }
}

