/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class VariableEncoding {
    public static final String BOOLEAN_SUFFIX = "$Boolean";
    public static final String DATE_SUFFIX = "$Date";
    public static final String INTEGER_SUFFIX = "$Integer";
    public static final String LONG_SUFFIX = "$Long";
    public static final String INT_ARRAY_SUFFIX = "$IntArray";
    public static final String STRING_ARRAY_SUFFIX = "$StringArray";

    public static Map decodeVariables(Map map, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = string;
            int n = string.indexOf(36);
            if (n > -1) {
                string3 = string.substring(0, n);
            }
            try {
                hashMap.put(string3, VariableEncoding.decodeVariable(string, string2));
            }
            catch (Exception exception) {
                if (bl) continue;
                String string4 = "Could not decode variable " + string + ": " + exception.toString();
                Logger.getInstance().error(null, string4);
                System.err.println(string4);
            }
        }
        return hashMap;
    }

    private static Object decodeVariable(String string, String string2) {
        if (string.endsWith(BOOLEAN_SUFFIX)) {
            return Boolean.valueOf(string2);
        }
        if (string.endsWith(DATE_SUFFIX)) {
            return new Date(Long.parseLong(string2));
        }
        if (string.endsWith(INTEGER_SUFFIX)) {
            return new Integer(string2);
        }
        if (string.endsWith(LONG_SUFFIX)) {
            return new Long(string2);
        }
        if (string.endsWith(INT_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeIntegerArray(string2);
        }
        if (string.endsWith(STRING_ARRAY_SUFFIX)) {
            return VariableEncoding.decodeStringArray(string2);
        }
        return string2;
    }

    public static Object decodeIntegerArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = new StringTokenizer(string, ",");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object).nextToken();
            arrayList.add(string2.trim());
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            object[i] = Integer.parseInt(string3);
        }
        return object;
    }

    public static Object decodeStringArray(String string) {
        char c;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (i == 0 && c != '\"') {
                throw new IllegalArgumentException("Missing quote at the beginning of " + string);
            }
            if (c == '\"') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    continue;
                }
                arrayList.add(stringBuffer.toString());
                stringBuffer = null;
                continue;
            }
            if (c == '\\') {
                ++i;
                if (stringBuffer == null) continue;
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (stringBuffer != null) {
                stringBuffer.append(c);
                continue;
            }
            if (c == ',' || Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("Illegal separator \"" + c + "\" in " + string);
        }
        if (stringBuffer != null) {
            throw new IllegalArgumentException("Unmatched quotes in " + string);
        }
        String[] stringArray = new String[arrayList.size()];
        for (c = '\u0000'; c < arrayList.size(); ++c) {
            stringArray[c] = (String)arrayList.get(c);
        }
        return stringArray;
    }

    public static boolean encodeVariable(Properties properties, String string, Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            properties.put(string, object);
        } else if (object instanceof Boolean) {
            properties.put(string + BOOLEAN_SUFFIX, object.toString());
        } else if (object instanceof Date) {
            properties.put(string + DATE_SUFFIX, String.valueOf(((Date)object).getTime()));
        } else if (object instanceof Integer) {
            properties.put(string + INTEGER_SUFFIX, object.toString());
        } else if (object instanceof Long) {
            properties.put(string + LONG_SUFFIX, object.toString());
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(nArray[i]);
                if (i >= nArray.length - 1) continue;
                stringBuffer.append(",");
            }
            properties.put(string + INT_ARRAY_SUFFIX, stringBuffer.toString());
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\"").append(VariableEncoding.encodeArrayString(stringArray[i])).append("\"");
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(",");
            }
            properties.put(string + STRING_ARRAY_SUFFIX, stringBuffer.toString());
        } else {
            return false;
        }
        return true;
    }

    private static String encodeArrayString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        VariableEncoding.encodeVariable(properties, "stringVar", "test\\\"");
        VariableEncoding.encodeVariable(properties, "booleanVar", Boolean.TRUE);
        VariableEncoding.encodeVariable(properties, "integerVar", new Integer(123));
        VariableEncoding.encodeVariable(properties, "dateVar", new Date());
        VariableEncoding.encodeVariable(properties, "intArray", new int[0]);
        VariableEncoding.encodeVariable(properties, "stringArray", new String[0]);
        VariableEncoding.encodeVariable(properties, "stringArray2", new String[]{"One", "Two\" c\\3"});
        properties.list(System.out);
        System.out.println("decode");
        Map map = VariableEncoding.decodeVariables(properties, false);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            System.out.println(entry.getKey());
            Object v = entry.getValue();
            Object object = v instanceof String[] ? Arrays.asList((String[])v) : v;
            System.out.println(entry.getValue().getClass().getName() + ": " + object);
            System.out.println("---------");
        }
    }
}

