/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinProcesses;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessesDialog;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public class RunningProcessChecker {
    public static final int CLOSE_STRATEGY_NONE = 0;
    public static final int CLOSE_STRATEGY_ASK_ONLY = 1;
    public static final int CLOSE_STRATEGY_ASK_FOR_CLOSE = 2;
    public static final int CLOSE_STRATEGY_ASK_FOR_CLOSE_AND_TERMINATE = 3;
    public static final int CLOSE_STRATEGY_ASK_FOR_TERMINATE = 4;
    public static final int CLOSE_STRATEGY_CLOSE = 5;
    public static final int CLOSE_STRATEGY_TERMINATE = 6;
    private static boolean defaultChecked = false;

    public static boolean areInstalledLaunchersRunning() {
        try {
            return !RunningProcessChecker.checkRunningProcessesInt(RunningProcessChecker.getLauncherFiles(), null, 0, 0, false);
        }
        catch (UserCanceledException userCanceledException) {
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        return false;
    }

    public static boolean checkDefaultRunningLauncher(String string) throws UserCanceledException {
        if (Boolean.getBoolean("install4j.dontCheckProcesses")) {
            return true;
        }
        if (!InstallerUtil.isWindows() || defaultChecked) {
            return true;
        }
        ResourceBundle resourceBundle = Messages.getMessages();
        String string2 = MessageFormat.format(resourceBundle.getString(string), "install4j", InstallerConfig.getCurrentInstance().getApplicationName());
        try {
            defaultChecked = RunningProcessChecker.checkRunningProcessesInt(RunningProcessChecker.getLauncherFiles(), string2, 1, 0, false);
            return defaultChecked;
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return true;
        }
    }

    public static boolean checkRunningProcesses(String string, int n, int n2, boolean bl, boolean bl2, File[] fileArray) throws UserCanceledException {
        int n3;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        HashSet<File> hashSet = new HashSet<File>();
        try {
            if (bl2) {
                hashSet.addAll(RunningProcessChecker.getLauncherFiles());
            }
            if (fileArray != null) {
                for (n3 = 0; n3 < fileArray.length; ++n3) {
                    hashSet.add(fileArray[n3].getCanonicalFile());
                }
            }
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        n3 = RunningProcessChecker.checkRunningProcessesInt(hashSet, string, n, n2, bl) ? 1 : 0;
        if (bl2 && n3 != 0) {
            defaultChecked = true;
        }
        return n3 != 0;
    }

    private static boolean checkRunningProcessesInt(Set set, String string, int n, int n2, boolean bl) throws UserCanceledException {
        boolean bl2 = true;
        Collection collection;
        while ((collection = RunningProcessChecker.getRunningProcesses(set)).size() != 0) {
            String string2;
            Serializable serializable;
            if (n == 0) {
                return false;
            }
            if (n == 5) {
                return RunningProcessChecker.closeProcesses(false, n2, collection);
            }
            if (n == 6) {
                return RunningProcessChecker.closeProcesses(true, n2, collection);
            }
            if (InstallerUtil.isUnattended()) {
                if (string != null) {
                    System.err.println(Messages.getMessages().getString("UnattendedRunningFailure"));
                }
                return false;
            }
            if (string == null) {
                return false;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            Object object = collection.iterator();
            while (object.hasNext()) {
                serializable = (Misc.ProcessInfo)object.next();
                string2 = WinProcesses.getWindowTitle(((Misc.ProcessInfo)serializable).getProcessId());
                if (string2 != null && string2.trim().length() > 0 && !string2.equals("Default IME") && !string2.equals("theAwtToolkitWindow")) {
                    treeSet.add(string2);
                    continue;
                }
                treeSet.add(new File(((Misc.ProcessInfo)serializable).getModuleName()).getAbsolutePath());
            }
            object = Messages.getMessages();
            serializable = new ArrayList();
            switch (n) {
                case 2: {
                    serializable.add(((ResourceBundle)object).getString("ButtonCloseProcesses"));
                    break;
                }
                case 3: {
                    serializable.add(((ResourceBundle)object).getString(bl2 ? "ButtonCloseProcesses" : "ButtonTerminateProcesses"));
                    break;
                }
                case 4: {
                    serializable.add(((ResourceBundle)object).getString("ButtonTerminateProcesses"));
                }
            }
            serializable.add(((ResourceBundle)object).getString("ButtonRetry"));
            if (bl) {
                serializable.add(((ResourceBundle)object).getString("ButtonIgnore"));
            }
            if ((string2 = RunningProcessChecker.showDialog(string, treeSet, (List)((Object)serializable))) == null) {
                return false;
            }
            if (string2.equals(((ResourceBundle)object).getString("ButtonIgnore"))) {
                return true;
            }
            if (string2.equals(((ResourceBundle)object).getString("ButtonTerminateProcesses")) ? RunningProcessChecker.closeProcesses(true, n2, collection) : string2.equals(((ResourceBundle)object).getString("ButtonCloseProcesses")) && RunningProcessChecker.closeProcesses(false, n2, collection)) {
                return true;
            }
            bl2 = false;
        }
        return true;
    }

    private static String showDialog(String string, Collection collection, List list) throws UserCanceledException {
        RunningProcessesDialog runningProcessesDialog = RunningProcessesDialog.create(Util.getParentWindow(), string, collection, list);
        runningProcessesDialog.setVisible(true);
        if (runningProcessesDialog.isCanceled()) {
            return null;
        }
        return (String)list.get(runningProcessesDialog.getSelectedButtonIndex());
    }

    private static boolean closeProcesses(boolean bl, int n, Collection collection) {
        int[] nArray = new int[collection.size()];
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            nArray[n2++] = ((Misc.ProcessInfo)iterator.next()).getProcessId();
        }
        return Misc.terminateProcesses(nArray, bl, n) == 1;
    }

    private static Set getLauncherFiles() throws IOException {
        ContextImpl contextImpl = ContextImpl.getContextImpl(ContextImpl.getSingleContextImpl());
        InstallationProperties installationProperties = contextImpl.getInstallationProperties();
        Set set = installationProperties.getCanonicalFilePropertySet("launcher");
        if (!(contextImpl instanceof UninstallerContext)) {
            set.add(new File(contextImpl.getInstallationDirectory(), InstallerConfig.getCurrentInstance().getUninstallerPath() + ".exe").getCanonicalFile());
        }
        return set;
    }

    private static Collection getRunningProcesses(Set set) {
        HashSet hashSet = new HashSet();
        RunningProcessChecker.checkModules(hashSet, set, (Misc.ProcessInfo[])ContextImpl.runElevatedInt(new GetModulesRemoteCallable(), true));
        RunningProcessChecker.checkModules(hashSet, set, (Misc.ProcessInfo[])ContextImpl.runUnelevatedInt(new GetModulesRemoteCallable(), false));
        return hashSet;
    }

    public static Collection getAllRunningProcesses() {
        HashSet<Misc.ProcessInfo> hashSet = new HashSet<Misc.ProcessInfo>();
        Misc.ProcessInfo[] processInfoArray = (Misc.ProcessInfo[])ContextImpl.runElevatedInt(new GetModulesRemoteCallable(), true);
        if (processInfoArray != null) {
            hashSet.addAll(Arrays.asList(processInfoArray));
        }
        if ((processInfoArray = (Misc.ProcessInfo[])ContextImpl.runUnelevatedInt(new GetModulesRemoteCallable(), false)) != null) {
            hashSet.addAll(Arrays.asList(processInfoArray));
        }
        return hashSet;
    }

    private static void checkModules(Collection collection, Set set, Misc.ProcessInfo[] processInfoArray) {
        if (processInfoArray != null) {
            for (int i = 0; i < processInfoArray.length; ++i) {
                File file;
                try {
                    file = new File(processInfoArray[i].getModuleName()).getCanonicalFile();
                }
                catch (IOException iOException) {
                    continue;
                }
                if (!set.contains(file)) continue;
                collection.add(processInfoArray[i]);
            }
        }
    }

    private static class GetModulesRemoteCallable
    extends AbstractRemoteCallable {
        private GetModulesRemoteCallable() {
        }

        public Serializable execute() {
            RunningProcessThread runningProcessThread = new RunningProcessThread();
            runningProcessThread.start();
            try {
                runningProcessThread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (runningProcessThread.isAlive()) {
                runningProcessThread.stop();
            }
            return runningProcessThread.getModules();
        }
    }

    private static class RunningProcessThread
    extends Thread {
        private Misc.ProcessInfo[] modules = null;

        public RunningProcessThread() {
            super("running-process-thread");
            this.setDaemon(true);
            this.setPriority(3);
        }

        public Misc.ProcessInfo[] getModules() {
            return this.modules;
        }

        public void run() {
            this.modules = Misc.getRunningProcesses();
        }
    }
}

