/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;

public class MenuHelper {
    public static void installWindowsMenu(File file, File file2, File file3) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(file, file2, file3, null, null);
    }

    public static void installWindowsMenu(File file, File file2, File file3, String string, String string2) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(file, file2, file3, string, string2, null);
    }

    public static void installWindowsMenu(File file, File file2, File file3, String string, String string2, File file4) throws IOException, UserCanceledException {
        if (!file2.exists()) {
            return;
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        if (file2.getName().endsWith(".url")) {
            File file5 = new File(file.getAbsolutePath() + ".url");
            FileInstaller.getInstance().install(file2, file5, new FileOptions(file2.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
            ShellLink.changeNotfiy(file5);
        } else {
            File file6 = new File(file.getAbsolutePath() + ".lnk");
            File file7 = new File(file.getAbsolutePath() + ".pif");
            File file8 = File.createTempFile("i4j", ".lnk");
            File file9 = new File(file8.getAbsolutePath().substring(0, file8.getAbsolutePath().length() - 3) + "pif");
            ShellLink.create(file8, file2, file3, string, string2, file4);
            if (file8.exists()) {
                FileInstaller.getInstance().install(file8, file6, new FileOptions(file8.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                file7.delete();
            } else if (file9.exists()) {
                FileInstaller.getInstance().install(file9, file7, new FileOptions(file9.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                file6.delete();
            }
            file8.delete();
            file9.delete();
            ShellLink.changeNotfiy(file6);
        }
    }

    public static File installUnixDesktopFile(File file, File file2, File file3, String string, String string2, String string3) throws IOException, UserCanceledException {
        if (file3 == null || !file3.exists()) {
            return null;
        }
        File file4 = new File(file2, string + ".desktop");
        File file5 = File.createTempFile("i4j", null);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file5));
        printWriter.println("#!/usr/bin/env xdg-open");
        printWriter.println("[Desktop Entry]");
        printWriter.println("Type=Application");
        printWriter.println("Name=" + string);
        printWriter.println("Exec=/bin/sh \"" + file3.getAbsolutePath() + "\"" + (string3 == null ? "" : " " + string3));
        File file6 = new File(file, ".install4j/" + file3.getName() + ".png");
        if (file6.exists()) {
            printWriter.println("Icon=" + file6.getAbsolutePath());
        }
        if (string2 != null) {
            printWriter.println("Categories=" + string2 + (!string2.trim().endsWith(";") ? ";" : ""));
        }
        printWriter.close();
        FileInstaller.getInstance().install(file5, file4, new FileOptions("755", OverwriteMode.ALWAYS, false));
        file5.delete();
        return file4;
    }

    public static void installUnixMenu(File file, File file2, String string, String string2, String string3) throws IOException, UserCanceledException {
        File file3;
        File file4 = MenuHelper.installUnixDesktopFile(file, file, file2, string, string2, string3);
        if (file4 != null && !file2.getCanonicalPath().equals(new File(file, InstallerConfig.getCurrentInstance().getUninstallerPath()).getCanonicalPath()) && (file3 = MenuHelper.getMenuFile(string)) != null) {
            FileInstaller.getInstance().install(file4, file3, new FileOptions("644", OverwriteMode.ALWAYS, false));
        }
    }

    public static File getMenuFile(String string) {
        File[] fileArray = new File[]{new File("/usr/share/applications"), new File("/usr/local/share/applications"), new File(System.getProperty("user.home"), ".local/share/applications")};
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            File file2 = fileArray[i];
            File file3 = file2.getParentFile();
            if (!file2.getPath().startsWith("/usr") && !file2.exists() && file3.exists()) {
                file2.mkdir();
            }
            if ((file = MenuHelper.createMenuFile(string, file2)) == null) continue;
            return file;
        }
        return null;
    }

    private static File createMenuFile(String string, File file) {
        File file2 = null;
        if (file.canWrite()) {
            int n = 0;
            do {
                file2 = new File(file, string + "-" + n + ".desktop");
                ++n;
            } while (file2.exists() && !FileInstaller.getInstance().wasPreviouslyCreated(file2));
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUrlLink(File file, String string, File file2, boolean bl) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println("[InternetShortcut]");
            printWriter.print("URL=");
            printWriter.println(string);
            if (bl) {
                try {
                    URL uRL = new URL(string);
                    printWriter.print("IconFile=");
                    printWriter.print(uRL.getProtocol());
                    printWriter.print("://");
                    printWriter.print(uRL.getHost());
                    printWriter.println("/favicon.ico");
                    printWriter.println("IconIndex=1");
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else if (file2 != null) {
                printWriter.print("IconFile=");
                printWriter.println(file2.getPath());
                printWriter.println("IconIndex=1");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static void installUrlLink(String string, File file, File file2, boolean bl) throws IOException, UserCanceledException {
        File file3 = File.createTempFile("i4j", ".url");
        MenuHelper.createUrlLink(file3, string, file2, bl);
        MenuHelper.installWindowsMenu(file, file3, null, null, null);
        file3.delete();
    }
}

