/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.comm.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.ProcessCommunication;
import com.install4j.runtime.installer.helper.comm.Response;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Logger
implements InstallerEventListener {
    public static final List LOGGED_EVENT_TYPES = Arrays.asList(EventType.BEFORE_EXECUTE_ACTION, EventType.AFTER_EXECUTE_ACTION, EventType.BEFORE_ROLLBACK_ACTION, EventType.AFTER_ROLLBACK_ACTION, EventType.BEFORE_INSTALL_FILE, EventType.BEFORE_DOWNLOAD, EventType.SHOW_SCREEN, EventType.FINISHED, EventType.CANCELED, EventType.VARIABLE_CHANGED);
    public static final List LOGGED_EVENT_TYPES_FAILURE_ONLY = Arrays.asList(EventType.AFTER_INSTALL_FILE, EventType.AFTER_DOWNLOAD);
    private static Logger instance;
    public static final String KEEP_LOGFILE_PROP = "install4j.keepLog";
    public static final String ALTERNATIVE_LOGFILE = "install4j.alternativeLogfile";
    public static final String LOGTOSTDERR_FILE_PROP = "install4j.logToStderr";
    public static final String LOG_ENCODING_PROP = "install4j.logEncoding";
    private PrintWriter out;
    private File logFile;
    private boolean moved;
    private PrintWriter previousOut;
    private StringWriter stringWriter;
    private WeakReference lastSource;
    private String lastPrefix;
    private Action currentAction;
    private Screen currentScreen;

    public static Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    private Logger() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        try {
            String string;
            String string2;
            String string3 = System.getProperty(ALTERNATIVE_LOGFILE);
            if ("null".equals(string3)) {
                string3 = null;
            }
            if ((string2 = string3) != null) {
                this.logFile = new File(string2);
                this.logFile.getParentFile().mkdirs();
            } else {
                string = "i4j_log";
                String string4 = null;
                if (installerConfig != null) {
                    string4 = (String)InstallerConfig.getCurrentInstance().getCompilerVariables().get("sys.shortName");
                }
                if (string4 != null) {
                    string = string + "_" + string4 + "_";
                }
                this.logFile = File.createTempFile(string, ".log");
            }
            Runtime.getRuntime().addShutdownHook(new Thread("delete_log"){

                public void run() {
                    if (!Boolean.getBoolean(Logger.KEEP_LOGFILE_PROP) && string2 == null && Logger.this.logFile != null && !Logger.this.moved) {
                        Logger.this.out.close();
                        Logger.this.logFile.delete();
                    }
                }
            });
            string = System.getProperty(LOG_ENCODING_PROP);
            this.out = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), string)) : new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
        }
        InstallerVariables.registerVariableProvider("sys.logFile", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                try {
                    return Logger.this.logFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return Logger.this.logFile.getAbsolutePath();
                }
            }

            public void setVariable(Object object) {
            }
        });
        this.info(null, "logger started at " + new Date());
        this.info(null, "executable name: " + System.getProperty("exe4j.moduleName"));
        if (installerConfig != null) {
            this.info(null, "install4j version: " + installerConfig.getInstall4jVersion() + " (build " + installerConfig.getInstall4jBuild() + ")");
        }
        this.info(null, "Properties: ");
        System.getProperties().list(this.out);
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void closeLogFile() {
        if (this.previousOut != null) {
            this.previousOut.close();
        } else {
            this.out.close();
        }
    }

    public synchronized void moveLogFile(File file) {
        if (this.logFile != null) {
            this.moved = true;
            this.closeLogFile();
            file.delete();
            if (!Boolean.getBoolean(KEEP_LOGFILE_PROP) && this.logFile.renameTo(file)) {
                this.logFile = file;
            } else {
                try {
                    FileUtil.copyFile(this.logFile, file);
                    if (!Boolean.getBoolean(KEEP_LOGFILE_PROP)) {
                        this.logFile.delete();
                    }
                    this.logFile = file;
                }
                catch (IOException iOException) {
                    System.err.println("could not copy log file: " + iOException.getMessage());
                }
            }
            try {
                this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile.getAbsolutePath(), true)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public void installerEvent(InstallerEvent installerEvent) {
        EventType eventType = installerEvent.getType();
        if (LOGGED_EVENT_TYPES.contains(eventType) || !installerEvent.wasSuccessful() && LOGGED_EVENT_TYPES_FAILURE_ONLY.contains(eventType)) {
            this.log(installerEvent.getSource(), installerEvent.getVerbose(), installerEvent.wasSuccessful());
        }
        if (eventType == EventType.BEFORE_EXECUTE_ACTION) {
            this.logActionProperties(installerEvent.getSource());
        }
    }

    public void switchToSecondaryProcess() {
        System.getProperties().remove(ALTERNATIVE_LOGFILE);
    }

    public synchronized void log(Throwable throwable) {
        this.error(null, throwable.toString());
        this.out.print(Util.getAnnotatedStackTrace(throwable));
        this.out.flush();
        if (Boolean.getBoolean(LOGTOSTDERR_FILE_PROP)) {
            throwable.printStackTrace();
        }
    }

    public synchronized void log(Object object, String string, boolean bl) {
        boolean bl2;
        if (object instanceof Context) {
            object = null;
        }
        if (object == null && this.currentAction != null) {
            object = this.currentAction;
        }
        if (object == null && this.currentScreen != null) {
            object = this.currentScreen;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getPrefix(bl);
        boolean bl3 = bl2 = this.lastSource != null && object != null && this.lastSource.get() == object && string2.equals(this.lastPrefix);
        if (bl2) {
            stringBuffer.append(StringUtil.repeat(" ", string2.length()));
        } else {
            stringBuffer.append(string2);
            if (object != null) {
                String string3;
                if (object instanceof Class) {
                    stringBuffer.append(((Class)object).getName());
                } else {
                    stringBuffer.append(object.getClass().getName());
                }
                if (object instanceof Bean && (string3 = AbstractBeanConfig.getId((Bean)object)) != null) {
                    stringBuffer.append(" [ID ");
                    stringBuffer.append(string3);
                    stringBuffer.append("]");
                }
                stringBuffer.append(": ");
            }
            this.lastSource = new WeakReference<Object>(object);
            this.lastPrefix = string2;
        }
        stringBuffer.append(string);
        this.out.println(stringBuffer.toString());
        this.out.flush();
        if (Boolean.getBoolean(LOGTOSTDERR_FILE_PROP)) {
            System.err.println(stringBuffer.toString());
        }
    }

    private String getPrefix(boolean bl) {
        if (bl) {
            return "[INFO] ";
        }
        return "[ERROR] ";
    }

    public void error(Object object, String string) {
        this.log(object, string, false);
    }

    public void info(Object object, String string) {
        this.log(object, string, true);
    }

    private void logActionProperties(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (method.getParameterTypes().length != 0 || string.equals("getClass") || (!string.startsWith("get") || string.length() <= 3) && (!string.startsWith("is") || string.length() <= 2)) continue;
            try {
                this.logProperty(object, string, method.invoke(object, null));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void logProperty(Object object, String string, Object object2) {
        String string2 = string.startsWith("get") ? string.substring(3, 4).toLowerCase() + string.substring(4) : string.substring(2, 3).toLowerCase() + string.substring(3);
        if (object instanceof PropertyLoggingInterceptor) {
            object2 = ((PropertyLoggingInterceptor)object).getLogValueForProperty(string2, object2);
        }
        this.info(object, "Property " + string2 + ": " + VersionSpecificHelper.toStringWithArrays(object2));
    }

    public void switchToString() {
        this.previousOut = this.out;
        this.stringWriter = new StringWriter();
        this.out = new PrintWriter(this.stringWriter);
    }

    public String switchBackFromString() {
        this.out.flush();
        String string = this.stringWriter.toString();
        this.stringWriter = null;
        this.out = this.previousOut;
        this.previousOut = null;
        return string;
    }

    public void logString(String string) {
        this.out.print(string);
        this.out.flush();
    }

    public String getContent() {
        try {
            String string = System.getProperty(LOG_ENCODING_PROP);
            BufferedReader bufferedReader = string != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.logFile), string)) : new BufferedReader(new InputStreamReader(new FileInputStream(this.logFile)));
            StringBuffer stringBuffer = new StringBuffer();
            int n = ((Reader)bufferedReader).read();
            while (n > -1) {
                stringBuffer.append((char)n);
                n = ((Reader)bufferedReader).read();
            }
            ((Reader)bufferedReader).close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addUnelevatedLog() {
        ProcessCommunication.getInstance().sendAction(new GetUnelevatedLogAction());
    }

    public void resetOrigin() {
        this.lastSource = null;
        this.lastPrefix = null;
    }

    public void setCurrentScreen(Screen screen) {
        this.currentScreen = screen;
    }

    public void setCurrentAction(Action action) {
        this.currentAction = action;
    }

    private static class GetUnelevatedLogAction
    implements CommunicationAction {
        private GetUnelevatedLogAction() {
        }

        public Response execute(ProcessCommunication processCommunication) {
            Logger logger = Logger.getInstance();
            logger.closeLogFile();
            String string = logger.getContent();
            logger.getLogFile().delete();
            return new Response(true, string);
        }
    }
}

