/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.launcher.ApplicationLauncher;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinEnvVars;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScriptClassOrigin;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import com.install4j.runtime.util.StringUtil;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class InstallerUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String CLASS_NAME_PREFIX = "I4jScript_Internal_";
    public static final Pattern CLASS_NAME_PATTERN = Pattern.compile("(I4jScript_Internal_\\d+)\\.java");
    public static final boolean DEBUG = Boolean.getBoolean("install4j.debug");
    public static final String REGKEY_EXE4J = "SOFTWARE\\ej-technologies\\exe4j\\";
    public static final String REGVAL_SETTING_LAF = "SettingLaf";
    public static final String INSTALL4J_ARGUMENTS = "INSTALL4J_ARGUMENTS";
    private static final String REGVAL_INSTALL_STARTED = "InstallStarted";
    private static boolean unattended = false;
    private static boolean console = false;
    private static boolean deployLibsLodaded = false;
    private static String[] commandLineParameters;
    private static boolean inProcess;
    private static ApplicationLauncher.Callback inProcessCallback;
    private static boolean shutdownOnInProcessExit;
    private static final java.util.logging.Logger PREFS_LOGGER;

    public static boolean isInProcess() {
        return inProcess;
    }

    public static void setInProcess(boolean bl) {
        inProcess = bl;
    }

    public static void setShutdownOnInProcessExit(boolean bl) {
        shutdownOnInProcessExit = bl;
    }

    public static void setInProcessCallback(ApplicationLauncher.Callback callback) {
        inProcessCallback = callback;
    }

    public static void exit(int n) {
        if (!inProcess) {
            System.exit(n);
        } else {
            ContextImpl.clearContext();
            InstallerConfig.clearCurrentApplication();
            FileInstaller.clearFileInstaller();
            AbstractBeanConfig.clearBeans();
            if (shutdownOnInProcessExit && n == 0) {
                if (inProcessCallback != null) {
                    inProcessCallback.prepareShutdown();
                }
                System.exit(0);
            } else if (inProcessCallback != null) {
                inProcessCallback.exited(n);
                inProcessCallback = null;
            }
        }
    }

    public static boolean isUnattended() {
        return unattended;
    }

    public static void setUnattended(boolean bl) {
        unattended = bl;
    }

    public static boolean isConsole() {
        return console;
    }

    public static void setConsole(boolean bl) {
        console = bl;
    }

    public static boolean isSolaris() {
        return OS_NAME.equals("SunOS");
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isWindowsXP() {
        return OS_NAME.toLowerCase().startsWith("windows xp");
    }

    public static boolean isWindows2000() {
        return OS_NAME.toLowerCase().startsWith("windows 2000");
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isWindowsMe() {
        return OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindows9X() {
        return OS_NAME.startsWith("Windows 98") || OS_NAME.startsWith("Windows 95") || OS_NAME.startsWith("Windows Me") || OS_NAME.startsWith("Windows (unknown)");
    }

    public static boolean isWindowsNT() {
        return (OS_NAME.toLowerCase().startsWith("windows nt") || OS_NAME.toLowerCase().startsWith("windowsnt")) && !OS_VERSION.startsWith("6");
    }

    public static boolean isAtLeastWindows2000() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 5.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAtLeastWindowsXP() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 5.1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAtLeastWindowsVista() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 6.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAtLeastWindows7() {
        try {
            return InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && Double.parseDouble(OS_VERSION.substring(0, 3)) >= 6.1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindowsVista() {
        return OS_NAME.toLowerCase().startsWith("windows vista") || OS_NAME.toLowerCase().startsWith("windows nt") && OS_VERSION.startsWith("6.0");
    }

    public static boolean isWindows7() {
        return OS_NAME.toLowerCase().startsWith("windows 7") || OS_NAME.toLowerCase().startsWith("windows vista") && OS_VERSION.startsWith("6.1");
    }

    public static boolean isWindows2003() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2003") > -1;
    }

    public static boolean isWindows2008() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2008") > -1;
    }

    public static boolean isHpux() {
        return OS_NAME.equals("HP-UX");
    }

    public static boolean isAix() {
        return OS_NAME.equals("AIX");
    }

    public static boolean isUpToJava15() {
        String string = System.getProperty("java.version");
        return string.startsWith("1.2") || string.startsWith("1.3") || string.startsWith("1.4") || string.startsWith("1.5");
    }

    public static String getStandardApplicationsDirectory() {
        if (InstallerUtil.isWindows()) {
            return FolderInfo.getProgramFilesDirectory().getAbsolutePath();
        }
        if (InstallerUtil.isMacOS()) {
            return "/Applications";
        }
        File file = new File("/opt");
        String[] stringArray = file.list();
        String string = file.exists() && stringArray != null && stringArray.length > 0 ? "/opt" : "/usr/local";
        File file2 = new File(string);
        if (file2.exists() && file2.canWrite()) {
            return string;
        }
        return System.getProperty("user.home");
    }

    public static File getInstallerFile(String string) {
        File file;
        String string2 = InstallerConfig.getCurrentApplicationId();
        if ((string2 == null || string2.equals("installer")) && (file = new File(string).getAbsoluteFile()).exists()) {
            return file;
        }
        file = new File(ResourceHelper.getRuntimeDir(), string);
        if (file.exists() || !Util.isMacOS()) {
            return file;
        }
        return new File(string).getAbsoluteFile();
    }

    public static synchronized void loadJREDeployLibs() {
        if (deployLibsLodaded) {
            return;
        }
        if (InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && !InstallerUtil.isWindowsNT()) {
            File file;
            File file2;
            File file3;
            String string = System.getProperty("java.home");
            File file4 = new File(string, "lib");
            File file5 = new File(file4, "deploy.jar");
            if (file5.exists()) {
                ClasspathModificator.addClassPath(file5);
            }
            if ((file3 = new File(file4, "plugin.jar")).exists()) {
                ClasspathModificator.addClassPath(file3);
            }
            if ((file2 = new File(file = new File(string, "bin"), "deploy.dll")).exists()) {
                try {
                    System.load(file2.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            deployLibsLodaded = true;
        }
    }

    public static ExecutionMode getExecutionMode(CommandLineOptions commandLineOptions, boolean bl) {
        Application application = InstallerConfig.getCurrentApplication();
        ExecutionMode executionMode = application.getExecutionMode();
        String string = System.getProperty("install4j.executionMode");
        if ("gui".equals(string)) {
            executionMode = ExecutionMode.GUI;
        } else if ("console".equals(string)) {
            executionMode = ExecutionMode.CONSOLE;
        } else if ("unattended".equals(string)) {
            executionMode = ExecutionMode.UNATTENDED;
        }
        if (commandLineOptions.quiet && (application.isAllowUnattended() || bl)) {
            executionMode = ExecutionMode.UNATTENDED;
        } else if (commandLineOptions.console && application.isAllowConsole()) {
            executionMode = ExecutionMode.CONSOLE;
        } else if (commandLineOptions.gui) {
            executionMode = ExecutionMode.GUI;
        }
        if (executionMode == ExecutionMode.GUI && Util.isUnixInstaller() && application.isAllowConsole() && application.isUnixFallbackToConsole()) {
            try {
                new Frame();
            }
            catch (Throwable throwable) {
                executionMode = ExecutionMode.CONSOLE;
            }
        }
        return executionMode;
    }

    public static String getSupportedSystemLanguageId() {
        Logger logger = Logger.getInstance();
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        logger.info(null, "System language '" + string + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
            return string;
        }
        string = string + "_" + locale.getCountry();
        logger.info(null, "System locale '" + string + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
            return string;
        }
        logger.info(null, "System locale not found in available languages");
        return null;
    }

    public static String insertBeanNames(String string, Map map) {
        Matcher matcher = CLASS_NAME_PATTERN.matcher("");
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            InstallerUtil.addBeanNameToBuffer(string2, map, stringBuffer, matcher);
            stringBuffer.append(string2);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public static boolean addBeanNameToBuffer(String string, Map map, StringBuffer stringBuffer, Matcher matcher) {
        String string2;
        ScriptClassOrigin scriptClassOrigin;
        matcher.reset(string);
        if (matcher.find() && (scriptClassOrigin = (ScriptClassOrigin)map.get(string2 = matcher.group(1))) != null) {
            stringBuffer.append("In ");
            stringBuffer.append(scriptClassOrigin.getBeanType());
            stringBuffer.append(" \"");
            stringBuffer.append(scriptClassOrigin.getBeanName());
            stringBuffer.append("\"");
            if (scriptClassOrigin.getParentScreen().length() > 0) {
                stringBuffer.append(" (screen \"");
                stringBuffer.append(scriptClassOrigin.getParentScreen());
                stringBuffer.append("\")");
            }
            stringBuffer.append(", property \"");
            stringBuffer.append(scriptClassOrigin.getPropertyName());
            stringBuffer.append("\":\n");
            return true;
        }
        return false;
    }

    public static String prependBeanOrigin(String string, Map map) {
        String string2;
        Matcher matcher = CLASS_NAME_PATTERN.matcher("");
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length && !InstallerUtil.addBeanNameToBuffer(string2 = stringArray[i], map, stringBuffer, matcher); ++i) {
        }
        return stringBuffer.toString() + string;
    }

    public static void disablePreferencesLogging() {
        try {
            PREFS_LOGGER.setUseParentHandlers(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean is64BitWindows() {
        return InstallerUtil.is64BitWindowsArch(WinEnvVars.getenv("PROCESSOR_ARCHITECTURE")) || InstallerUtil.is64BitWindowsArch(WinEnvVars.getenv("PROCESSOR_ARCHITEW6432"));
    }

    private static boolean is64BitWindowsArch(String string) {
        return string != null && (string.equalsIgnoreCase("AMD64") || string.equalsIgnoreCase("IA64"));
    }

    public static String[] getCommandLineParameters() {
        return commandLineParameters;
    }

    public static String getSplash(CommandLineOptions commandLineOptions, ExecutionMode executionMode) {
        String string = commandLineOptions.splash;
        if (executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS && string == null) {
            string = InstallerConfig.getCurrentApplication().getSplashMessage();
        }
        return string;
    }

    public static CommandLineOptions parseCommandLine(String[] stringArray) {
        Object object;
        Object object2;
        commandLineParameters = stringArray;
        String string = (String)VersionSpecificHelper.getenv().get(INSTALL4J_ARGUMENTS);
        if (string != null) {
            object2 = new ArrayList();
            StringUtil.splitupQuotedList((List)object2, string, " ");
            stringArray = object2.toArray(new String[object2.size()]);
        }
        object2 = new CommandLineOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            object = stringArray[i];
            if (((String)object).equals("-q") && !((CommandLineOptions)object2).console && !((CommandLineOptions)object2).gui) {
                ((CommandLineOptions)object2).quiet = true;
                continue;
            }
            if (((String)object).equals("-c") && !((CommandLineOptions)object2).quiet && !((CommandLineOptions)object2).gui) {
                ((CommandLineOptions)object2).console = true;
                continue;
            }
            if (((String)object).equals("-g") && !((CommandLineOptions)object2).console && !((CommandLineOptions)object2).quiet) {
                ((CommandLineOptions)object2).gui = true;
                continue;
            }
            if (((String)object).equals("-overwrite")) {
                ((CommandLineOptions)object2).quietOverwrite = true;
                continue;
            }
            if (((String)object).equals("-h") || ((String)object).equals("-help") || ((String)object).equals("/?")) {
                ((CommandLineOptions)object2).help = true;
                continue;
            }
            if (((String)object).equals("-dir") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).installDir = new File(stringArray[++i]);
                continue;
            }
            if (((String)object).equals("-wait") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).wait = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (((String)object).equals("-varfile") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).varFileName = stringArray[++i];
                continue;
            }
            if (((String)object).equals("-splash") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object2).splash = stringArray[++i];
                continue;
            }
            boolean bl = ((String)object).startsWith("-D");
            boolean bl2 = ((String)object).startsWith("-V");
            if (!bl && !bl2 || (n = ((String)object).indexOf(61)) <= -1 || ((String)object).length() <= n + 1) continue;
            String string2 = ((String)object).substring(2, n);
            String string3 = ((String)object).substring(n + 1);
            if (bl) {
                System.setProperty(string2, string3);
                continue;
            }
            ((CommandLineOptions)object2).commandLineVars.setProperty(string2, string3);
        }
        if (((CommandLineOptions)object2).help) {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            object = InstallerConfig.getCurrentApplication();
            Messages.setLanguageConfig((LanguageConfig)InstallerConfig.getCurrentInstance().getLanguages().get(0));
            ResourceBundle resourceBundle = Messages.getMessages();
            arrayList.add(new String[]{"-varfile [file]", resourceBundle.getString("HelpResponseFile")});
            if (((Application)object).isAllowConsole()) {
                arrayList.add(new String[]{"-c", resourceBundle.getString("HelpConsoleMode")});
            }
            if (((Application)object).isAllowUnattended()) {
                arrayList.add(new String[]{"-q", resourceBundle.getString("HelpUnattendedMode")});
                if (object instanceof InstallerApplication) {
                    arrayList.add(new String[]{"-dir [directory]", resourceBundle.getString("HelpUnattendedDir")});
                    arrayList.add(new String[]{"-overwrite", resourceBundle.getString("HelpUnattendedOverwrite")});
                }
                arrayList.add(new String[]{"-splash [title]", resourceBundle.getString("HelpUnattendedSplash")});
                if (InstallerUtil.isWindows()) {
                    arrayList.add(new String[]{"-console", resourceBundle.getString("HelpUnattendedConsole")});
                }
            }
            if (InstallerUtil.isWindows()) {
                arrayList.add(new String[]{"-manual", resourceBundle.getString("HelpManual")});
            }
            if (((Application)object).getExecutionMode() != ExecutionMode.GUI) {
                arrayList.add(new String[]{"-g", resourceBundle.getString("HelpGuiMode")});
            }
            arrayList.add(new String[]{"-Dname=value", resourceBundle.getString("HelpSystemProperties")});
            arrayList.add(new String[]{"-h", resourceBundle.getString("HelpHelp")});
            InstallerUtil.showHelp(resourceBundle.getString("HelpHeaderLabel"), arrayList);
            InstallerUtil.exit(1);
        }
        return object2;
    }

    private static void showHelp(String string, List list) {
        try {
            InstallerUtil.showGuiHelp(string, list);
        }
        catch (Throwable throwable) {
            InstallerUtil.showConsoleHelp(string, list);
        }
    }

    private static void showGuiHelp(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(string);
        stringBuffer.append("<br><br><table border=0 cellspacing=0>");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            stringBuffer.append("<tr><td><b>");
            stringBuffer.append(stringArray[0]);
            stringBuffer.append("</b></td><td>&nbsp;</td><td>");
            stringBuffer.append(stringArray[1]);
            stringBuffer.append("</tr>");
        }
        stringBuffer.append("</table>");
        GUIHelper.showMessage(null, stringBuffer.toString(), 1);
    }

    private static void showConsoleHelp(String string, List list) {
        String[] stringArray;
        ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
        consoleImpl.println(string);
        consoleImpl.println();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            n = Math.max(stringArray[0].length(), n);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            consoleImpl.print(stringArray[0]);
            consoleImpl.print(StringUtil.repeat(" ", n + 1 - stringArray[0].length()));
            consoleImpl.println(stringArray[1]);
        }
    }

    private static List getAddOnApplicationConfigsFromRuntimeDir(File file) {
        ArrayList<InstallerConfig> arrayList = new ArrayList<InstallerConfig>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().startsWith("i4jparams.conf.")) continue;
                try {
                    arrayList.add(InstallerConfig.getGeneralConfigFromFile(file2));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    public static List getAddOnApplicationConfigs(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(file2.getParentFile());
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacOS() && (file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(file2.getParentFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static InstallerConfig getOldApplicationConfig(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(file2);
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacosInstaller()) {
                file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf");
                if (file2.exists()) {
                    try {
                        return InstallerConfig.getGeneralConfigFromFile(file2);
                    }
                    catch (Exception exception) {
                    }
                } else {
                    String string = InstallerConfig.getCurrentInstance().getMacSpecificConfig().getSingleBundleName();
                    if (string != null && string.trim().length() > 0 && (file2 = new File(new File(file, string), "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                        try {
                            return InstallerConfig.getGeneralConfigFromFile(file2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return null;
    }

    public static String getOldApplicationId(File file) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(file);
        if (installerConfig != null) {
            if (installerConfig.getApplicationId().indexOf("${") > -1) {
                return null;
            }
            return installerConfig.getApplicationId();
        }
        return null;
    }

    public static boolean checkWritable(File file, Component component, boolean bl) {
        Serializable serializable;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file; serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file2 = (File)arrayList.get(i);
            if (!file2.mkdir()) continue;
            serializable.add(file2);
        }
        File file3 = new File(file, "i4j_writeperm_test");
        file3.delete();
        boolean bl2 = file3.mkdir();
        file3.delete();
        for (int i = serializable.size() - 1; i >= 0; --i) {
            File file4 = (File)serializable.get(i);
            file4.delete();
        }
        if (!bl2 && bl) {
            GUIHelper.showMessage(component, MessageFormat.format(Messages.getMessages().getString("NoWritePermissions2"), file), 2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadFile(File file, String string) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        try {
            if (!file.getName().toLowerCase().endsWith(".zip")) return InstallerUtil.readString(new FileInputStream(file));
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry zipEntry;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return null;
                } while (!(zipEntry = enumeration.nextElement()).getName().startsWith(string + "."));
                String string2 = InstallerUtil.readString(zipFile.getInputStream(zipEntry));
                return string2;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String readString(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringWriter stringWriter = new StringWriter();
        while ((n = inputStreamReader.read()) != -1) {
            stringWriter.write(n);
        }
        inputStreamReader.close();
        return stringWriter.toString();
    }

    public static String sanitizeHTML(String string) {
        boolean bl;
        String string2 = string.toLowerCase();
        boolean bl2 = bl = string2.indexOf("<html>") > -1;
        if (bl) {
            int n = string2.indexOf("<head>");
            int n2 = string2.indexOf("</head>");
            if (n > -1 && n2 > n) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(string.substring(n + 6, n2));
                stringBuffer.append(string.substring(n2 + 7));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String cleanupName(String string) {
        if (string.endsWith("//") || string.endsWith("\\\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void reportException(Throwable throwable) {
        Logger.getInstance().log(throwable);
        if (DEBUG) {
            System.err.println(Util.getAnnotatedStackTrace(throwable));
        } else {
            Object object;
            Object object2;
            Object object3;
            File file = null;
            try {
                file = File.createTempFile("install4jError", ".log");
                object3 = new PrintWriter(new FileOutputStream(file));
                ((PrintWriter)object3).println("Exception:");
                ((PrintWriter)object3).println();
                ((PrintWriter)object3).print(Util.getAnnotatedStackTrace(throwable));
                ((PrintWriter)object3).println();
                ((PrintWriter)object3).println("System properties:");
                ((PrintWriter)object3).println();
                object2 = System.getProperties().entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    ((PrintWriter)object3).print(object.getKey());
                    ((PrintWriter)object3).print("=");
                    ((PrintWriter)object3).println(object.getValue());
                }
                ((PrintWriter)object3).flush();
                ((PrintWriter)object3).close();
                file = InstallerUtil.copyTempFile(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file != null) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object3 = "An error occurred:\n" + throwable + "\nError log: " + (file == null ? "" : file.getPath());
            object2 = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)object2, true));
            object = ((StringWriter)object2).toString();
            if (unattended) {
                System.err.println((String)object3);
                throwable.printStackTrace();
            } else if (console) {
                ConsoleImpl.getInstance().println(object3);
                ConsoleImpl.getInstance().printStackTrace(throwable);
            } else if (((String)object).indexOf("X11") > 0) {
                if (Boolean.getBoolean("install4j.printX11Exception")) {
                    throwable.printStackTrace();
                }
                InstallerUtil.displayXMessage();
            } else {
                try {
                    if (file == null) {
                        JOptionPane.showMessageDialog(null, object3, "install4j", 0);
                    } else {
                        int n = JOptionPane.showOptionDialog(null, object3, "install4j", -1, 0, null, new String[]{"OK", "Show Log File"}, null);
                        if (n == 1) {
                            GUIHelper.showURL(file.toURI().toString());
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (Util.isWindowsInstaller() || Boolean.getBoolean("install4j.suppressX11Message")) {
                        System.err.println((String)object3);
                        throwable.printStackTrace();
                    }
                    InstallerUtil.displayXMessage();
                }
            }
        }
    }

    private static File copyTempFile(File file) throws IOException {
        try {
            String string = (String)InstallerVariables.getVariable("sys.mediaDir");
            if (string != null) {
                File file2 = new File(string, file.getName());
                FileUtil.copyFile(file, file2);
                file = file2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static boolean isAtLeastJava15() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    public static boolean isAtLeastJava16() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.5") && !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    private static void displayXMessage() {
        System.err.println("Could not display the GUI. This application needs access to an X Server.");
        if (InstallerConfig.getCurrentApplication().isAllowConsole()) {
            System.err.println("*******************************************************************");
            System.err.println("You can also run this application in console mode without");
            System.err.println("access to an X server by passing the argument -c");
            System.err.println("*******************************************************************");
        } else if (InstallerConfig.getCurrentApplication().isAllowUnattended()) {
            System.err.println("*******************************************************************");
            System.err.println("You can also run this application in unattended mode without");
            System.err.println("access to an X server by passing the argument -q");
            System.err.println("*******************************************************************");
        }
    }

    public static void registerStarted(boolean bl) {
        if (InstallerUtil.isWindows()) {
            String string = "InstallStarted_" + Win32CommunicationBackend.getCurrentProcessId();
            if (WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, string) != null) {
                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, string, new Integer(bl ? 2 : 0));
            }
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, REGKEY_EXE4J, REGVAL_INSTALL_STARTED, new Integer(bl ? 2 : 0));
        }
    }

    public static boolean checkJavaVersion() {
        if (InstallerUtil.isMacOS()) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = installerConfig.getMinJavaVersion();
            if (string.trim().equals("")) {
                return true;
            }
            if (System.getProperty("java.version").compareTo(string) >= 0) {
                return true;
            }
            String string2 = MessageFormat.format(Messages.getMessages().getString("AppleJavaMinVersionError"), installerConfig.getMinJavaVersion(), installerConfig.getApplicationName());
            GUIHelper.showMessage(null, string2, 0);
            return false;
        }
        return true;
    }

    public static String getVerboseVariableDefinition(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(VersionSpecificHelper.toStringWithArrays(object));
        if (object != null) {
            stringBuffer.append("[");
            stringBuffer.append(object.getClass());
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public static String getAnnotatedStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            return stringWriter.toString();
        }
        return InstallerUtil.prependBeanOrigin(stringWriter.toString(), installerConfig.getClassNameToScriptClassOrigin());
    }

    static {
        inProcess = true;
        PREFS_LOGGER = java.util.logging.Logger.getLogger("java.util.prefs");
    }

    public static class CommandLineOptions {
        public boolean help = false;
        public boolean quiet = false;
        public boolean console = false;
        public boolean gui = false;
        public File installDir = null;
        public boolean quietOverwrite = false;
        public int wait = 0;
        public String splash = null;
        public Properties commandLineVars = new Properties();
        public String varFileName;
    }
}

