/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class InstallationProperties {
    private static final String INSTALLATION_PROP_FILE_NAME = "install.prop";
    public static final String PROP_NAME_LAUNCHER = "launcher";
    public static final String PROP_NAME_SERVICE = "service";
    public static final String PROP_NAME_SERVICE_NAME = "serviceName";
    private static final String PROP_LANGUAGE_ID = "languageId";
    private Properties props = new Properties();

    public InstallationProperties(File file) {
        File file2 = new File(file, INSTALLATION_PROP_FILE_NAME);
        if (file2.exists()) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                this.props.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public List getPropertyList(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((string2 = this.props.getProperty(string + n++)) != null) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Set getCanonicalFilePropertySet(String string) throws IOException {
        HashSet<File> hashSet = new HashSet<File>();
        List list = this.getPropertyList(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashSet.add(new File(string2).getCanonicalFile());
        }
        return hashSet;
    }

    public void store(File file) throws IOException {
        File file2 = new File(file, INSTALLATION_PROP_FILE_NAME);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        this.props.store(bufferedOutputStream, "");
        ((OutputStream)bufferedOutputStream).close();
        FileInstaller.getInstance().registerUninstallFile(file2);
    }

    public void addFileToSet(String string, File file) throws IOException {
        File file2;
        Set set = this.getCanonicalFilePropertySet(string);
        if (!set.contains(file2 = file.getCanonicalFile())) {
            this.addToList(string, file2.getAbsolutePath());
        }
    }

    public void addStringToSet(String string, String string2) throws IOException {
        List list = this.getPropertyList(string);
        if (!list.contains(string2)) {
            this.addToList(string, string2);
        }
    }

    private void addToList(String string, String string2) {
        int n = -1;
        while (this.props.getProperty(string + ++n) != null) {
        }
        this.props.setProperty(string + n, string2);
    }

    public void setLanguageId(String string) {
        this.props.setProperty(PROP_LANGUAGE_ID, string);
    }

    public String getLanguageId() {
        return this.props.getProperty(PROP_LANGUAGE_ID);
    }
}

