/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.ConsoleAccess;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ConsoleImpl
implements Console {
    private static ConsoleImpl instance;
    private static final int HORIZONTAL_SIZE = 75;
    private static final int VERTICAL_SIZE = 25;
    private String lastStatusMessage;
    private ConsoleAccess consoleAccess = VersionSpecificHelper.getConsoleAccess();

    public static ConsoleImpl getInstance() {
        if (instance == null) {
            instance = new ConsoleImpl();
        }
        return instance;
    }

    public void waitForEnter() throws UserCanceledException {
        this.println("[" + this.getMessages().getString("ConsoleEnter") + "]");
        this.readLine();
    }

    public void printHeader(String string) {
        Application application = InstallerConfig.getCurrentApplication();
        try {
            ContextImpl.getSingleContextImpl().runScript(application.getConsoleScreenChangeHandler(), application, new Object[]{this, string});
        }
        catch (Exception exception) {
            Util.printAnnotatedStackTrace(exception);
            Logger.getInstance().log(exception);
        }
    }

    public void println() {
        this.println("");
    }

    public void more(String string) throws UserCanceledException {
        if (string == null) {
            this.consoleAccess.println("null");
            this.consoleAccess.flush();
            return;
        }
        int n = 0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && string2.charAt(0) == '\n') {
                this.consoleAccess.println();
                bl = true;
                if (++n % 23 != 0) continue;
                this.waitForEnter();
                continue;
            }
            if (string2.length() <= 1 && string2.charAt(0) == '\r') continue;
            bl = false;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            int n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                if (n2 == 0 || n2 + string3.length() <= 75) {
                    if (n2 > 0) {
                        this.consoleAccess.print(" ");
                        ++n2;
                    }
                } else {
                    this.consoleAccess.println();
                    n2 = 0;
                    if (++n % 23 == 0) {
                        this.waitForEnter();
                    }
                }
                this.consoleAccess.print(string3);
                n2 += string3.length();
            }
        }
        if (!bl) {
            this.consoleAccess.println();
        }
    }

    public void print(Object object) {
        if (object == null) {
            this.consoleAccess.print("null");
        } else {
            this.consoleAccess.print(object.toString());
        }
        this.consoleAccess.flush();
    }

    public void println(Object object) {
        if (object == null) {
            this.consoleAccess.println("null");
        } else {
            this.consoleAccess.println(object.toString());
        }
        this.consoleAccess.flush();
    }

    public String askWithDefault(String string, String string2) throws UserCanceledException {
        this.println(string);
        this.println("[" + string2 + "]");
        String string3 = this.readLine();
        if (string3.trim().length() == 0) {
            return string2;
        }
        return string3;
    }

    public boolean askYesNo(String string) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo")}, new String[]{"y", "n"}) == 0;
    }

    public boolean askYesNo(String string, boolean bl) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo")}, new String[]{"y", "n"}, bl ? 0 : 1) == 0;
    }

    public boolean askOkCancel(String string) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"o", "c"}) == 0;
    }

    public boolean askOkCancel(String string, boolean bl) throws UserCanceledException {
        return this.askOption(string, new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"o", "c"}, bl ? 0 : 1) == 0;
    }

    public String askString(String string, String string2) throws UserCanceledException {
        String string3;
        if (string != null && string.length() != 0) {
            this.println(string);
        }
        if (string2 != null) {
            this.println("[" + string2 + "]");
        }
        if ((string3 = this.readLine()).trim().length() == 0 && string2 != null) {
            return string2;
        }
        return string3;
    }

    public String askPassword(String string, String string2) throws UserCanceledException {
        String string3;
        if (string != null && string.length() != 0) {
            this.println(string);
        }
        if ((string3 = this.consoleAccess.readPassword("")).trim().length() == 0 && string2 != null) {
            return string2;
        }
        return string3;
    }

    public int askOption(String string, String[] stringArray, String[] stringArray2) throws UserCanceledException {
        return this.askOption(string, stringArray, stringArray2, -1);
    }

    public int askOption(String string, String[] stringArray, String[] stringArray2, int n) throws UserCanceledException {
        return this.askOption(string, stringArray, stringArray2, n, false, false);
    }

    public int askOption(String string, String[] stringArray, String[] stringArray2, int n, boolean bl, boolean bl2) throws UserCanceledException {
        if (stringArray2 == null) {
            stringArray2 = this.getDefaultKeys(stringArray.length);
        }
        String string2 = this.getQuestion(stringArray, stringArray2, n, bl2);
        while (true) {
            if (string != null && string.length() != 0) {
                this.println(string);
            }
            this.println(string2);
            String string3 = this.readLine();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray2[i].equals(string3)) continue;
                return i;
            }
            if (string3.trim().length() != 0) continue;
            if (n > -1) {
                return n;
            }
            if (bl) break;
        }
        return -1;
    }

    private String getQuestion(String[] stringArray, String[] stringArray2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" [");
            if (stringArray2[i].equals("")) {
                stringBuffer.append(this.getMessages().getString("ConsoleEnter"));
            } else {
                stringBuffer.append(stringArray2[i]);
                if (n == i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(this.getMessages().getString("ConsoleEnter"));
                }
            }
            stringBuffer.append("]");
            if (i >= stringArray.length - 1) continue;
            if (bl) {
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public int[] askMultipleSelection(String string, String[] stringArray, String[] stringArray2, int[] nArray, boolean bl) throws UserCanceledException {
        Object object;
        HashSet<Integer> hashSet;
        boolean bl2;
        if (stringArray2 == null) {
            stringArray2 = this.getDefaultKeys(stringArray.length);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(stringArray2[nArray[i]]);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(",");
        }
        String string2 = this.getQuestion(stringArray, stringArray2, -1, bl);
        string2 = string2 + "\n" + this.getMessages().getString("ConsoleMultipleSelectionLabel");
        block1: do {
            if (string != null && string.length() != 0) {
                this.println(string);
            }
            String string3 = this.askString(string2, stringBuffer.toString());
            bl2 = true;
            hashSet = new HashSet<Integer>();
            object = new StringTokenizer(string3, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken().trim();
                boolean bl3 = false;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals(string4)) continue;
                    hashSet.add(new Integer(i));
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                bl2 = false;
                continue block1;
            }
        } while (!bl2);
        object = new int[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object[n++] = (Integer)iterator.next();
        }
        return object;
    }

    private String[] getDefaultKeys(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        return stringArray;
    }

    public void setStatusMessage(String string) {
        if (string != null && !string.trim().equals("") && !string.equals(this.lastStatusMessage)) {
            this.println(string);
            this.lastStatusMessage = string;
        }
    }

    public void setDetailMessage(String string) {
        if (string != null && !string.trim().equals("")) {
            this.println("   " + string);
        }
    }

    public void setPercentCompleted(int n) {
    }

    public int getPercentCompleted() {
        return 0;
    }

    public void setIndeterminateProgress(boolean bl) {
    }

    public void showFailure(String string) {
        this.println("ERROR: " + string);
    }

    public int askOverwrite(File file) throws UserCanceledException {
        String string = file.getPath() + "\n" + this.getMessages().getString("FileExists");
        int n = this.askOption(string, new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonYesToAll"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonNoToAll")}, new String[]{"y", "ya", "n", "na"});
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public int askRetry(File file) throws UserCanceledException {
        int n = this.askOption(MessageFormat.format(this.getMessages().getString("AskRetryInstallFile"), file.getPath()), new String[]{this.getMessages().getString("ButtonYes"), this.getMessages().getString("ButtonNo"), this.getMessages().getString("ButtonCancel")}, new String[]{"y", "n", "c"});
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 3;
    }

    public boolean askContinue(File file) throws UserCanceledException {
        int n = this.askOption(MessageFormat.format(this.getMessages().getString("AskContinue"), file.getPath()), new String[]{this.getMessages().getString("ButtonOK"), this.getMessages().getString("ButtonCancel")}, new String[]{"", "c"});
        return n == 0;
    }

    protected ResourceBundle getMessages() {
        return Messages.getMessages();
    }

    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.consoleAccess.getWriter());
        this.consoleAccess.flush();
    }

    public synchronized void cancel() {
        this.consoleAccess.cancel();
    }

    public String readLine() throws UserCanceledException {
        return this.consoleAccess.readLine("");
    }
}

