/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;

public class ClasspathModificator {
    private static ClassLoader classLoader;
    private static Method addURLMethod;
    private static boolean customJarsAdded;

    public static void addClassPath(File file) {
        if (addURLMethod == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            addURLMethod = ClasspathModificator.getAddURLMethod();
        }
        try {
            addURLMethod.invoke((Object)classLoader, file.toURL());
            System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + file.getAbsolutePath());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static Method getAddURLMethod() {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public static void addCustomJarsToClasspath(Context context) {
        if (customJarsAdded) {
            return;
        }
        if (InstallerUtil.isInProcess()) {
            ClasspathModificator.addClassPath(new File(ResourceHelper.getRuntimeDir(), "user.jar"));
        }
        List list = InstallerConfig.getCurrentInstance().getCustomJars();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ClasspathModificator.addClassPath(context.getDestinationFile(string));
        }
        customJarsAdded = true;
    }

    static {
        customJarsAdded = false;
    }
}

