/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class ConsoleScreenExecutor
extends AbstractHeadlessScreenExecutor {
    protected ConsoleScreenExecutor() {
        this.init(true);
    }

    public boolean isUnattended() {
        return false;
    }

    public boolean isConsole() {
        return true;
    }

    protected boolean handleScreen(ScreenBeanConfig screenBeanConfig) throws UserCanceledException {
        Object[] objectArray;
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        do {
            ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
            objectArray = null;
            if (screen instanceof FormPanelContainer) {
                FormPanel formPanel = new FormPanel(screenBeanConfig.getFormComponentConfigs(), this.getContext(), false, screen);
                ((FormPanelContainer)((Object)screen)).setFormPanel(formPanel, formPanel.getFormEnvironment());
                objectArray = new Object[]{formPanel.getFormEnvironment()};
            }
            if (screen.isHidden() || screen.isHiddenForNext()) {
                return true;
            }
            this.getContext().runBooleanScript(screenBeanConfig.getPreActivationClassName(), screen, objectArray);
            if (screen.handleConsole(consoleImpl)) continue;
            return false;
        } while (!this.getContext().runBooleanScript(screenBeanConfig.getValidationClassName(), screen, objectArray));
        if (screenBeanConfig.isFinishScreen()) {
            this.getCommandSink().returnToController(new FinishCommand(null));
            return true;
        }
        return true;
    }

    public ProgressInterface getProgressInterface() {
        return ConsoleImpl.getInstance();
    }

    public void selectLanguage(ReturnToken returnToken) {
        ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
        ResourceBundle resourceBundle = Messages.createMessages((LanguageConfig)InstallerConfig.getCurrentInstance().getLanguages().get(0));
        consoleImpl.println(resourceBundle.getString("LanguageSelectionLabel"));
        List list = InstallerConfig.getCurrentInstance().getLanguages();
        String string = Locale.getDefault().getLanguage();
        List list2 = Messages.sortLanguages(list, resourceBundle);
        LanguageConfig languageConfig = InstallerConfig.getCurrentInstance().getLanguageById(string);
        int n = -1;
        for (int i = 0; i < list2.size(); ++i) {
            consoleImpl.print(i + 1 + ": " + Messages.getLocalizedLanguageName(list2.get(i), resourceBundle));
            if (list2.get(i) == languageConfig) {
                consoleImpl.print(" [" + resourceBundle.getString("ConsoleEnter") + "]");
                n = i;
            }
            consoleImpl.println();
        }
        while (true) {
            try {
                String string2;
                int n2;
                do {
                    consoleImpl.println("[1 - " + list2.size() + "]");
                    string2 = consoleImpl.readLine();
                    if (string2.trim().length() != 0 || n <= -1) continue;
                    returnToken.returnToController(((LanguageConfig)list2.get(n)).getId());
                    return;
                } while ((n2 = Integer.parseInt(string2)) <= 0 || n2 > list2.size());
                returnToken.returnToController(((LanguageConfig)list2.get(n2 - 1)).getId());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            catch (UserCanceledException userCanceledException) {
                try {
                    Thread.sleep(100000000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
            }
            break;
        }
    }
}

