/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProgramGroupSelector
extends JPanel {
    private static final String BAD_CHARS = "/:*?\"<>|";
    private boolean allUsers;
    private boolean showWarningIfExists;
    private WizardContext wizardContext;
    private JTextField txtGroup;
    private JList lstGroups;
    private JScrollPane scpGroups;

    public static boolean checkProgramGroup(String string, boolean bl, boolean bl2, Window window) throws UserCanceledException {
        int n;
        File file;
        ResourceBundle resourceBundle = Messages.getMessages();
        if (string.length() == 0) {
            GUIHelper.showMessage(window, resourceBundle.getString("MustEnterGroupName"), 2);
            return false;
        }
        char[] cArray = BAD_CHARS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (string.indexOf(cArray[i]) < 0) continue;
            GUIHelper.showMessage(window, MessageFormat.format(resourceBundle.getString("BadGroupName"), BAD_CHARS), 2);
            return false;
        }
        return !bl2 || !(file = new File(FolderInfo.getSpecialFolder(3, bl), string)).exists() || (n = GUIHelper.showOptionDialog(Util.getParentWindow(), resourceBundle.getString("ProgramGroupExists"), new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3)) == 0;
    }

    public ProgramGroupSelector(boolean bl, boolean bl2, WizardContext wizardContext) {
        this.allUsers = bl;
        this.showWarningIfExists = bl2;
        this.wizardContext = wizardContext;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setEnabled(boolean bl) {
        this.txtGroup.setEnabled(bl);
        this.lstGroups.setEnabled(bl);
    }

    public String getSelectedProgramGroup() {
        String string = this.txtGroup.getText().trim();
        while (string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public boolean checkSelectedProgramGroup() {
        try {
            boolean bl = ProgramGroupSelector.checkProgramGroup(this.getSelectedProgramGroup(), this.allUsers, this.showWarningIfExists, (Window)SwingUtilities.getAncestorOfClass(Window.class, this));
            if (!bl) {
                this.txtGroup.requestFocus();
            }
            return bl;
        }
        catch (UserCanceledException userCanceledException) {
            return false;
        }
    }

    public void focusTextField() {
        this.txtGroup.requestFocus();
        this.txtGroup.setSelectionStart(0);
        this.txtGroup.setSelectionEnd(this.txtGroup.getDocument().getLength());
    }

    private void setupControls() {
        this.txtGroup = new JTextField("");
        this.lstGroups = new JList();
        this.lstGroups.setSelectionMode(0);
        this.scpGroups = new JScrollPane(this.lstGroups);
        this.fillGroupList();
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtGroup, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scpGroups, gridBagConstraints);
    }

    private void setupEventHandlers() {
        this.lstGroups.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object e = ProgramGroupSelector.this.lstGroups.getSelectedValue();
                if (e != null) {
                    ProgramGroupSelector.this.txtGroup.setText(e.toString());
                }
            }
        });
        KeyboardUtil.addAccelerator(0, this.txtGroup, this.txtGroup, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgramGroupSelector.this.wizardContext.pressNextButton();
            }
        }, 10, 0);
    }

    private void fillGroupList() {
        File file = FolderInfo.getSpecialFolder(3, this.allUsers);
        if (file == null) {
            return;
        }
        File file2 = FolderInfo.getSpecialFolder(4, this.allUsers);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        try {
            File[] fileArray;
            if (file2 != null) {
                file2 = file2.getCanonicalFile();
            }
            if ((fileArray = file.listFiles()) == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file3 = fileArray[i];
                if (file3 == null || !file3.isDirectory() || (file3 = file3.getCanonicalFile()).equals(file2)) continue;
                defaultListModel.addElement(file3.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lstGroups.setModel(defaultListModel);
    }

    public void setSelectedProgramGroup(String string) {
        this.txtGroup.setText(string);
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
        ((DefaultListModel)this.lstGroups.getModel()).removeAllElements();
        this.fillGroupList();
        this.lstGroups.scrollRectToVisible(new Rectangle());
    }
}

