/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.wizard.CustomFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class LanguageSelectionDialog
extends CustomFrame
implements ActionListener {
    private static final int FRAME_WIDTH = 350;
    private JComboBox cmbLanguage;
    private JButton btnOk;
    private JButton btnCancel;
    private boolean canceled;
    private ReturnToken returnToken;
    private ResourceBundle messages;

    public LanguageSelectionDialog(ReturnToken returnToken) {
        this.returnToken = returnToken;
        GUIHelper.setLaF();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        String string = InstallerUtil.getSupportedSystemLanguageId();
        this.messages = installerConfig.isLanguageSelectionInPrincipalLanguage() || string == null ? Messages.createMessages((LanguageConfig)installerConfig.getLanguages().get(0)) : Messages.createMessages(installerConfig.getLanguageById(string));
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOk) {
            this.doOk();
        } else if (object == this.btnCancel) {
            this.doCancel();
        }
    }

    private void setupControls() {
        List list = InstallerConfig.getCurrentInstance().getLanguages();
        String string = Locale.getDefault().getLanguage();
        LanguageConfig languageConfig = InstallerConfig.getCurrentInstance().getLanguageById(string);
        if (languageConfig == null) {
            languageConfig = (LanguageConfig)list.get(0);
        }
        List list2 = Messages.sortLanguages(list, this.messages);
        this.cmbLanguage = new JComboBox<Object>(list2.toArray());
        this.cmbLanguage.setSelectedItem(languageConfig);
        this.cmbLanguage.setRenderer(new LanguageRenderer());
        this.btnOk = new JButton(this.messages.getString("ButtonOK"));
        this.btnCancel = new JButton(this.messages.getString("ButtonCancel"));
    }

    private String getLocalizedLanguageName(Object object) {
        return Messages.getLocalizedLanguageName(object, this.messages);
    }

    private void setupComponent() {
        GUIHelper.setIconImages(this);
        this.setTitle(this.messages.getString("LanguageSelectionDialogTitle"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(7, 7, 7, 7);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 2;
        Application application = InstallerConfig.getCurrentApplication();
        ImageIcon imageIcon = application.isUseCustomIcon() ? this.get32By32Image(application.getCustomIconImageFiles()) : GUIHelper.DEFAULT_ICON_FRAME_32;
        jPanel.add((Component)new JLabel(imageIcon), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.messages.getString("LanguageSelectionLabel")), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.cmbLanguage, gridBagConstraints);
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOk, this.btnCancel}, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)box, gridBagConstraints);
        this.setContentPane(jPanel);
        this.setBackground(jPanel.getBackground());
        this.getRootPane().setDefaultButton(this.btnOk);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setBounds(this.getNewFrameBounds());
        this.setResizable(false);
    }

    private ImageIcon get32By32Image(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ImageIcon imageIcon = new ImageIcon(((File)iterator.next()).getPath());
            if (imageIcon.getIconWidth() != 32) continue;
            return imageIcon;
        }
        return GUIHelper.DEFAULT_ICON_FRAME_32;
    }

    private void setupEventHandlers() {
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                LanguageSelectionDialog.this.canceled = true;
            }
        });
        KeyboardUtil.addAccelerator(1, this.btnCancel, (JComponent)this.getContentPane(), this, 27, 0);
    }

    protected int getFrameWidth() {
        return 350;
    }

    protected int getFrameHeight() {
        return -1;
    }

    private void doCancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    private void doOk() {
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (!bl) {
            this.returnToken.returnToController(this.getSelectedLanguageId());
            if (bl2) {
                this.dispose();
            }
        }
    }

    private String getSelectedLanguageId() {
        if (this.canceled) {
            return null;
        }
        return ((LanguageConfig)this.cmbLanguage.getSelectedItem()).getId();
    }

    private class LanguageRenderer
    extends DefaultListCellRenderer {
        private LanguageRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof LanguageConfig) {
                object = LanguageSelectionDialog.this.getLocalizedLanguageName(object);
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

