/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.context.WizardIndex;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.MaximizedLayeredPane;
import com.install4j.runtime.util.PartialLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class IndexPanel
extends JPanel {
    private WizardIndex wizardIndex;
    private Font boldFont;
    private Font plainFont;

    public IndexPanel(WizardIndex wizardIndex, String string) {
        this.wizardIndex = wizardIndex;
        MaximizedLayeredPane maximizedLayeredPane = new MaximizedLayeredPane();
        maximizedLayeredPane.add((Component)this.createTextBox(string), JLayeredPane.PALETTE_LAYER);
        maximizedLayeredPane.add((Component)this.createImagePanel(), JLayeredPane.DEFAULT_LAYER);
        this.setLayout(new BorderLayout());
        this.add((Component)maximizedLayeredPane, "Center");
    }

    private JComponent createTextBox(String string) {
        Box box = Box.createVerticalBox();
        String[] stringArray = this.wizardIndex.getStepNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = (this.wizardIndex.isNumbered() ? String.valueOf(i + 1) + ". " : "") + string2;
            boolean bl = this.wizardIndex.getKeys()[i].equals(string);
            box.add(this.createLabel(string3, bl));
        }
        if (this.wizardIndex.isPartiallyDefined()) {
            box.add(this.createLabel("...", false));
        }
        box.add(Box.createVerticalGlue());
        box.setBorder(BorderFactory.createCompoundBorder(new PartialLineBorder(GUIHelper.getSeparatorColor(), 1, 4), BorderFactory.createEmptyBorder(6, 6, 6, 4)));
        return box;
    }

    private JPanel createImagePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(this.getIndexBackground());
        jPanel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = this.wizardIndex.getBackgroundImageAnchor().getValue();
        jPanel.add((Component)new JLabel(this.getIcon(this.wizardIndex.getBackgroundImage())), gridBagConstraints);
        return jPanel;
    }

    private JLabel createLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        if (bl) {
            if (this.boldFont == null) {
                this.boldFont = font.deriveFont(1);
            }
            font = this.boldFont;
        } else if (font.isBold()) {
            if (this.plainFont == null) {
                this.plainFont = font.deriveFont(0);
            }
            font = this.plainFont;
        }
        jLabel.setFont(font);
        Color color = this.wizardIndex.getForeground();
        if (color != null) {
            jLabel.setForeground(color);
        }
        return jLabel;
    }

    public Icon getIcon(File file) {
        Object object;
        if (file == null) {
            return null;
        }
        if (!file.isAbsolute()) {
            if (file.getParent() == null && !((String)(object = file.getName())).startsWith("i4j_extf_")) {
                file = new File("user", (String)object);
            }
            file = InstallerUtil.getInstallerFile(file.getPath());
        }
        try {
            object = new ImageIcon(file.getPath());
            if (object.getIconWidth() > 0) {
                return object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Color getIndexBackground() {
        Color color = this.wizardIndex.getBackground();
        return color == null ? Color.WHITE : color;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.min(Math.max(dimension.width, this.wizardIndex.getMinWidth()), this.wizardIndex.getMaxWidth());
        return dimension;
    }
}

