/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.applications.UninstallerApplication;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class GUIHelper {
    public static final ImageIcon DEFAULT_ICON_FRAME_16 = GUIHelper.loadIcon("install4j_icon_16.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_32 = GUIHelper.loadIcon("install4j_icon_32.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_48 = GUIHelper.loadIcon("install4j_icon_48.png");
    private static final String ICONS_DIRECTORY = "icons/";
    public static final int BASELINE_LEADING = 512;
    private static boolean lafSet = false;
    private static final Dimension IMAGE_BUTTON_SIZE = new Dimension(28, 28);
    public static final Icon ICON_FOLDER_OPEN = GUIHelper.loadIcon("folder_open.png");
    public static final Icon ICON_FOLDER_CLOSED = GUIHelper.loadIcon("folder_closed.png");
    private static String browserExecutable = "";
    static /* synthetic */ Class class$java$lang$String;

    public static String getBrowserExecutable() {
        return browserExecutable;
    }

    public static void setBrowserExecutable(String string) {
        browserExecutable = string;
    }

    public static void setLanguage(String string) {
        String string2;
        if (InstallerUtil.isInProcess()) {
            return;
        }
        if (string != null) {
            int n = string.indexOf("_");
            if (n > -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            } else {
                string2 = "";
            }
            try {
                Locale.setDefault(new Locale(string, string2));
            }
            catch (Exception exception) {}
        } else {
            string = Locale.getDefault().getLanguage();
        }
        GUIHelper.setLaF();
        if (string.equals("ja") || string.equals("ko") || string.startsWith("zh")) {
            Font font = UIManager.getFont("Label.font");
            UIManager.put("OptionPane.font", font);
            UIManager.put("OptionPane.messageFont", font);
            UIManager.put("OptionPane.buttonFont", font);
        }
        String string3 = System.getProperty("install4j.font.offset");
        string2 = System.getProperty("java.version");
        if (string3 != null) {
            GUIHelper.adjustFontSize(Integer.parseInt(string3));
        } else if (string.equals("zh_TW") && string2.startsWith("1.4")) {
            GUIHelper.adjustFontSize(2);
        }
    }

    private static boolean isLafFailed() {
        if (Util.isWindows9X()) {
            Object object = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf");
            if (object != null && object instanceof Integer && (Integer)object == 1) {
                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(0));
                return true;
            }
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(1));
            return false;
        }
        return false;
    }

    private static void setLaFSucceded() {
        if (Util.isWindows9X()) {
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(0));
        }
    }

    public static void setLaF() {
        if (InstallerUtil.isInProcess()) {
            return;
        }
        if (!lafSet) {
            lafSet = true;
            if (!(GUIHelper.isLafFailed() || Boolean.getBoolean("install4j.nolaf") || InstallerUtil.isConsole() || InstallerUtil.isUnattended() || System.getProperty("swing.defaultlaf") != null)) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    if (GUIHelper.isGtkLaF() && InstallerUtil.isUpToJava15()) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    GUIHelper.setLaFSucceded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isWindowsLaF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isMetalLaF() {
        return UIManager.getLookAndFeel().getID().equals("Metal");
    }

    public static boolean isWindowsXpLaF() {
        return GUIHelper.isWindowsLaF() && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && !Boolean.getBoolean("swing.noxp");
    }

    public static boolean isWindowsClassicLaF() {
        return GUIHelper.isWindowsLaF() && (!Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) || Boolean.getBoolean("swing.noxp") || UIManager.getLookAndFeel().getClass().getName().endsWith("WindowsClassicLookAndFeel"));
    }

    public static boolean isGtkLaF() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    private static void adjustFontSize(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Font, Font> hashMap = new HashMap<Font, Font>();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = uIDefaults.get(k);
            if (!(object instanceof Font)) continue;
            Font font = (Font)object;
            Font font2 = (Font)hashMap.get(font);
            if (font2 == null) {
                font2 = new Font(font.getName(), font.getStyle(), font.getSize() + n);
                hashMap.put(font, font2);
            }
            linkedList.add(k);
            linkedList.add(font2);
        }
        uIDefaults.putDefaults(linkedList.toArray());
    }

    public static ImageIcon loadIcon(String string) {
        return new ImageIcon(GUIHelper.class.getResource(ICONS_DIRECTORY + string));
    }

    public static int showOptionDialog(Component component, final String string, final String[] stringArray, final int n) throws UserCanceledException {
        if (InstallerUtil.isUnattended()) {
            return -1;
        }
        if (InstallerUtil.isConsole()) {
            return ConsoleImpl.getInstance().askOption(string, stringArray, null);
        }
        GUIHelper.setLaF();
        final Component component2 = component == null ? GUIHelper.getParentWindow() : component;
        final int[] nArray = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            GUIHelper.showOptionDialogInternal(component, string, n, stringArray, nArray);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GUIHelper.showOptionDialogInternal(component2, string, n, stringArray, nArray);
                    }
                });
            }
            catch (Exception exception) {
                InstallerUtil.reportException(exception);
            }
        }
        return nArray[0];
    }

    private static void showOptionDialogInternal(Component component, String string, int n, String[] stringArray, int[] nArray) {
        component = GUIHelper.getOptionPaneParent(component);
        nArray[0] = JOptionPane.showOptionDialog(component, string, Messages.getMessages().getString("SetupAppTitle"), 0, n, null, stringArray, stringArray[0]);
        GUIHelper.disposeTempFrame(component);
    }

    public static Window getParentWindow() {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return null;
        }
        Frame[] frameArray = JFrame.getFrames();
        if (frameArray != null) {
            Frame frame = null;
            for (int i = 0; i < frameArray.length; ++i) {
                Frame frame2 = frameArray[i];
                if (frame2.isShowing()) {
                    return frame2;
                }
                if (frame2 instanceof TempFrame) continue;
                frame = frame2;
            }
            if (frame != null) {
                return frame;
            }
        }
        return null;
    }

    public static void showMessage(Component component, final String string, final int n) {
        if (InstallerUtil.isUnattended()) {
            System.err.println(string);
        } else if (InstallerUtil.isConsole()) {
            ConsoleImpl.getInstance().println(string);
        } else {
            Component component2;
            GUIHelper.setLaF();
            Component component3 = component2 = component == null ? GUIHelper.getParentWindow() : component;
            if (SwingUtilities.isEventDispatchThread()) {
                GUIHelper.showMessageInternal(component2, string, n);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            GUIHelper.showMessageInternal(component2, string, n);
                        }
                    });
                }
                catch (Exception exception) {
                    InstallerUtil.reportException(exception);
                }
            }
        }
    }

    private static void showMessageInternal(Component component, String string, int n) {
        component = GUIHelper.getOptionPaneParent(component);
        JOptionPane.showOptionDialog(component, string, Messages.getMessages().getString("SetupAppTitle"), -1, n, null, new Object[]{Messages.getMessages().getString("ButtonOK")}, null);
        GUIHelper.disposeTempFrame(component);
    }

    private static Component getOptionPaneParent(Component component) {
        if (Util.isWindows() && component == null) {
            return new TempFrame();
        }
        return component;
    }

    private static void disposeTempFrame(Component component) {
        if (component instanceof TempFrame) {
            ((TempFrame)component).dispose();
        }
    }

    public static void showURL(String string) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        Boolean bl = (Boolean)ContextImpl.runUnelevatedInt(new ShowURLRemoteCallable(string), true);
        if (bl == null || !bl.booleanValue()) {
            Window window = GUIHelper.getParentWindow();
            if (InstallerUtil.isWindows() || InstallerUtil.isMacOS()) {
                GUIHelper.showBrowserError(window);
            } else {
                if (browserExecutable == null || browserExecutable.length() == 0) {
                    browserExecutable = "firefox";
                }
                if (!GUIHelper.startBrowser(string, window, false)) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setDialogTitle(Messages.getMessages().getString("LocateBrowserExecutable"));
                    if (jFileChooser.showOpenDialog(window) != 0) {
                        return;
                    }
                    browserExecutable = jFileChooser.getSelectedFile().getPath();
                    GUIHelper.startBrowser(string, window, true);
                }
            }
        }
    }

    public static Color getSeparatorColor() {
        return UIManager.getColor("Separator.foreground");
    }

    public static boolean confirmCancel(Component component) {
        ResourceBundle resourceBundle = Messages.getMessages();
        int n = 0;
        try {
            String string = null;
            Application application = InstallerConfig.getCurrentApplication();
            if (application instanceof InstallerApplication) {
                string = resourceBundle.getString("ExitSetupMessage");
            } else if (application instanceof UninstallerApplication) {
                string = resourceBundle.getString("ExitUninstallerMessage");
            } else if (application instanceof CustomApplication) {
                CustomApplication customApplication = (CustomApplication)application;
                if (customApplication.isShowCancelMessage()) {
                    string = customApplication.getCancelMessage();
                }
            } else {
                string = resourceBundle.getString("ExitApplication");
            }
            if (string != null) {
                n = GUIHelper.showOptionDialog(component, string, new String[]{resourceBundle.getString("ButtonExit"), resourceBundle.getString("ButtonContinue")}, 3);
            }
        }
        catch (UserCanceledException userCanceledException) {
            // empty catch block
        }
        return n == 0;
    }

    public static String encodeSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static boolean startBrowser(String string, Window window, boolean bl) {
        if (LaunchHelper.launchFinishExecutable(new File(browserExecutable), new String[]{string}, null)) {
            return true;
        }
        browserExecutable = null;
        if (bl) {
            GUIHelper.showBrowserError(window);
        }
        return false;
    }

    private static void showBrowserError(Window window) {
        GUIHelper.showMessage(window, Messages.getMessages().getString("ErrorStartingBrowser"), 0);
    }

    public static List getFrameIconImages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Application application = InstallerConfig.getCurrentApplication();
        if (application.isUseCustomIcon()) {
            try {
                Iterator iterator = application.getCustomIconImageFiles().iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    ImageIcon imageIcon = new ImageIcon(InstallerUtil.getInstallerFile(file.getPath()).getPath());
                    if (imageIcon.getIconWidth() <= 0) continue;
                    arrayList.add(imageIcon.getImage());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(DEFAULT_ICON_FRAME_16.getImage());
            arrayList.add(DEFAULT_ICON_FRAME_32.getImage());
            arrayList.add(DEFAULT_ICON_FRAME_48.getImage());
        }
        return arrayList;
    }

    public static void makeTransparent(JComponent jComponent) {
        if (!GUIHelper.isWindowsLaF() && !GUIHelper.isMetalLaF()) {
            return;
        }
        if (jComponent.getBackground() instanceof ColorUIResource && (jComponent instanceof JPanel || jComponent instanceof JRadioButton || jComponent instanceof JCheckBox || jComponent instanceof JSlider || jComponent instanceof JSplitPane || !GUIHelper.isWindowsClassicLaF() && jComponent instanceof JButton)) {
            jComponent.setOpaque(false);
        }
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            GUIHelper.makeTransparent((JComponent)component);
        }
    }

    public static void setIconImages(Window window) {
        VersionSpecificHelper.setIconImages(GUIHelper.getFrameIconImages(), window);
    }

    public static void showPath(String string) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        File file = new File(string);
        boolean bl = file.isDirectory();
        if (InstallerUtil.isMacOS()) {
            File file2 = bl ? file : file.getParentFile();
            LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/open")).arguments(new String[]{file2.getAbsolutePath()}));
        } else {
            String[] stringArray;
            File file3 = null;
            if (InstallerUtil.isWindows()) {
                if (string.indexOf(32) > -1) {
                    string = FolderInfo.getShortPathName(string);
                }
                stringArray = new String[]{"explorer.exe", (bl ? "" : "/select,") + string};
            } else {
                stringArray = new String[]{"/bin/sh", "-c", "xterm"};
                file3 = bl ? file : file.getParentFile();
            }
            try {
                Runtime.getRuntime().exec(stringArray, null, file3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void makeImageButton(AbstractButton abstractButton) {
        abstractButton.setText(null);
        abstractButton.setMinimumSize(IMAGE_BUTTON_SIZE);
        abstractButton.setPreferredSize(IMAGE_BUTTON_SIZE);
        abstractButton.setMaximumSize(IMAGE_BUTTON_SIZE);
        if (Util.isMacOS()) {
            abstractButton.putClientProperty("JButton.buttonType", "toolbar");
        }
    }

    private static class ShowURLRemoteCallable
    extends AbstractRemoteCallable {
        String urlSpec;

        public ShowURLRemoteCallable(String string) {
            this.urlSpec = string;
        }

        public Serializable execute() {
            if (VersionSpecificHelper.showUrlWithDesktop(this.urlSpec)) {
                return Boolean.TRUE;
            }
            if (InstallerUtil.isWindows()) {
                if (this.urlSpec.toLowerCase().indexOf("#") > -1) {
                    this.urlSpec = "\"" + this.urlSpec + "\"";
                }
                try {
                    Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler " + this.urlSpec);
                }
                catch (IOException iOException) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (InstallerUtil.isMacOS()) {
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = GUIHelper.class$("java.lang.String")) : class$java$lang$String};
                Object[] objectArray = new Object[]{GUIHelper.encodeSpaces(this.urlSpec)};
                try {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", classArray).invoke(null, objectArray);
                }
                catch (Exception exception) {
                    try {
                        Class.forName("com.apple.mrj.MRJFileUtils").getDeclaredMethod("openURL", classArray).invoke(null, objectArray);
                    }
                    catch (Exception exception2) {
                        return Boolean.FALSE;
                    }
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private static class TempFrame
    extends JFrame {
        private TempFrame() {
            super(Messages.getMessages().getString("SetupAppTitle"));
            this.setUndecorated(true);
            this.setVisible(true);
            this.setLocationRelativeTo(null);
            GUIHelper.setIconImages(this);
        }
    }
}

