/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.ComponentTuple;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentImpl;
import com.install4j.runtime.beans.groups.FormComponentGroup;
import com.install4j.runtime.beans.groups.GroupOrientation;
import com.install4j.runtime.beans.groups.HorizontalFormComponentGroup;
import com.install4j.runtime.beans.groups.LayoutManagerGroup;
import com.install4j.runtime.beans.groups.TabGroup;
import com.install4j.runtime.beans.groups.VerticalFormComponentGroup;
import com.install4j.runtime.beans.screens.components.ScrollablePanel;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.FormComponentProvider;
import com.install4j.runtime.installer.config.GroupProvider;
import com.install4j.runtime.installer.frontend.ComponentTupleImpl;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.LayoutGroupImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.SizeGroupComponentWrapper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FormPanel
extends JPanel {
    private static final int BASELINE_LEADING = 512;
    private static final int[][] ANCHOR_MATRIX = new int[][]{{18, 11, 12}, {17, 10, 13}, {16, 15, 14}};
    private List beanConfigs;
    private List formComponentProviders;
    private Context context;
    private boolean banner;
    private Screen screen;
    private JScrollPane scpComponents;
    protected JPanel componentsPanel;
    private Set initializedComponents = new HashSet();
    private FormEnvironment formEnvironment;

    public FormPanel(List list, Context context, boolean bl, Screen screen) {
        this.beanConfigs = list;
        this.context = context;
        this.banner = bl;
        this.screen = screen;
        this.setupControls();
        this.setupComponent();
        GUIHelper.makeTransparent(this);
    }

    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public ProgressInterface findProgressInterface() {
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponent formComponent = ((FormComponentProvider)iterator.next()).getFormComponent();
            if (!(formComponent instanceof ProgressInterface) || !formComponent.isEnabled()) continue;
            return (ProgressInterface)((Object)formComponent);
        }
        return null;
    }

    public void previous() {
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            if (!formComponentProvider.isResetInitOnPrevious()) continue;
            this.initializedComponents.remove(formComponentProvider.getFormComponent());
        }
    }

    public boolean checkCompleted() {
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            if (formComponentProvider.getFormComponent().checkCompleted()) continue;
            return false;
        }
        return true;
    }

    public void willActivate() {
        this.initializeComponents();
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            formComponentProvider.getFormComponent().formWillActivate();
        }
    }

    public void activated() {
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            formComponentProvider.getFormComponent().formActivated();
        }
    }

    public void deactivated() {
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            formComponentProvider.getFormComponent().formDeactivated();
        }
    }

    public boolean handleUnattended() {
        this.initializeComponents();
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            FormComponent formComponent = this.processFormComponent(formComponentProvider);
            if (formComponent == null || formComponent.handleUnattended()) continue;
            return false;
        }
        return this.checkCompleted();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        this.willActivate();
        this.activated();
        this.enableLayoutGroups(this.beanConfigs);
        do {
            Iterator iterator = this.formComponentProviders.iterator();
            while (iterator.hasNext()) {
                FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
                FormComponent formComponent = this.processFormComponent(formComponentProvider);
                if (formComponent == null || formComponent.handleConsole(console)) continue;
                this.deactivated();
                return false;
            }
        } while (!this.checkCompleted());
        this.deactivated();
        return true;
    }

    private boolean isInHiddenLayoutGroup(FormComponent formComponent) {
        return this.isInHiddenLayoutGroup(formComponent, this.beanConfigs);
    }

    private boolean isInHiddenLayoutGroup(FormComponent formComponent, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            GroupProvider groupProvider;
            Object e = iterator.next();
            if (!(e instanceof GroupProvider ? ((FormComponentGroup)(groupProvider = (GroupProvider)e).getOrInstantiateBean()).isVisible() && !this.isInHiddenLayoutGroup(formComponent, groupProvider.getBeanConfigs()) : e instanceof FormComponentProvider && ((FormComponentProvider)e).getFormComponent() == formComponent)) continue;
            return false;
        }
        return true;
    }

    private void enableLayoutGroups(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof GroupProvider)) continue;
            GroupProvider groupProvider = (GroupProvider)e;
            FormComponentGroup formComponentGroup = (FormComponentGroup)groupProvider.getOrInstantiateBean();
            try {
                Boolean bl = (Boolean)this.context.runScript(formComponentGroup.getVisibilityScript(), formComponentGroup, new Object[]{this.formEnvironment});
                if (bl != null) {
                    formComponentGroup.setVisible(bl);
                }
                this.enableLayoutGroups(groupProvider.getBeanConfigs());
            }
            catch (Exception exception) {
                Util.printAnnotatedStackTrace(exception);
                Logger.getInstance().log(exception);
                return;
            }
        }
    }

    private FormComponent processFormComponent(FormComponentProvider formComponentProvider) {
        FormComponent formComponent = formComponentProvider.getFormComponent();
        if (this.isInHiddenLayoutGroup(formComponent)) {
            return null;
        }
        Object[] objectArray = formComponent.getConfigurationObjectClass() != null ? new Object[]{this.formEnvironment, formComponent.getConfigurationObject()} : new Object[]{this.formEnvironment};
        formComponent.setVisible(ContextImpl.getContextImpl(this.context).runBooleanScript(((FormComponentBeanConfig)formComponentProvider).getVisibilityClassName(), formComponent, objectArray));
        if (!formComponent.isVisible() || !formComponent.isEnabled()) {
            return null;
        }
        return formComponent;
    }

    protected void initializeComponents() {
        this.enableLayoutGroups(this.beanConfigs);
        Iterator iterator = this.formComponentProviders.iterator();
        while (iterator.hasNext()) {
            FormComponentProvider formComponentProvider = (FormComponentProvider)iterator.next();
            FormComponent formComponent = formComponentProvider.getFormComponent();
            if (this.initializedComponents.contains(formComponent)) continue;
            this.initializeComponent(formComponent, formComponentProvider);
            this.initializedComponents.add(formComponent);
        }
    }

    protected void initializeComponent(FormComponent formComponent, FormComponentProvider formComponentProvider) {
        try {
            formComponent.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.getInstance().log(exception);
        }
        Object[] objectArray = formComponent.getConfigurationObjectClass() != null ? new Object[]{this.formEnvironment, formComponent.getConfigurationObject()} : new Object[]{this.formEnvironment};
        ContextImpl contextImpl = ContextImpl.getContextImpl(this.context);
        if (contextImpl != null) {
            try {
                formComponent.setVisible(contextImpl.runBooleanScript(((FormComponentBeanConfig)formComponentProvider).getVisibilityClassName(), formComponent, objectArray));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getInstance().log(exception);
            }
            try {
                contextImpl.runBooleanScript(((FormComponentBeanConfig)formComponentProvider).getInitClassName(), formComponent, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.getInstance().log(exception);
            }
        }
    }

    private void setupControls() {
        this.componentsPanel = new ScrollablePanel();
        this.componentsPanel.setLayout(new GridBagLayout());
        this.scpComponents = new JScrollPane(this.componentsPanel);
        this.scpComponents.setHorizontalScrollBarPolicy(31);
        if (this.banner) {
            this.componentsPanel.setBackground(Color.white);
            this.scpComponents.getViewport().setBackground(Color.white);
        } else if (!GUIHelper.isGtkLaF()) {
            this.scpComponents.getViewport().setBackground(this.componentsPanel.getBackground());
        } else {
            this.scpComponents.getViewport().setOpaque(false);
        }
        this.scpComponents.setViewportBorder(null);
        this.scpComponents.setBorder(null);
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.formEnvironment = this.createFormEnvironment(new FormComponent[0], new String[0], new String[0], new ComponentTuple[0], Collections.EMPTY_LIST);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        this.formComponentProviders = new ArrayList();
        PanelConstructionState panelConstructionState = this.buildPanel(this.beanConfigs, this.componentsPanel, new VerticalFormComponentGroup(), arrayList, arrayList2, arrayList3, arrayList4, false);
        FormComponent[] formComponentArray = arrayList.toArray(new FormComponent[arrayList.size()]);
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        String[] stringArray2 = arrayList3.toArray(new String[arrayList2.size()]);
        ComponentTuple[] componentTupleArray = arrayList4.toArray(new ComponentTuple[arrayList4.size()]);
        this.formEnvironment = this.createFormEnvironment(formComponentArray, stringArray, stringArray2, componentTupleArray, this.beanConfigs);
        this.setFormEnvironment(this.formEnvironment.getFormComponentTree());
        if (this.screen != null) {
            if (((FormPanelContainer)((Object)this.screen)).isScrollFormPanel()) {
                this.add((Component)this.scpComponents, "Center");
            } else {
                if (!panelConstructionState.verticalSpaceFilled) {
                    GridBagConstraints gridBagConstraints = panelConstructionState.gc;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.fill = 3;
                    this.componentsPanel.add((Component)new JPanel(), gridBagConstraints);
                    ++gridBagConstraints.gridy;
                }
                this.add((Component)this.componentsPanel, "Center");
            }
        }
    }

    private void setFormEnvironment(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof FormComponent) {
                ((FormComponent)e).setFormEnvironment(this.formEnvironment);
                continue;
            }
            if (!(e instanceof LayoutGroupImpl)) continue;
            LayoutGroupImpl layoutGroupImpl = (LayoutGroupImpl)e;
            layoutGroupImpl.getGroup().setFormEnvironment(this.formEnvironment);
            this.setFormEnvironment(layoutGroupImpl.getChildren());
        }
    }

    private PanelConstructionState buildPanel(List list, JComponent jComponent, FormComponentGroup formComponentGroup, List list2, List list3, List list4, List list5, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        SizeGroupComponentWrapper sizeGroupComponentWrapper = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object e = iterator.next();
            if (e instanceof FormComponentProvider && formComponentGroup instanceof LayoutManagerGroup) {
                object2 = (FormComponentProvider)e;
                if (!object2.isEnabled() || object2.getFormComponent() == null) continue;
                this.formComponentProviders.add(object2);
                bl2 = bl2 || object2.getFormComponent().isFillCenterVertical();
                bl3 = bl3 || object2.getFormComponent().isFillCenterHorizontal();
                object = this.addFormComponent((FormComponentProvider)object2, (JPanel)jComponent, gridBagConstraints, (LayoutManagerGroup)formComponentGroup, bl, bl4);
                if (bl4 && object.getLeftComponent() != null) {
                    sizeGroupComponentWrapper = (SizeGroupComponentWrapper)object.getLeftComponent().getParent();
                }
                list2.add(object2.getFormComponent());
                list3.add(this.dequalifyId(object2.getId()));
                list4.add(this.dequalifyId(object2.getDisplayedId()));
                list5.add(object);
                if (this.banner) {
                    this.makeTransparent(object.getLeftComponent());
                    this.makeTransparent(object.getCenterComponent());
                    this.makeTransparent(object.getRightComponent());
                }
            } else if (e instanceof GroupProvider) {
                object2 = (GroupProvider)e;
                if (!object2.isEnabled()) continue;
                object = (FormComponentGroup)object2.getOrInstantiateBean();
                ((FormComponentGroup)object).setFormEnvironment(this.formEnvironment);
                ((FormComponentGroup)object).setContext(this.context);
                ((FormComponentGroup)object).setId(object2.getId());
                JComponent jComponent2 = ((FormComponentGroup)object).createComponent(jComponent);
                PanelConstructionState panelConstructionState = this.buildPanel(object2.getBeanConfigs(), jComponent2, (FormComponentGroup)object, list2, list3, list4, list5, ((FormComponentGroup)object).isBaselineOverride());
                bl2 = bl2 || panelConstructionState.verticalSpaceFilled;
                boolean bl5 = bl3 = bl3 || panelConstructionState.horizontalSpaceFilled;
                if (object instanceof TabGroup) {
                    this.addTabGroup((TabGroup)object, jComponent2, panelConstructionState);
                } else {
                    GroupOrientation groupOrientation = formComponentGroup.getGroupOrientation();
                    if (groupOrientation == GroupOrientation.VERTICAL) {
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridwidth = 3;
                    } else {
                        gridBagConstraints.gridwidth = 1;
                    }
                    if (formComponentGroup instanceof VerticalFormComponentGroup && ((FormComponentGroup)object).getGroupOrientation() == GroupOrientation.HORIZONTAL && ((HorizontalFormComponentGroup)object).isAlignFirstLabel() && panelConstructionState.firstSizeGroupComponentWrapper != null) {
                        ((VerticalFormComponentGroup)formComponentGroup).getSizeGroup().addComponentWrapper(panelConstructionState.firstSizeGroupComponentWrapper);
                    }
                    bl3 |= ((FormComponentGroup)object).isWidthOverride();
                    bl2 |= ((FormComponentGroup)object).isHeightOverride();
                    boolean bl6 = panelConstructionState.horizontalSpaceFilled || ((FormComponentGroup)object).isWidthOverride();
                    boolean bl7 = panelConstructionState.verticalSpaceFilled || ((FormComponentGroup)object).isHeightOverride();
                    gridBagConstraints.anchor = ((FormComponentGroup)object).getAnchor().getValue();
                    gridBagConstraints.weightx = bl6 ? 1.0 : 0.0;
                    gridBagConstraints.weighty = bl7 ? 1.0 : 0.0;
                    gridBagConstraints.fill = this.getFillMode(bl6, bl7);
                    gridBagConstraints.insets = (Insets)((FormComponentGroup)object).getInsets().clone();
                    jComponent.add((Component)jComponent2, gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    if (groupOrientation == GroupOrientation.VERTICAL) {
                        ++gridBagConstraints.gridy;
                    }
                }
            }
            bl4 = false;
        }
        return new PanelConstructionState(gridBagConstraints, bl2, bl3, sizeGroupComponentWrapper);
    }

    private void makeTransparent(JComponent jComponent) {
        if (jComponent != null && !GUIHelper.isWindowsClassicLaF()) {
            jComponent.setOpaque(false);
        }
    }

    private void addTabGroup(TabGroup tabGroup, JComponent jComponent, PanelConstructionState panelConstructionState) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = tabGroup.getAnchor().getValue();
        gridBagConstraints.fill = this.getFillMode(panelConstructionState.horizontalSpaceFilled, panelConstructionState.verticalSpaceFilled);
        gridBagConstraints.insets = (Insets)tabGroup.getInsets().clone();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        tabGroup.getPanel().add((Component)jComponent, gridBagConstraints);
    }

    private String dequalifyId(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private int getFillMode(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? 1 : 2;
        }
        return bl2 ? 3 : 0;
    }

    protected FormEnvironmentImpl createFormEnvironment(FormComponent[] formComponentArray, String[] stringArray, String[] stringArray2, ComponentTuple[] componentTupleArray, List list) {
        return new FormEnvironmentImpl(this, formComponentArray, stringArray, stringArray2, componentTupleArray, list);
    }

    private ComponentTuple addFormComponent(FormComponentProvider formComponentProvider, JPanel jPanel, GridBagConstraints gridBagConstraints, LayoutManagerGroup layoutManagerGroup, boolean bl, boolean bl2) {
        int n;
        GroupOrientation groupOrientation = layoutManagerGroup.getGroupOrientation();
        FormComponent formComponent = formComponentProvider.getFormComponent();
        formComponent.setContext(formComponentProvider.wrapContext(this.context));
        formComponent.setFormEnvironment(this.formEnvironment);
        JComponent jComponent = formComponent.createLeftComponent();
        JComponent jComponent2 = formComponent.createCenterComponent();
        JComponent jComponent3 = formComponent.createRightComponent();
        if (jComponent2 == null) {
            return new ComponentTupleImpl(null, null, null);
        }
        gridBagConstraints.insets.top = formComponentProvider.getInsetTop();
        gridBagConstraints.insets.bottom = formComponentProvider.getInsetBottom();
        gridBagConstraints.insets.left = formComponentProvider.getInsetLeft();
        gridBagConstraints.insets.right = 0;
        int n2 = n = bl2 ? 0 : layoutManagerGroup.getCellSpacing();
        if (groupOrientation == GroupOrientation.VERTICAL) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets.top += n;
        } else {
            gridBagConstraints.insets.left += n;
        }
        gridBagConstraints.gridwidth = 1;
        boolean bl3 = bl;
        if (jComponent != null) {
            if (jComponent instanceof JLabel && ((JLabel)jComponent).getText().length() > 0 && InstallerUtil.isAtLeastJava16() && !layoutManagerGroup.isMakeSameHeight()) {
                bl3 = true;
            }
            gridBagConstraints.anchor = bl3 ? 512 : this.getAnchor(jComponent);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            SizeGroupComponentWrapper sizeGroupComponentWrapper = VersionSpecificHelper.createSizeGroupComponentWrapper(jComponent);
            jPanel.add((Component)sizeGroupComponentWrapper, gridBagConstraints);
            if (layoutManagerGroup instanceof VerticalFormComponentGroup) {
                ((VerticalFormComponentGroup)layoutManagerGroup).getSizeGroup().addComponentWrapper(sizeGroupComponentWrapper);
            }
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets.left = 0;
        } else if (groupOrientation == GroupOrientation.VERTICAL) {
            ++gridBagConstraints.gridwidth;
        }
        if (jComponent3 == null) {
            if (groupOrientation == GroupOrientation.VERTICAL) {
                ++gridBagConstraints.gridwidth;
            }
            gridBagConstraints.insets.right = formComponentProvider.getInsetRight();
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (groupOrientation == GroupOrientation.HORIZONTAL) {
            gridBagConstraints.weightx = formComponent.isFillCenterHorizontal() ? 1.0 : 0.0;
            bl4 = layoutManagerGroup.isMakeSameHeight();
        } else {
            gridBagConstraints.weightx = 1.0;
        }
        if (groupOrientation == GroupOrientation.VERTICAL) {
            gridBagConstraints.weighty = formComponent.isFillCenterVertical() ? 1.0 : 0.0;
            bl5 = layoutManagerGroup.isMakeSameWidth();
        } else {
            gridBagConstraints.weighty = 1.0;
        }
        if (bl5) {
            gridBagConstraints.weightx = 1.0;
        }
        if (bl4) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.fill = this.getFillMode(formComponent.isFillCenterHorizontal() || bl5, formComponent.isFillCenterVertical() || bl4);
        gridBagConstraints.anchor = bl3 ? 512 : this.getAnchor(jComponent2);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        if (jComponent3 != null) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = bl3 ? 512 : this.getAnchor(jComponent3);
            gridBagConstraints.insets.right = formComponentProvider.getInsetRight();
            gridBagConstraints.insets.left = 0;
            jPanel.add((Component)jComponent3, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (groupOrientation == GroupOrientation.VERTICAL) {
            ++gridBagConstraints.gridy;
        }
        return new ComponentTupleImpl(jComponent, jComponent2, jComponent3);
    }

    private int getAnchor(JComponent jComponent) {
        float f = jComponent.getAlignmentY();
        int n = f < 0.5f ? 0 : (f > 0.5f ? 2 : 1);
        float f2 = jComponent.getAlignmentX();
        int n2 = f2 < 0.5f ? 0 : (f > 0.5f ? 2 : 1);
        return ANCHOR_MATRIX[n][n2];
    }

    private class PanelConstructionState {
        private final GridBagConstraints gc;
        private final boolean verticalSpaceFilled;
        private final boolean horizontalSpaceFilled;
        private final SizeGroupComponentWrapper firstSizeGroupComponentWrapper;

        public PanelConstructionState(GridBagConstraints gridBagConstraints, boolean bl, boolean bl2, SizeGroupComponentWrapper sizeGroupComponentWrapper) {
            this.gc = gridBagConstraints;
            this.verticalSpaceFilled = bl;
            this.horizontalSpaceFilled = bl2;
            this.firstSizeGroupComponentWrapper = sizeGroupComponentWrapper;
        }
    }
}

