/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.exe4j.runtime.WinLauncher;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.launcher.Launcher;
import com.install4j.runtime.util.StreamConsumerThread;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;

class LanguageSelector {
    LanguageSelector() {
    }

    static void initLanguage(ContextImpl contextImpl, ScreenExecutor screenExecutor) {
        String string = contextImpl.getLanguageId();
        if (string != null) {
            Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(string));
        } else {
            string = LanguageSelector.queryLanguage(screenExecutor);
            if (string == null) {
                InstallerUtil.exit(1);
            } else {
                contextImpl.setLanguageId(string);
                String string2 = System.getProperty("exe4j.moduleName");
                if (string2 == null || !new File(string2).exists() || InstallerUtil.isMacOS() || string.equals(System.getProperty("user.language")) || contextImpl.isConsole() || contextImpl.isUnattended() || Boolean.getBoolean("install4j.noSecondaryProcess")) {
                    Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(string));
                } else {
                    Logger.getInstance().switchToSecondaryProcess();
                    String[] stringArray = InstallerUtil.isWindows() ? WinLauncher.appendOriginalArgs(new String[]{string2, "__i4j_lang_restart", "-Duser.language=" + string, "-Dinstall4j.language=" + string, "-Dexe4j.unextractedPositionRestart=" + Integer.getInteger("exe4j.unextractedPosition", 0)}) : Launcher.appendOriginalArgs(new String[]{"/bin/sh", string2, "__i4j_lang_restart", "-Duser.language=" + string, "-Dinstall4j.language=" + string});
                    try {
                        Process process = Runtime.getRuntime().exec(stringArray, null, new File(System.getProperty("user.dir")));
                        StreamConsumerThread.consumeOutput(process);
                        try {
                            System.exit(process.waitFor());
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            System.exit(1);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Messages.setLanguageConfig(InstallerConfig.getCurrentInstance().getLanguageById(string));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryLanguage(final ScreenExecutor screenExecutor) {
        final ReturnToken returnToken = new ReturnToken();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                screenExecutor.selectLanguage(returnToken);
            }
        });
        ReturnToken returnToken2 = returnToken;
        synchronized (returnToken2) {
            while (!returnToken.isWokenUp()) {
                try {
                    returnToken.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
        return (String)returnToken.getReturnValue();
    }
}

