/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.Util;
import com.install4j.api.context.FileOptions;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.applications.UninstallerApplication;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.ApplicationBeanConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.ComponentFolderConfig;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import com.install4j.runtime.installer.config.FileOptionsConfig;
import com.install4j.runtime.installer.config.FilesetConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.LegacyUninstallerBeanConfig;
import com.install4j.runtime.installer.config.MacSpecificConfig;
import com.install4j.runtime.installer.config.RootConfig;
import com.install4j.runtime.installer.config.ScriptClassOrigin;
import com.install4j.runtime.installer.config.UnixSpecificConfig;
import com.install4j.runtime.installer.config.WindowsSpecificConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstallerConfig
extends AbstractConfig {
    private static String currentApplicationId = null;
    private static Application currentApplication = null;
    private static InstallerConfig currentConfig = null;
    private String install4jVersion = "";
    private String install4jBuild = "";
    private String type;
    private boolean archive;
    private String applicationName = "";
    private String applicationVersion = "";
    private String defaultInstallationDirectory = "";
    private boolean jreShared = false;
    private String jreVersion = "";
    private Map applicationIdToConfig = new HashMap();
    private Map classNameToScriptClassOrigin = new HashMap();
    private List filesets = Collections.EMPTY_LIST;
    private List components = Collections.EMPTY_LIST;
    private ComponentFolderConfig componentRoot = new ComponentFolderConfig(null);
    private List launchers = Collections.EMPTY_LIST;
    private List uninstallDeleteEntries;
    private String minJavaVersion = "";
    private String publisherName = "";
    private String publisherURL = "";
    private String mediaName = "";
    private String mediaSetId = "";
    private String uninstallerPath = "uninstall";
    private String uninstallerDirectory = ".";
    private String projectCrc;
    private File installationDirectory;
    private String downloadURL = "";
    private List customJars = Collections.EMPTY_LIST;
    private String status = "";
    private List languages = Collections.EMPTY_LIST;
    private boolean skipLanguageSelection = false;
    private boolean languageSelectionInPrincipalLanguage = false;
    private Map compilerVariables = Collections.EMPTY_MAP;
    private Map externalRoots = Collections.EMPTY_MAP;
    private String applicationId = "";
    private int installerType;
    private String addonAppId = "";
    private boolean suggestPreviousLocations = true;
    private boolean lzmaCompression = false;
    private boolean pack200Compression = false;
    private FileOptionsConfig fileOptionsConfig = new FileOptionsConfig();
    private WindowsSpecificConfig windowsSpecificConfig = new WindowsSpecificConfig();
    private MacSpecificConfig macSpecificConfig = new MacSpecificConfig();
    private UnixSpecificConfig unixSpecificConfig = new UnixSpecificConfig();
    private boolean readGeneralOnly;

    public static void setCurrentApplicationId(String string) {
        if (currentApplicationId != null) {
            throw new IllegalStateException();
        }
        currentApplicationId = string;
        if (currentConfig == null) {
            try {
                currentConfig = new InstallerConfig(InstallerUtil.getInstallerFile("i4jparams.conf"), false);
            }
            catch (IOException iOException) {
                GUIHelper.showMessage(null, "Internal error: Could not open config file.", 0);
                InstallerUtil.exit(1);
            }
        }
        try {
            currentApplication = currentConfig.getApplicationById(string);
        }
        catch (Exception exception) {
            GUIHelper.showMessage(null, "Internal error: The selected application could not be instantiated.", 0);
            InstallerUtil.exit(1);
        }
        if (currentApplication == null) {
            GUIHelper.showMessage(null, "Internal error: The selected application " + string + " could not be instantiated.", 0);
            InstallerUtil.exit(1);
        }
    }

    public static void clearCurrentApplication() {
        currentApplicationId = null;
        currentApplication = null;
        currentConfig = null;
    }

    public static Map readVariables(Element element) {
        Properties properties = new Properties();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = InstallerConfig.readAttribute(element2, "name", (String)null);
            String string2 = InstallerConfig.readAttribute(element2, "value", (String)null);
            if (string == null || string2 == null) continue;
            properties.setProperty(string, string2);
        }
        return Collections.unmodifiableMap(properties);
    }

    public static InstallerConfig getCurrentInstance() {
        return currentConfig;
    }

    public static Application getCurrentApplication() {
        return currentApplication;
    }

    public static String getCurrentApplicationId() {
        return currentApplicationId;
    }

    public static boolean isInstaller() {
        return currentApplicationId.equals("installer");
    }

    public static boolean isUninstaller() {
        return currentApplicationId.equals("uninstaller");
    }

    public static InstallerConfig getGeneralConfigFromFile(File file) throws IOException {
        return new InstallerConfig(file, true);
    }

    public static InstallerConfig getConfigFromFile(File file) throws IOException {
        return new InstallerConfig(file, false);
    }

    private InstallerConfig(File file, boolean bl) throws IOException {
        this.readGeneralOnly = bl;
        Document document = XmlHelper.parseFile(file);
        this.read(document.getDocumentElement());
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.getApplicationId().getBytes("UTF-8"));
        this.projectCrc = Long.toString(cRC32.getValue(), 36);
    }

    public String getInstall4jVersion() {
        return this.install4jVersion;
    }

    public String getInstall4jBuild() {
        return this.install4jBuild;
    }

    public String getProjectCrc() {
        return this.projectCrc;
    }

    public String getMediaSetId() {
        return this.mediaSetId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public boolean isLzmaCompression() {
        return this.lzmaCompression;
    }

    public String getType() {
        return this.type;
    }

    public boolean isArchive() {
        return this.archive;
    }

    public boolean isJreShared() {
        return this.jreShared;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getApplicationName() {
        return InstallerVariables.replaceVariables(this.applicationName);
    }

    public String getApplicationNameWithVersion() {
        String string = this.getApplicationName();
        if (this.getApplicationVersion().trim().length() > 0 && this.getApplicationName().indexOf(this.getApplicationVersion()) == -1) {
            string = string + " " + this.getApplicationVersion();
        }
        return string;
    }

    public File getInstallationDirectory() {
        if (this.installationDirectory == null) {
            this.installationDirectory = this.getInitialInstallationDirectory();
        }
        return this.installationDirectory;
    }

    public void setInstallationDirectory(File file) {
        this.installationDirectory = file;
    }

    private File getInitialInstallationDirectory() {
        int n;
        int n2;
        String string;
        String string2;
        if (this.isSuggestPreviousLocations() && (string2 = InstallRegistry.getInstallationDir(string = this.getTargetApplicationId())) != null && string2.trim().length() > 0) {
            String string3 = InstallRegistry.getSingleBundleName(string, string2);
            if (!Util.isMacosInstaller() || this.getMacSpecificConfig().isSingleBundle() || string3 == null) {
                if (Util.isMacosInstaller() && this.isAddOnInstaller() && string3 != null) {
                    return new File(string2, string3 + "/" + "Contents/Resources/app");
                }
                if (new File(string2).getParentFile() != null) {
                    return new File(string2);
                }
            }
        }
        string = StringUtil.replaceHomeDir(this.defaultInstallationDirectory);
        while ((n2 = string.indexOf(123)) > -1 && (n = string.indexOf(125, n2)) >= 0) {
            String string4 = string.substring(n2, n + 1);
            string = string.substring(0, n2) + InstallerConfig.getVariableValue(string4) + string.substring(n + 1);
        }
        return new File(string);
    }

    private static String getVariableValue(String string) {
        if (string.equals("{/}")) {
            return File.separator;
        }
        if (string.equals("{appdir}")) {
            return InstallerUtil.getStandardApplicationsDirectory();
        }
        return "";
    }

    public List getApplicationScreens() {
        ApplicationBeanConfig applicationBeanConfig = this.getApplicationConfigById(currentApplicationId);
        if (applicationBeanConfig == null) {
            return Collections.EMPTY_LIST;
        }
        return applicationBeanConfig.getScreenConfigs();
    }

    public InstallerApplication getInstallerApplication() {
        return (InstallerApplication)this.getApplicationById("installer");
    }

    public UninstallerApplication getUninstallerApplication() {
        return (UninstallerApplication)this.getApplicationById("uninstaller");
    }

    public Application getApplicationById(String string) {
        ApplicationBeanConfig applicationBeanConfig = this.getApplicationConfigById(string);
        if (applicationBeanConfig != null) {
            return applicationBeanConfig.getOrInstantiateApplication(false);
        }
        return null;
    }

    public ApplicationBeanConfig getApplicationConfigById(String string) {
        return (ApplicationBeanConfig)this.applicationIdToConfig.get(string);
    }

    public ApplicationBeanConfig getCurrentApplicationConfig() {
        return (ApplicationBeanConfig)this.applicationIdToConfig.get(currentApplicationId);
    }

    public Map getClassNameToScriptClassOrigin() {
        return this.classNameToScriptClassOrigin;
    }

    public String getPublisherName() {
        return InstallerVariables.replaceVariables(this.publisherName);
    }

    public String getPublisherURL() {
        return InstallerVariables.replaceVariables(this.publisherURL);
    }

    public String getDownloadURL() {
        return InstallerVariables.replaceVariables(this.downloadURL);
    }

    public String getStatus() {
        return this.status;
    }

    public List getFilesets() {
        return this.filesets;
    }

    public List getComponents() {
        return this.components;
    }

    public ComponentConfig getComponentById(String string) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            if (!componentConfig.getId().equals(string)) continue;
            return componentConfig;
        }
        return null;
    }

    public ComponentFolderConfig getComponentRoot() {
        return this.componentRoot;
    }

    public List getLaunchers() {
        return this.launchers;
    }

    public LauncherConfig getLauncherConfigById(String string) {
        Iterator iterator = this.launchers.iterator();
        while (iterator.hasNext()) {
            LauncherConfig launcherConfig = (LauncherConfig)iterator.next();
            if (!launcherConfig.getId().equals(string) && !launcherConfig.getDisplayedId().equals(string)) continue;
            return launcherConfig;
        }
        return null;
    }

    public List getUninstallDeleteEntries() {
        return this.uninstallDeleteEntries;
    }

    public FileOptions getOptions(String string) {
        return this.fileOptionsConfig.getOptions(string);
    }

    public FileOptionsConfig getFileOptionsConfig() {
        return this.fileOptionsConfig;
    }

    public WindowsSpecificConfig getWindowsSpecificConfig() {
        return this.windowsSpecificConfig;
    }

    public MacSpecificConfig getMacSpecificConfig() {
        return this.macSpecificConfig;
    }

    public UnixSpecificConfig getUnixSpecificConfig() {
        return this.unixSpecificConfig;
    }

    public List getLanguages() {
        return this.languages;
    }

    public boolean isSkipLanguageSelection() {
        return this.skipLanguageSelection;
    }

    public boolean isLanguageSelectionInPrincipalLanguage() {
        return this.languageSelectionInPrincipalLanguage;
    }

    public LanguageConfig getLanguageById(String string) {
        Iterator iterator = this.languages.iterator();
        while (iterator.hasNext()) {
            LanguageConfig languageConfig = (LanguageConfig)iterator.next();
            if (!languageConfig.getId().equals(string)) continue;
            return languageConfig;
        }
        int n = string.indexOf(95);
        if (n > -1) {
            return this.getLanguageById(string.substring(0, n));
        }
        return null;
    }

    public Map getCompilerVariables() {
        return this.compilerVariables;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public int getInstallerType() {
        return this.installerType;
    }

    public String getAddonAppId() {
        return this.addonAppId;
    }

    public void setAddonAppId(String string) {
        this.addonAppId = string;
    }

    public boolean isSuggestPreviousLocations() {
        return this.suggestPreviousLocations;
    }

    public boolean isPack200Compression() {
        return this.pack200Compression;
    }

    public List getCustomJars() {
        return this.customJars;
    }

    public String getUninstallerPath() {
        return this.uninstallerPath;
    }

    public String getUninstallerDirectory() {
        return this.uninstallerDirectory;
    }

    protected void read(Element element) {
        this.install4jVersion = InstallerConfig.readAttribute(element, "install4jVersion", this.install4jVersion);
        this.install4jBuild = InstallerConfig.readAttribute(element, "install4jBuild", this.install4jBuild);
        this.type = InstallerConfig.readAttribute(element, "type", this.type);
        this.archive = InstallerConfig.readAttribute(element, "archive", this.archive);
        Element element2 = null;
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            String string = element3.getTagName();
            if (string.equals("general")) {
                element2 = element3;
                this.readGeneral(element3);
            } else if (string.equals("compilerVariables")) {
                this.compilerVariables = InstallerConfig.readVariables(element3);
            }
            if (this.readGeneralOnly) continue;
            if (string.equals("languages")) {
                this.readLanguages(element3);
                continue;
            }
            if (string.equals("externalRoots")) {
                this.readRoots(element3);
                continue;
            }
            if (string.equals("customCode")) {
                this.readCustomCode(element3);
                continue;
            }
            if (string.equals("applications")) {
                this.readScreens(element3);
                continue;
            }
            if (string.equals("scriptClassOrigins")) {
                this.readScriptClassOrigins(element3);
                continue;
            }
            if (string.equals("fileOptions")) {
                this.fileOptionsConfig.read(element3);
                continue;
            }
            if (string.equals("filesets")) {
                this.readFilesets(element3);
                continue;
            }
            if (string.equals("components")) {
                this.readComponents(element3);
                continue;
            }
            if (string.equals("launchers")) {
                this.readLaunchers(element3);
                continue;
            }
            if (string.equals("uninstallDelete")) {
                this.readUninstallDelete(element3);
                continue;
            }
            if (string.equals("windowsSpecific")) {
                this.windowsSpecificConfig.read(element3);
                continue;
            }
            if (string.equals("macSpecific")) {
                this.macSpecificConfig.read(element3);
                continue;
            }
            if (string.equals("unixSpecific")) {
                this.unixSpecificConfig.read(element3);
                continue;
            }
            if (!string.equals("uninstallerScreens")) continue;
            this.readLegacyUninstallerScreens(element3, element2);
        }
    }

    private void readLegacyUninstallerScreens(Element element, Element element2) {
        LegacyUninstallerBeanConfig legacyUninstallerBeanConfig = new LegacyUninstallerBeanConfig(element2);
        ((ApplicationBeanConfig)legacyUninstallerBeanConfig).read(element);
        this.applicationIdToConfig.put(legacyUninstallerBeanConfig.getId(), legacyUninstallerBeanConfig);
    }

    private void readCustomCode(Element element) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = InstallerConfig.readAttribute(element2, "name", (String)null);
            if (string == null) continue;
            linkedList.add(string);
        }
        this.customJars = Collections.unmodifiableList(linkedList);
    }

    private void readGeneral(Element element) {
        this.applicationName = InstallerConfig.readAttribute(element, "applicationName", this.applicationName);
        this.defaultInstallationDirectory = InstallerConfig.readAttribute(element, "defaultInstallationDirectory", this.defaultInstallationDirectory);
        this.status = InstallerConfig.readAttribute(element, "status", this.status);
        this.jreShared = InstallerConfig.readAttribute(element, "jreShared", this.jreShared);
        this.jreVersion = InstallerConfig.readAttribute(element, "jreVersion", this.jreVersion);
        this.minJavaVersion = InstallerConfig.readAttribute(element, "minJavaVersion", this.minJavaVersion);
        this.publisherName = InstallerConfig.readAttribute(element, "publisherName", this.publisherName);
        this.publisherURL = InstallerConfig.readAttribute(element, "publisherURL", this.publisherURL);
        this.mediaName = InstallerConfig.readAttribute(element, "mediaName", this.mediaName);
        this.applicationVersion = InstallerConfig.readAttribute(element, "applicationVersion", this.applicationVersion);
        this.lzmaCompression = InstallerConfig.readAttribute(element, "lzmaCompression", this.lzmaCompression);
        this.pack200Compression = InstallerConfig.readAttribute(element, "pack200Compression", this.pack200Compression);
        this.downloadURL = InstallerConfig.readAttribute(element, "downloadURL", this.downloadURL);
        this.mediaSetId = InstallerConfig.readAttribute(element, "mediaSetId", this.mediaSetId);
        this.applicationId = InstallerConfig.readAttribute(element, "applicationId", this.applicationId);
        this.installerType = InstallerConfig.readAttribute(element, "installerType", this.installerType);
        this.addonAppId = InstallerConfig.readAttribute(element, "addOnAppId", this.addonAppId);
        this.suggestPreviousLocations = InstallerConfig.readAttribute(element, "suggestPreviousLocations", this.suggestPreviousLocations);
        this.uninstallerPath = InstallerConfig.readFileAttribute(element, "uninstallerFilename", this.uninstallerPath);
        this.uninstallerDirectory = InstallerConfig.readFileAttribute(element, "uninstallerDirectory", this.uninstallerPath);
    }

    private void readLanguages(Element element) {
        this.skipLanguageSelection = InstallerConfig.readAttribute(element, "skipLanguageSelection", this.skipLanguageSelection);
        this.languageSelectionInPrincipalLanguage = InstallerConfig.readAttribute(element, "languageSelectionInPrincipalLanguage", this.languageSelectionInPrincipalLanguage);
        LinkedList<LanguageConfig> linkedList = new LinkedList<LanguageConfig>();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            LanguageConfig languageConfig = new LanguageConfig();
            languageConfig.read(element2);
            linkedList.add(languageConfig);
        }
        this.languages = Collections.unmodifiableList(linkedList);
    }

    private void readRoots(Element element) {
        this.externalRoots = new HashMap();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            RootConfig rootConfig = new RootConfig();
            rootConfig.read(element2);
            this.externalRoots.put(rootConfig.getId(), rootConfig);
        }
    }

    private void readScreens(Element element) {
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            ApplicationBeanConfig applicationBeanConfig = new ApplicationBeanConfig();
            applicationBeanConfig.read(element2);
            String string = "";
            if (applicationBeanConfig.getIdNamespace().length() > 0) {
                string = applicationBeanConfig.getIdNamespace() + ":";
            }
            String string2 = applicationBeanConfig.getId();
            String string3 = applicationBeanConfig.getDisplayedId();
            this.applicationIdToConfig.put(string + string2, applicationBeanConfig);
            if (string2.equals(string3)) continue;
            this.applicationIdToConfig.put(string + string3, applicationBeanConfig);
        }
    }

    private void readScriptClassOrigins(Element element) {
        this.classNameToScriptClassOrigin.clear();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            ScriptClassOrigin scriptClassOrigin = new ScriptClassOrigin();
            scriptClassOrigin.read(element2);
            this.classNameToScriptClassOrigin.put(scriptClassOrigin.getClassName(), scriptClassOrigin);
        }
    }

    private void readUninstallDelete(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = InstallerConfig.readAttribute(element2, "name", "");
            if (string.equals("")) continue;
            arrayList.add(string);
        }
        this.uninstallDeleteEntries = Collections.unmodifiableList(arrayList);
    }

    private void readFilesets(Element element) {
        this.filesets = new LinkedList();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            FilesetConfig filesetConfig = new FilesetConfig();
            filesetConfig.read(element2);
            this.filesets.add(filesetConfig);
        }
    }

    private void readComponents(Element element) {
        LinkedList linkedList = new LinkedList();
        this.componentRoot.read(element);
        this.collectComponents(this.componentRoot.getComponents(), linkedList);
        this.components = Collections.unmodifiableList(linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            componentConfig.notifyDependentComponents(this);
        }
    }

    private void collectComponents(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ComponentNodeConfig componentNodeConfig = (ComponentNodeConfig)iterator.next();
            if (componentNodeConfig instanceof ComponentConfig) {
                list2.add(componentNodeConfig);
                continue;
            }
            if (!(componentNodeConfig instanceof ComponentFolderConfig)) continue;
            this.collectComponents(((ComponentFolderConfig)componentNodeConfig).getComponents(), list2);
        }
    }

    private void readLaunchers(Element element) {
        LinkedList<LauncherConfig> linkedList = new LinkedList<LauncherConfig>();
        Iterator iterator = InstallerConfig.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.getTagName();
            if (!string.equals("launcher")) {
                return;
            }
            LauncherConfig launcherConfig = new LauncherConfig();
            launcherConfig.read(element2);
            linkedList.add(launcherConfig);
        }
        this.launchers = Collections.unmodifiableList(linkedList);
    }

    public String getTargetApplicationId() {
        if (this.isAddOnInstaller()) {
            return this.getAddonAppId();
        }
        return this.getApplicationId();
    }

    public String getFilesetForRootId(String string) {
        if (string.length() == 0) {
            return "";
        }
        RootConfig rootConfig = this.getRootById(string);
        return rootConfig.getFileset();
    }

    public RootConfig getRootById(String string) {
        return (RootConfig)this.externalRoots.get(string);
    }

    public boolean isAddOnInstaller() {
        return this.installerType == 2;
    }
}

