/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.actions.Action;
import com.install4j.api.actions.UninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Screen;
import com.install4j.api.screens.UninstallerScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WrapperUninstallerContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UninstallerContextImpl
extends ContextImpl
implements UninstallerContext {
    private Map idNamespaceToContext = new HashMap();

    public UninstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return UninstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            public void setVariable(Object object) {
            }
        });
    }

    public void applyToScreen(Screen screen, ScreenBeanConfig screenBeanConfig) {
        if (screen instanceof UninstallerScreen) {
            ((UninstallerScreen)screen).setUninstallerContext(this.getIdWrapperUninstallerContext(screenBeanConfig));
        }
    }

    public Context getIdWrapperContext(AbstractBeanConfig abstractBeanConfig) {
        return this.getIdWrapperUninstallerContext(abstractBeanConfig);
    }

    private UninstallerContext getIdWrapperUninstallerContext(AbstractBeanConfig abstractBeanConfig) {
        String string = abstractBeanConfig.getIdNamespace();
        if (string.length() == 0) {
            return this;
        }
        UninstallerContext uninstallerContext = (UninstallerContext)this.idNamespaceToContext.get(string);
        if (uninstallerContext == null) {
            uninstallerContext = new WrapperUninstallerContext(this, string);
            this.idNamespaceToContext.put(string, uninstallerContext);
        }
        return uninstallerContext;
    }

    public boolean performActionInt(ActionBeanConfig actionBeanConfig) throws UserCanceledException {
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        return ((UninstallAction)action).uninstall(this.getIdWrapperUninstallerContext(actionBeanConfig));
    }

    public void rollbackActionInt(ActionBeanConfig actionBeanConfig) {
    }

    public boolean isUninstallForUpgrade() {
        return Boolean.getBoolean("install4j.upgradeUninstall");
    }

    public boolean checkStart() {
        ClasspathModificator.addCustomJarsToClasspath(this);
        return super.checkStart();
    }

    public void finish(int n) {
        if (this.isUninstallForUpgrade()) {
            System.setProperty("install4j.noRebootDeletion", "true");
        }
        try {
            FileInstaller.getInstance().finishUninstall();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        super.finish(n);
    }

    protected String getRebootMessageId() {
        return "UninstalledAndNeedsRestart";
    }
}

