/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.UninstallerWizardScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.UninstallerConsoleScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.UninstallerUnattendedScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class Uninstaller {
    private Uninstaller() {
    }

    public static void main(String[] stringArray) {
        try {
            InstallerUtil.setInProcess(false);
            InstallerConfig.setCurrentApplicationId("uninstaller");
            ScreenExecutor screenExecutor = Uninstaller.getScreenExecutor(stringArray);
            new Controller(screenExecutor).start();
        }
        catch (Throwable throwable) {
            InstallerUtil.reportException(throwable);
            System.exit(1);
        }
    }

    private static ScreenExecutor getScreenExecutor(String[] stringArray) {
        ScreenExecutor screenExecutor;
        File file;
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(stringArray);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        try {
            file = new File(ResourceHelper.getRuntimeDir(), "..").getCanonicalFile();
        }
        catch (IOException iOException) {
            file = new File(ResourceHelper.getRuntimeDir(), "..").getAbsoluteFile();
        }
        installerConfig.setInstallationDirectory(file);
        ExecutionMode executionMode = InstallerUtil.getExecutionMode(commandLineOptions, true);
        if (executionMode == ExecutionMode.UNATTENDED || executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS) {
            screenExecutor = new UninstallerUnattendedScreenExecutor(commandLineOptions.quietOverwrite, commandLineOptions.wait, InstallerUtil.getSplash(commandLineOptions, executionMode));
        } else if (executionMode == ExecutionMode.CONSOLE) {
            screenExecutor = new UninstallerConsoleScreenExecutor();
        } else {
            final ScreenExecutor[] screenExecutorArray = new ScreenExecutor[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        screenExecutorArray[0] = new UninstallerWizardScreenExecutor();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            screenExecutor = screenExecutorArray[0];
        }
        InstallerVariables.initCommandLine(commandLineOptions.varFileName, commandLineOptions.commandLineVars);
        return screenExecutor;
    }
}

