/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.InstallerScreen;
import com.install4j.api.screens.Screen;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.InstallFilesAction;
import com.install4j.runtime.beans.actions.services.InstallServiceAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WrapperInstallerContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import com.install4j.runtime.installer.platform.unix.UnixFileSystem;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InstallerContextImpl
extends ContextImpl
implements InstallerContext {
    private static final String REGKEY_INSTALL4J = "SOFTWARE\\ej-technologies\\install4j\\";
    private static final String REGVAL_REBOOT_CHECK_FILE = "RebootCheckFile";
    private List autoUninstallActions = new ArrayList();
    private static final String LOG_FILE_NAME = "installation.log";
    public static final String RESPONSE_FILE_NAME = "response.varfile";
    private Map idNamespaceToContext = new HashMap();
    private Boolean updateInstallation;

    public InstallerContextImpl(ScreenExecutor screenExecutor) {
        super(screenExecutor);
        InstallerVariables.registerVariableProvider("sys.installationDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return InstallerContextImpl.this.getInstallationDirectory().getPath();
            }

            public void setVariable(Object object) {
                if (object != null && object instanceof String) {
                    InstallerContextImpl.this.setInstallationDirectory(new File((String)object), false);
                }
            }
        });
    }

    private static boolean isInstaller() {
        return InstallerConfig.getCurrentApplicationId().equals("installer");
    }

    public File getInstallerFile() {
        String string = System.getProperty("exe4j.moduleName");
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public String getMediaName() {
        return InstallerConfig.getCurrentInstance().getMediaName();
    }

    public void applyToScreen(Screen screen, ScreenBeanConfig screenBeanConfig) {
        if (screen instanceof InstallerScreen) {
            ((InstallerScreen)screen).setInstallerContext(this.getIdWrapperInstallerContext(screenBeanConfig));
        }
    }

    public Context getIdWrapperContext(AbstractBeanConfig abstractBeanConfig) {
        return this.getIdWrapperInstallerContext(abstractBeanConfig);
    }

    private InstallerContext getIdWrapperInstallerContext(AbstractBeanConfig abstractBeanConfig) {
        String string = abstractBeanConfig.getIdNamespace();
        if (string.length() == 0) {
            return this;
        }
        InstallerContext installerContext = (InstallerContext)this.idNamespaceToContext.get(string);
        if (installerContext == null) {
            installerContext = new WrapperInstallerContext(this, string);
            this.idNamespaceToContext.put(string, installerContext);
        }
        return installerContext;
    }

    public boolean installFile(File file, File file2) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return FileInstaller.getInstance().install(file, file2, fileOptions);
    }

    public void registerUninstallFile(File file) {
        FileInstaller.getInstance().registerUninstallFile(file);
    }

    public boolean installFile(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface, int n, int n2) throws UserCanceledException {
        if (progressInterface != null) {
            progressInterface = new ProgressAdapter(progressInterface, n, n2);
        }
        return FileInstaller.getInstance().install(file, file2, fileOptions, progressInterface);
    }

    public boolean performActionInt(ActionBeanConfig actionBeanConfig) throws UserCanceledException {
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        boolean bl = ((InstallAction)action).install(this.getIdWrapperInstallerContext(actionBeanConfig));
        if (bl && action instanceof AutoUninstallAction) {
            this.autoUninstallActions.add(action);
        }
        return bl;
    }

    public void rollbackActionInt(ActionBeanConfig actionBeanConfig) {
        ((InstallAction)actionBeanConfig.getOrInstantiateAction(false)).rollback(this.getIdWrapperInstallerContext(actionBeanConfig));
    }

    public String getLanguageId() {
        if (super.getLanguageId() == null) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            List list = installerConfig.getLanguages();
            if (list.size() == 1) {
                this.setLanguageId(((LanguageConfig)list.get(0)).getId());
            } else if (installerConfig.isSkipLanguageSelection() || this.isUnattended() || installerConfig.isArchive()) {
                String string = InstallerUtil.getSupportedSystemLanguageId();
                if (this.isUnattended() || installerConfig.isArchive()) {
                    string = ((LanguageConfig)InstallerConfig.getCurrentInstance().getLanguages().get(0)).getId();
                }
                if (string != null) {
                    this.setLanguageId(string);
                }
            }
        }
        return super.getLanguageId();
    }

    public boolean checkStart() {
        if (Util.isWindows() && InstallerContextImpl.isInstaller()) {
            if (this.checkReboot(RegistryRoot.HKEY_CURRENT_USER)) {
                return false;
            }
            if (this.checkReboot(RegistryRoot.HKEY_LOCAL_MACHINE)) {
                return false;
            }
        }
        return super.checkStart();
    }

    private boolean checkReboot(RegistryRoot registryRoot) {
        String string = (String)WinRegistry.getValue(registryRoot, REGKEY_INSTALL4J, REGVAL_REBOOT_CHECK_FILE);
        if (string != null) {
            if (new File(string).exists()) {
                String string2 = MessageFormat.format(Messages.getMessages().getString("PreviousInstallNotCompleted"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
                GUIHelper.showMessage(null, string2, 2);
                return true;
            }
            WinRegistry.deleteValue(registryRoot, REGKEY_INSTALL4J, REGVAL_REBOOT_CHECK_FILE);
        }
        return false;
    }

    public void finish(int n) {
        block8: {
            try {
                Object object;
                InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
                if (InstallerContextImpl.isInstaller()) {
                    object = null;
                    if (Util.isMacosInstaller() && installerConfig.getMacSpecificConfig().isSingleBundle()) {
                        object = installerConfig.getMacSpecificConfig().getSingleBundleName();
                    }
                    InstallRegistry.registerApplication(installerConfig.getApplicationId(), installerConfig.getInstallationDirectory(), (String)object);
                }
                if (((File)(object = this.getRuntimeDirectory())).exists()) {
                    String string;
                    if (InstallerContextImpl.isInstaller() && !Boolean.getBoolean("install4j.dontStoreInstallationLog")) {
                        this.getInstallationProperties().setLanguageId(this.getLanguageId());
                        this.writeInstallationProperties();
                        string = "";
                        if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
                            string = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
                        }
                        File file = new File((File)object, LOG_FILE_NAME + string);
                        File file2 = new File((File)object, RESPONSE_FILE_NAME + string);
                        Logger.getInstance().moveLogFile(file);
                        FileInstaller.getInstance().registerUninstallFile(file);
                        InstallerVariables.writeResponseFile(file2, null);
                        FileInstaller.getInstance().registerUninstallFile(file2);
                    }
                    AutoUninstallHandler.saveProperties(this.autoUninstallActions, (File)object);
                    FileInstaller.getInstance().setLogDir(this.getDestinationFile(".install4j"));
                    FileInstaller.getInstance().writeLog();
                    string = System.getProperty("install4j.runtimeAccessMode");
                    if (string != null && !Util.isWindows()) {
                        UnixFileSystem.setMode(string, (File)object, true);
                    }
                }
            }
            catch (IOException iOException) {
                if (!InstallerContextImpl.isInstaller() || this.getFirstAction(InstallFilesAction.class, null) == null) break block8;
                this.handleCriticalException(iOException);
            }
        }
        super.finish(n);
    }

    public void writeResponseFile() throws IOException {
        File file = this.getRuntimeDirectory();
        if (file.exists() && InstallerContextImpl.isInstaller() && !Boolean.getBoolean("install4j.dontStoreInstallationLog")) {
            String string = "";
            if (InstallerConfig.getCurrentInstance().isAddOnInstaller()) {
                string = "." + InstallerConfig.getCurrentInstance().getProjectCrc();
            }
            File file2 = new File(file, RESPONSE_FILE_NAME + string);
            InstallerVariables.writeResponseFile(file2, null);
        }
    }

    private void writeInstallationProperties() throws IOException {
        Object object;
        InstallationProperties installationProperties = this.getInstallationProperties();
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        ArrayList arrayList = new ArrayList(installerConfig.getFileOptionsConfig().getLaunchers());
        Iterator iterator = InstallServiceAction.getInstalledServices().iterator();
        while (iterator.hasNext()) {
            object = (InstallServiceAction.Info)iterator.next();
            arrayList.remove(((InstallServiceAction.Info)object).getExecutable());
            installationProperties.addStringToSet("serviceName", ((InstallServiceAction.Info)object).getServiceName());
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            installationProperties.addFileToSet("launcher", this.getDestinationFile((String)object));
        }
        installationProperties.store(this.getRuntimeDirectory());
    }

    public void setInstallationDirectory(File file) {
        this.setInstallationDirectory(file, true);
    }

    public boolean isUpdateInstallation() {
        if (this.updateInstallation == null) {
            this.updateInstallation = ApplicationRegistry.isUpdateDirectory(this.getInstallationDirectory());
        }
        return this.updateInstallation;
    }

    public void setInstallationDirectory(File file, boolean bl) {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        File file2 = installerConfig.getInstallationDirectory();
        installerConfig.setInstallationDirectory(file);
        this.updateInstallation = null;
        if (bl && !file2.equals(file)) {
            this.variableChanged("sys.installationDir");
        }
    }

    public File getExternalFile(ExternalFile externalFile, boolean bl) {
        if (bl || InstallerContextImpl.isDistributionExternal(externalFile)) {
            return super.getExternalFile(externalFile, bl);
        }
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        return externalFile.getAbsoluteFile();
    }

    protected String getRebootMessageId() {
        return "FinishedRestartMessage";
    }
}

