/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.LocalizedExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.UndefinedVariableException;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileInfo;
import com.install4j.api.context.FileSetSetup;
import com.install4j.api.context.InstallationComponentSetup;
import com.install4j.api.context.LauncherSetup;
import com.install4j.api.context.LauncherType;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.RemoteCallable;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.context.WizardContext;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.events.InstallerVariableEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.WrapperContext;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.FilesetConfig;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.LauncherConfig;
import com.install4j.runtime.installer.config.RootConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.Script;
import com.install4j.runtime.installer.helper.comm.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.ProcessCommunication;
import com.install4j.runtime.installer.helper.comm.Response;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.Misc;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.awt.EventQueue;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.SwingUtilities;

public abstract class ContextImpl
implements Context {
    protected ScreenExecutor screenExecutor;
    private InstallerConfig config;
    private List fileSetSetups = new ArrayList();
    private List installationComponentSetups = new ArrayList();
    private List launcherSetups = new ArrayList();
    private String languageId;
    private boolean languageInitialized = false;
    private InstallationProperties installationProperties;
    private boolean cancelling = false;
    private boolean askingForCancel = false;
    private final Object cancelWaiter = new Object();
    private static ContextImpl singleContextImpl;
    protected Set listeners = new HashSet();
    private Action currentAction;
    private boolean errorOccured = false;
    private Set hiddenVariables = new HashSet();
    private boolean shouldReboot = false;
    private boolean askUserForReboot = true;
    private List screenConfigsFlat;

    public static ContextImpl getContextImpl(Context context) {
        if (context instanceof ContextImpl) {
            return (ContextImpl)context;
        }
        if (context instanceof WrapperContext) {
            return ((WrapperContext)context).getParentContext();
        }
        return null;
    }

    public static boolean runBooleanScript(Context context, ScriptProperty scriptProperty, Bean bean, Object[] objectArray) {
        try {
            Boolean bl = (Boolean)context.runScript(scriptProperty, bean, objectArray);
            if (bl == null) {
                return true;
            }
            return bl;
        }
        catch (Exception exception) {
            Util.printAnnotatedStackTrace(exception);
            Logger.getInstance().log(exception);
            return false;
        }
    }

    protected abstract String getRebootMessageId();

    public static ContextImpl getSingleContextImpl() {
        return singleContextImpl;
    }

    public static void clearContext() {
        singleContextImpl = null;
    }

    private static void setSingleContextImpl(ContextImpl contextImpl) {
        if (singleContextImpl != null) {
            throw new UnsupportedOperationException("only one context impl can exist");
        }
        singleContextImpl = contextImpl;
    }

    public ContextImpl(ScreenExecutor screenExecutor) {
        Object object;
        Iterator iterator;
        Object object2;
        this.screenExecutor = screenExecutor;
        this.config = InstallerConfig.getCurrentInstance();
        List list = this.config.getFilesets();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (FilesetConfig)object3.next();
            iterator = new FileSetSetupImpl((FilesetConfig)object2);
            this.fileSetSetups.add(iterator);
        }
        object3 = this.config.getComponents();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            iterator = (ComponentConfig)object2.next();
            object = new InstallationComponentSetupImpl((ComponentConfig)((Object)iterator));
            this.installationComponentSetups.add(object);
        }
        object2 = this.config.getLaunchers();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (LauncherConfig)iterator.next();
            LauncherSetupImpl launcherSetupImpl = new LauncherSetupImpl((LauncherConfig)object);
            this.launcherSetups.add(launcherSetupImpl);
        }
        ContextImpl.setSingleContextImpl(this);
        this.addInstallerEventListener(Logger.getInstance());
        InstallerVariables.registerVariableProvider("sys.contentDir", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                return ContextImpl.this.getContentDirectory().getPath();
            }

            public void setVariable(Object object) {
            }
        });
    }

    public abstract void applyToScreen(Screen var1, ScreenBeanConfig var2);

    public abstract Context getIdWrapperContext(AbstractBeanConfig var1);

    protected abstract boolean performActionInt(ActionBeanConfig var1) throws UserCanceledException;

    protected abstract void rollbackActionInt(ActionBeanConfig var1);

    public List getScreenConfigs() {
        return this.config.getApplicationScreens();
    }

    public Map getId2BeanConfig() {
        return this.config.getCurrentApplicationConfig().getId2BeanConfig();
    }

    public Object runScript(ScriptProperty scriptProperty, Bean bean, Object[] objectArray) throws Exception {
        return this.runScript(scriptProperty, bean, objectArray, this);
    }

    public Object runScript(ScriptProperty scriptProperty, Bean bean, Object[] objectArray, Context context) throws Exception {
        if (scriptProperty != null && !scriptProperty.getValue().equals("")) {
            return ((Script)Class.forName(scriptProperty.getValue()).newInstance()).evaluate(context, bean, objectArray);
        }
        return null;
    }

    public boolean runBooleanScript(String string, Bean bean) {
        return this.runBooleanScript(string, bean, null);
    }

    public boolean runBooleanScript(String string, Bean bean, Object[] objectArray) {
        return ContextImpl.runBooleanScript(this, new ScriptProperty(string), bean, objectArray);
    }

    public File getDestinationFile(File file) {
        if (file == null) {
            return null;
        }
        return this.getDestinationFile(file.getPath());
    }

    public File getDestinationFile(String string) {
        if (string == null) {
            return null;
        }
        return this.getDestinationFileInfo(string).getDestinationFile();
    }

    public FileInfo getDestinationFileInfo(String string) {
        FileInfoImpl fileInfoImpl = new FileInfoImpl();
        fileInfoImpl.relativeFilePath = string;
        if (new File(string).isAbsolute()) {
            fileInfoImpl.rootUnresolved = "";
            return fileInfoImpl;
        }
        if (Util.isMacosInstaller() && string.startsWith(".install4j")) {
            fileInfoImpl.relativeFilePath = this.config.getMacSpecificConfig().getRuntimeDirParent() + string;
            return fileInfoImpl;
        }
        String string2 = string;
        if (this.config.getType().equals("macos") && this.config.getMacSpecificConfig().isSingleBundle()) {
            String string3 = this.config.getMacSpecificConfig().getRuntimeDirParent();
            if (string.startsWith(string3)) {
                string2 = string.substring(string3.length());
            } else if (!string.startsWith(this.config.getMacSpecificConfig().getSingleBundleName())) {
                fileInfoImpl.relativeFilePath = new File(string3, string).getPath();
            }
        }
        if (string2.startsWith(".i4j_external_")) {
            int n = string2.indexOf(47);
            if (n == -1) {
                n = string2.indexOf(92);
            }
            if (n != -1) {
                String string4 = string2.substring(".i4j_external_".length(), n);
                fileInfoImpl.relativeFilePath = string2.substring(n + 1);
                RootConfig rootConfig = this.config.getRootById(string4);
                fileInfoImpl.rootUnresolved = rootConfig.getLocation();
                if (fileInfoImpl.rootUnresolved != null && fileInfoImpl.rootUnresolved.trim().length() == 0 && this.config.getType().equals("macos") && this.config.getMacSpecificConfig().isSingleBundle()) {
                    String string5 = this.config.getMacSpecificConfig().getRuntimeDirParent();
                    fileInfoImpl.relativeFilePath = new File(string5, fileInfoImpl.relativeFilePath).getPath();
                }
                fileInfoImpl.filesetId = rootConfig.getFileset();
                return fileInfoImpl;
            }
        }
        return fileInfoImpl;
    }

    public String getLanguageId() {
        if (!this.languageInitialized) {
            String string;
            Object object;
            this.languageInitialized = true;
            String string2 = System.getProperty("install4j.language");
            if (string2 != null) {
                this.setLanguageId(string2);
            }
            if ((object = this.getVariable("sys.languageId")) != null && object instanceof String) {
                this.setLanguageId((String)object);
            }
            InstallerVariables.registerVariableProvider("sys.languageId", new InstallerVariables.VariableProvider(){

                public Object getVariable() {
                    return ContextImpl.this.getLanguageId();
                }

                public void setVariable(Object object) {
                }
            });
            this.registerResponseFileVariable("sys.languageId");
            if (this.languageId == null && !InstallerConfig.isInstaller() && (string = this.getInstallerLanguageId()) != null) {
                this.setLanguageId(string);
            }
        }
        return this.languageId;
    }

    public String getMessage(String string) throws MissingResourceException {
        return Messages.getMessages().getString(string);
    }

    public String getMessage(String string, Object[] objectArray) throws MissingResourceException {
        return MessageFormat.format(Messages.getMessages().getString(string), objectArray);
    }

    public void setLanguageId(String string) {
        if (this.config.getLanguageById(string) == null) {
            throw new RuntimeException("The language \"" + string + "\" is not available.");
        }
        this.languageId = string;
    }

    public File getInstallationDirectory() {
        return this.config.getInstallationDirectory();
    }

    public File getContentDirectory() {
        InstallerConfig installerConfig = this.config;
        if (installerConfig.getType().equals("macos") && installerConfig.getMacSpecificConfig().isSingleBundle()) {
            return new File(this.getInstallationDirectory(), installerConfig.getMacSpecificConfig().getRuntimeDirParent());
        }
        return this.getInstallationDirectory();
    }

    public File getResourceDirectory() {
        return InstallerUtil.getInstallerFile("user");
    }

    public Collection getLaunchers() {
        return this.launcherSetups;
    }

    public LauncherSetup getLauncherById(String string) {
        Iterator iterator = this.launcherSetups.iterator();
        while (iterator.hasNext()) {
            LauncherSetupImpl launcherSetupImpl = (LauncherSetupImpl)iterator.next();
            if (!launcherSetupImpl.getId().equals(string) && !launcherSetupImpl.getInternalId().equals(string)) continue;
            return launcherSetupImpl;
        }
        return null;
    }

    public Collection getFileSets() {
        return this.fileSetSetups;
    }

    public FileSetSetup getFileSetById(String string) {
        Iterator iterator = this.fileSetSetups.iterator();
        while (iterator.hasNext()) {
            FileSetSetupImpl fileSetSetupImpl = (FileSetSetupImpl)iterator.next();
            if (!fileSetSetupImpl.getId().equals(string) && !fileSetSetupImpl.getInternalId().equals(string)) continue;
            return fileSetSetupImpl;
        }
        return null;
    }

    public FileSetSetup getFileSetByName(String string) {
        Iterator iterator = this.fileSetSetups.iterator();
        while (iterator.hasNext()) {
            FileSetSetup fileSetSetup = (FileSetSetup)iterator.next();
            if (!fileSetSetup.getName().equals(string)) continue;
            return fileSetSetup;
        }
        return null;
    }

    public Collection getInstallationComponents() {
        return this.installationComponentSetups;
    }

    public InstallationComponentSetup getInstallationComponentById(String string) {
        Iterator iterator = this.installationComponentSetups.iterator();
        while (iterator.hasNext()) {
            InstallationComponentSetupImpl installationComponentSetupImpl = (InstallationComponentSetupImpl)iterator.next();
            if (!installationComponentSetupImpl.getId().equals(string) && !installationComponentSetupImpl.getInternalId().equals(string)) continue;
            return installationComponentSetupImpl;
        }
        return null;
    }

    public String getCompilerVariable(String string) {
        return (String)this.config.getCompilerVariables().get(string);
    }

    public boolean isUnattended() {
        return this.screenExecutor.isUnattended();
    }

    public boolean isConsole() {
        return this.screenExecutor.isConsole();
    }

    public String getApplicationId() {
        return this.config.getApplicationId();
    }

    public String getAddOnApplicationId() {
        return this.config.getAddonAppId();
    }

    public void goForward(int n, boolean bl, boolean bl2) {
        this.screenExecutor.getCommandSink().returnToController(new GoForwardCommand(n, bl, bl2, this.screenExecutor.getActionCallback()));
    }

    public void goBackInHistory(int n) {
        this.screenExecutor.getCommandSink().returnToController(new GoBackCommand(n, true));
    }

    public void goBack(int n) {
        this.screenExecutor.getCommandSink().returnToController(new GoBackCommand(n, false));
    }

    public void goBackInHistory(Screen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("parameter targetScreen must not be null");
        }
        this.screenExecutor.getCommandSink().returnToController(new GoBackInHistoryToScreenCommand(screen));
    }

    public void gotoScreen(Screen screen) {
        if (screen == null) {
            throw new IllegalArgumentException("parameter screen must not be null");
        }
        this.screenExecutor.getCommandSink().returnToController(new GotoScreenCommand(screen));
    }

    public WizardContext getWizardContext() {
        return this.screenExecutor.getWizardContext();
    }

    public Screen getScreenById(String string) {
        AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)this.getId2BeanConfig().get(string);
        if (abstractBeanConfig instanceof ScreenBeanConfig && abstractBeanConfig.isInstantiated()) {
            return ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false);
        }
        return null;
    }

    public Screen[] getScreens() {
        return this.getScreens(null);
    }

    public Screen getFirstScreen(Class clazz) {
        Screen[] screenArray = this.getScreens(clazz);
        if (screenArray.length > 0) {
            return screenArray[0];
        }
        return null;
    }

    public Screen[] getScreens(Class clazz) {
        ArrayList arrayList = new ArrayList();
        this.addScreens(clazz, arrayList, this.getScreenConfigs(), false);
        return arrayList.toArray(new Screen[arrayList.size()]);
    }

    public List getScreenConfigsFlat() {
        if (this.screenConfigsFlat == null) {
            this.screenConfigsFlat = new ArrayList();
            this.addScreens(null, this.screenConfigsFlat, this.getScreenConfigs(), true);
        }
        return this.screenConfigsFlat;
    }

    private void addScreens(Class clazz, List list, List list2, boolean bl) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            AbstractBeanConfig abstractBeanConfig2 = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig2 instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)abstractBeanConfig2;
                if (bl) {
                    if (clazz != null && (!((ScreenBeanConfig)abstractBeanConfig).isInstantiated() || ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false).getClass() != clazz)) continue;
                    list.add(abstractBeanConfig);
                    continue;
                }
                if (!((ScreenBeanConfig)abstractBeanConfig).isInstantiated() || clazz != null && ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false).getClass() != clazz) continue;
                list.add(((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false));
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)abstractBeanConfig2;
            this.addScreens(clazz, list, ((GroupBeanConfig)abstractBeanConfig).getBeanConfigs(), bl);
        }
    }

    public Action getActionById(String string) {
        AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)this.getId2BeanConfig().get(string);
        if (abstractBeanConfig instanceof ActionBeanConfig && abstractBeanConfig.isInstantiated()) {
            return ((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(false);
        }
        return null;
    }

    public Action[] getActions(Screen screen) {
        return this.getActions(null, screen);
    }

    public Action getFirstAction(Class clazz, Screen screen) {
        Action[] actionArray = this.getActions(clazz, screen);
        if (actionArray.length > 0) {
            return actionArray[0];
        }
        return null;
    }

    public Action[] getActions(Class clazz, Screen screen) {
        ArrayList arrayList = new ArrayList();
        this.addActionsFromScreenConfigs(clazz, screen, arrayList, this.getScreenConfigs());
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void addActionsFromScreenConfigs(Class clazz, Screen screen, ArrayList arrayList, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            AbstractBeanConfig abstractBeanConfig2 = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig2 instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)abstractBeanConfig2;
                if (screen != null && (!((ScreenBeanConfig)abstractBeanConfig).isInstantiated() || ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false) != screen)) continue;
                this.addActions(arrayList, ((ScreenBeanConfig)abstractBeanConfig).getActionConfigs(), clazz, false);
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)abstractBeanConfig2;
            this.addActionsFromScreenConfigs(clazz, screen, arrayList, ((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
    }

    public List getExecutableActionsStartingFrom(Class clazz, Screen screen) {
        boolean bl = screen == null;
        ArrayList arrayList = new ArrayList();
        this.addExectuableActionsFrom(clazz, screen, bl, arrayList, this.getScreenConfigs());
        return arrayList;
    }

    private boolean addExectuableActionsFrom(Class clazz, Screen screen, boolean bl, ArrayList arrayList, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            AbstractBeanConfig abstractBeanConfig2 = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig2 instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)abstractBeanConfig2;
                if (!bl && ((ScreenBeanConfig)abstractBeanConfig).isInstantiated() && ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false) == screen) {
                    bl = true;
                }
                if (!bl || ((ScreenBeanConfig)abstractBeanConfig).isInstantiated() && !this.runBooleanScript(abstractBeanConfig.getConditionClassName(), ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false))) continue;
                this.addActions(arrayList, ((ScreenBeanConfig)abstractBeanConfig).getActionConfigs(), clazz, true);
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)abstractBeanConfig2;
            if (!this.runBooleanScript(abstractBeanConfig.getConditionClassName(), ((GroupBeanConfig)abstractBeanConfig).getOrInstantiateGroup(false))) continue;
            bl = this.addExectuableActionsFrom(clazz, screen, bl, arrayList, ((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
        return bl;
    }

    private void addActions(ArrayList arrayList, List list, Class clazz, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            AbstractBeanConfig abstractBeanConfig2 = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig2 instanceof ActionBeanConfig) {
                abstractBeanConfig = (ActionBeanConfig)abstractBeanConfig2;
                if (!((ActionBeanConfig)abstractBeanConfig).isInstantiated() || clazz != null && ((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(false).getClass() != clazz) continue;
                Action action = ((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(false);
                if (bl && !this.runBooleanScript(abstractBeanConfig.getConditionClassName(), action)) continue;
                arrayList.add(action);
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)abstractBeanConfig2;
            if (bl && !this.runBooleanScript(abstractBeanConfig.getConditionClassName(), ((GroupBeanConfig)abstractBeanConfig).getOrInstantiateGroup(false))) continue;
            this.addActions(arrayList, ((GroupBeanConfig)abstractBeanConfig).getBeanConfigs(), clazz, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerScreens() {
        InstallerVariables.setReplaceInstallerVariables(false);
        try {
            List list = this.getScreenConfigs();
            this.registerScreens(list);
            AbstractBeanConfig.finishBatch();
            this.initAllActions(list);
            this.registerScreenConfigs(list);
        }
        finally {
            InstallerVariables.setReplaceInstallerVariables(true);
        }
    }

    private void registerScreenConfigs(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof ScreenBeanConfig) {
                Screen screen;
                abstractBeanConfig = (ScreenBeanConfig)e;
                if (!((ScreenBeanConfig)abstractBeanConfig).isInstantiated() || (screen = ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(false)) == null) continue;
                this.screenExecutor.register(screen, (ScreenBeanConfig)abstractBeanConfig);
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            this.registerScreenConfigs(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
    }

    private void initAllActions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)e;
                this.initActionsForSingleScreen(((ScreenBeanConfig)abstractBeanConfig).getActionConfigs());
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            this.initAllActions(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
    }

    private void registerScreens(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)e;
                abstractBeanConfig.batchInstantiate();
                this.registerActions(((ScreenBeanConfig)abstractBeanConfig).getActionConfigs());
                this.registerFormComponents(((ScreenBeanConfig)abstractBeanConfig).getFormComponentConfigs());
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            abstractBeanConfig.batchInstantiate();
            this.registerScreens(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
    }

    private void registerFormComponents(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof FormComponentBeanConfig) {
                abstractBeanConfig = (FormComponentBeanConfig)e;
                abstractBeanConfig.batchInstantiate();
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            abstractBeanConfig.batchInstantiate();
        }
    }

    private void initActionsForSingleScreen(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof ActionBeanConfig) {
                Action action;
                abstractBeanConfig = (ActionBeanConfig)e;
                if (((ActionBeanConfig)abstractBeanConfig).isInitialized() || (action = ((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(true)) == null) continue;
                action.init(this.getIdWrapperContext(abstractBeanConfig));
                ((ActionBeanConfig)abstractBeanConfig).setInitialized(true);
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            this.initActionsForSingleScreen(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
    }

    private void registerActions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof ActionBeanConfig) {
                abstractBeanConfig = (ActionBeanConfig)e;
                abstractBeanConfig.batchInstantiate();
                continue;
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            this.registerActions(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs());
        }
    }

    public ProgressInterface getProgressInterface() {
        return this.screenExecutor.getProgressInterface();
    }

    public ProgressInterface getDefaultProgressInterface() {
        return this.screenExecutor.getDefaultProgressInterface();
    }

    public void setCancelling() {
        this.cancelling = true;
        this.setAskingForCancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelling() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object object = this.cancelWaiter;
            synchronized (object) {
                if (this.askingForCancel) {
                    try {
                        this.cancelWaiter.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }
        return this.cancelling;
    }

    protected void cleanup() {
        Logger.getInstance().info(null, "cleaning up");
        ProgressInterface progressInterface = this.getProgressInterface();
        progressInterface.setStatusMessage(Messages.getMessages().getString(this instanceof UninstallerContext ? "UninstallerFinish" : "StatusRunProgram"));
        progressInterface.setPercentCompleted(0);
        progressInterface.setDetailMessage(" ");
        FileInstaller.getInstance().cleanup(progressInterface);
        ContentInstaller.getInstance().cleanup();
        if (InstallerUtil.isWindows()) {
            ShellLink.uninitialize();
        }
    }

    public void handleCriticalException(Throwable throwable) {
        InstallerUtil.reportException(throwable);
        this.cleanup();
        this.immediateExit(1);
    }

    protected final String getInstallerLanguageId() {
        return this.getInstallationProperties().getLanguageId();
    }

    public InstallationProperties getInstallationProperties() {
        if (this.installationProperties == null) {
            this.installationProperties = new InstallationProperties(this.getRuntimeDirectory());
        }
        return this.installationProperties;
    }

    public void setRollback() {
        this.screenExecutor.setRollback();
        this.shouldReboot = false;
    }

    public void finish(int n) {
        this.cleanup();
        this.fireInstallerEvent(new InstallerEvent(this, this, EventType.FINISHED));
        this.exit(n);
    }

    public boolean hasBeenElevated() {
        return ProcessCommunication.getInstance().isElevatedAndApplicable();
    }

    public boolean runBooleanActivityWithFallback(RemoteCallable remoteCallable) {
        boolean bl;
        try {
            bl = (Boolean)remoteCallable.execute();
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            return true;
        }
        if (Util.hasFullAdminRights()) {
            return false;
        }
        try {
            Serializable serializable = this.runElevated(remoteCallable, false);
            return serializable instanceof Boolean && (Boolean)serializable != false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Serializable runElevated(RemoteCallable remoteCallable, boolean bl) {
        return ContextImpl.runElevatedInt(remoteCallable, bl);
    }

    public static Serializable runElevatedInt(RemoteCallable remoteCallable, boolean bl) {
        ProcessCommunication processCommunication = ProcessCommunication.getInstance();
        if (processCommunication.isUnelevatedAndApplicable()) {
            RemoteResponse remoteResponse = (RemoteResponse)processCommunication.sendAction(new RemoteAction(remoteCallable));
            if (remoteResponse != null) {
                return remoteResponse.getReturnedObject();
            }
        } else if (bl || Util.hasFullAdminRights()) {
            return remoteCallable.execute();
        }
        return null;
    }

    public Serializable runUnelevated(RemoteCallable remoteCallable) {
        return ContextImpl.runUnelevatedInt(remoteCallable, true);
    }

    public void initializeLazilyCreatedScreens() {
        this.screenExecutor.initializeLazilyLoadedScreens();
    }

    public void addToClassPath(File file) {
        ClasspathModificator.addClassPath(file);
    }

    public static Serializable runUnelevatedInt(RemoteCallable remoteCallable, boolean bl) {
        ProcessCommunication processCommunication = ProcessCommunication.getInstance();
        if (processCommunication != null && processCommunication.isElevatedAndApplicable()) {
            RemoteResponse remoteResponse = (RemoteResponse)processCommunication.sendAction(new RemoteAction(remoteCallable));
            if (remoteResponse != null) {
                return remoteResponse.getReturnedObject();
            }
        } else if (bl) {
            return remoteCallable.execute();
        }
        return null;
    }

    public boolean checkStart() {
        Iterator iterator = this.installationComponentSetups.iterator();
        while (iterator.hasNext()) {
            InstallationComponentSetupImpl installationComponentSetupImpl = (InstallationComponentSetupImpl)iterator.next();
            installationComponentSetupImpl.initVariable();
        }
        return InstallerUtil.checkJavaVersion();
    }

    public Object getVariable(String string) {
        return InstallerVariables.getVariable(string);
    }

    public boolean getBooleanVariable(String string) {
        return Boolean.TRUE.equals(this.getVariable(string));
    }

    public void setVariable(String string, Object object) {
        InstallerVariables.setVariable(string, object);
        this.variableChanged(string);
    }

    protected void variableChanged(String string) {
        this.fireInstallerEvent(new InstallerVariableEvent((Object)this, (Context)this, string));
    }

    public Set getVariableNames() {
        return InstallerVariables.getVariableNames();
    }

    public void registerResponseFileVariable(String string) {
        InstallerVariables.registerResponseFileVariable(string);
    }

    public void registerHiddenVariable(String string) {
        this.hiddenVariables.add(string);
    }

    public Set getHiddenVariables() {
        return this.hiddenVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAskingForCancel(boolean bl) {
        Object object = this.cancelWaiter;
        synchronized (object) {
            this.askingForCancel = bl;
            if (!bl) {
                this.cancelWaiter.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performAction(ActionBeanConfig actionBeanConfig) throws UserCanceledException {
        Action action = actionBeanConfig.getOrInstantiateAction(false);
        boolean bl = false;
        try {
            this.currentAction = action;
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.BEFORE_EXECUTE_ACTION));
            boolean bl2 = bl = this.performActionInt(actionBeanConfig);
            return bl2;
        }
        catch (UserCanceledException userCanceledException) {
            throw userCanceledException;
        }
        catch (Exception exception) {
            InstallerUtil.reportException(exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.fireInstallerEvent(new InstallerEvent(action, this, EventType.AFTER_EXECUTE_ACTION, bl));
            this.currentAction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackAction(ActionBeanConfig actionBeanConfig) {
        try {
            this.currentAction = actionBeanConfig.getOrInstantiateAction(false);
            this.fireInstallerEvent(new InstallerEvent(this.currentAction, this, EventType.BEFORE_ROLLBACK_ACTION));
            this.rollbackActionInt(actionBeanConfig);
        }
        finally {
            this.fireInstallerEvent(new InstallerEvent(this.currentAction, this, EventType.AFTER_ROLLBACK_ACTION));
            this.currentAction = null;
        }
    }

    public void fireInstallerEvent(InstallerEvent installerEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            InstallerEventListener installerEventListener = (InstallerEventListener)iterator.next();
            installerEventListener.installerEvent(installerEvent);
        }
    }

    public void addInstallerEventListener(InstallerEventListener installerEventListener) {
        this.listeners.add(installerEventListener);
    }

    public void removeInstallerEventListener(InstallerEventListener installerEventListener) {
        this.listeners.remove(installerEventListener);
    }

    public Object getEventSource() {
        if (this.currentAction != null) {
            return this.currentAction;
        }
        return this;
    }

    public File getExternalFile(ExternalFile externalFile, boolean bl) {
        if (externalFile == null || externalFile.getPath().trim().length() == 0) {
            return null;
        }
        if (ContextImpl.isDistributionExternal(externalFile)) {
            return InstallerVariables.replaceVariables(externalFile);
        }
        return new File(this.getRuntimeDirectory(), externalFile.getPath());
    }

    public File getExternalFile(LocalizedExternalFile localizedExternalFile, boolean bl) {
        if (localizedExternalFile == null) {
            return null;
        }
        Map map = localizedExternalFile.getLanguageIdToExternalFile();
        ExternalFile externalFile = (ExternalFile)map.get(this.languageId);
        if (externalFile == null) {
            String string = ((LanguageConfig)this.config.getLanguages().get(0)).getId();
            externalFile = (ExternalFile)map.get(string);
        }
        return this.getExternalFile(externalFile, bl);
    }

    protected static boolean isDistributionExternal(ExternalFile externalFile) {
        return externalFile != null && externalFile.getPath().trim().startsWith("${");
    }

    public final File getRuntimeDirectory() {
        return this.getDestinationFile(".install4j");
    }

    public void setErrorOccurred(boolean bl) {
        this.errorOccured = bl;
    }

    public boolean isErrorOccurred() {
        return this.errorOccured;
    }

    public void closeWindows() {
        Runnable runnable = new Runnable(){

            public void run() {
                ContextImpl.this.screenExecutor.closeWindows();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void immediateExit(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                System.out.flush();
                System.err.flush();
                ProcessCommunication.getInstance().terminateReceiver(n);
                if (InstallerUtil.isInProcess()) {
                    ContextImpl.this.screenExecutor.closeWindows();
                }
                InstallerUtil.exit(n);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void exit(final int n) {
        Runnable runnable = new Runnable(){

            public void run() {
                ContextImpl.this.screenExecutor.closeWindows();
                if (!ContextImpl.this.checkReboot()) {
                    ContextImpl.this.waitForFinishExecutable();
                }
                ProcessCommunication.getInstance().terminateReceiver(n);
                InstallerUtil.exit(n);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void waitForFinishExecutable() {
        long l;
        if (Util.isWindows() || Util.isMacOS()) {
            return;
        }
        long l2 = LaunchHelper.getLastLaunchTime();
        if (l2 != 0L && (l = System.currentTimeMillis() - l2) < 10000L) {
            try {
                Thread.sleep(10000L - l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void triggerReboot(boolean bl) {
        this.shouldReboot = true;
        if (!bl) {
            this.askUserForReboot = false;
        }
    }

    public boolean isRebootRequired() {
        return this.shouldReboot;
    }

    private static void doReboot() {
        if (WinDel.isUsed()) {
            WinDel.setReboot(true);
        } else {
            Misc.reboot();
        }
    }

    private boolean checkReboot() {
        ResourceBundle resourceBundle = Messages.getMessages();
        String string = MessageFormat.format(resourceBundle.getString(this.getRebootMessageId()), this.config.getApplicationName());
        if (!this.isUnattended() && !this.isConsole()) {
            WinDel.setRebootMessage(string, resourceBundle.getString("ErrorRestartingComputer"));
        }
        if (InstallerUtil.isWindows() && this.shouldReboot) {
            if (this.isUnattended() || !this.askUserForReboot) {
                if (this.isUnattended() && Boolean.getBoolean("install4j.suppressUnattendedReboot")) {
                    return false;
                }
                ContextImpl.doReboot();
                return true;
            }
            try {
                int n = GUIHelper.showOptionDialog(null, string, new String[]{resourceBundle.getString("ButtonYes"), resourceBundle.getString("ButtonNo")}, 3);
                if (n == 0) {
                    ContextImpl.doReboot();
                    return true;
                }
                WinDel.setRebootMessage("", "");
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
        }
        return false;
    }

    public class FileInfoImpl
    implements FileInfo {
        private String rootUnresolved;
        private String relativeFilePath;
        private String filesetId = "";

        public File getDestinationFile() {
            String string = this.getRootResolvedString();
            if (string == null) {
                return null;
            }
            if (string.equals("")) {
                File file = new File(this.relativeFilePath);
                if (file.isAbsolute()) {
                    return file;
                }
                return new File(ContextImpl.this.getInstallationDirectory().getAbsoluteFile(), this.relativeFilePath);
            }
            return new File(string, this.relativeFilePath);
        }

        public String getRootUnresolved() {
            return this.rootUnresolved;
        }

        public File getRootResolved() {
            String string = this.getRootResolvedString();
            if (string == null) {
                return null;
            }
            if (string.equals("") && !new File(this.relativeFilePath).isAbsolute()) {
                return ContextImpl.this.getInstallationDirectory().getAbsoluteFile();
            }
            return new File(string);
        }

        private String getRootResolvedString() {
            if (this.rootUnresolved == null) {
                return ContextImpl.this.getInstallationDirectory().getAbsolutePath();
            }
            try {
                return InstallerVariables.replaceVariables(this.rootUnresolved).replace('/', File.separatorChar).replace('\\', File.separatorChar);
            }
            catch (UndefinedVariableException undefinedVariableException) {
                return null;
            }
        }

        public String getRelativeFilePath() {
            return this.relativeFilePath;
        }

        public String getFilesetId() {
            return this.filesetId;
        }

        public String getFilesetName() {
            if (this.filesetId == null || this.filesetId.length() == 0) {
                return "";
            }
            FileSetSetup fileSetSetup = ContextImpl.this.getFileSetById(this.filesetId);
            if (fileSetSetup == null) {
                return null;
            }
            return fileSetSetup.getName();
        }
    }

    private class FileSetSetupImpl
    implements FileSetSetup {
        private FilesetConfig filesetConfig;

        public FileSetSetupImpl(FilesetConfig filesetConfig) {
            this.filesetConfig = filesetConfig;
        }

        public boolean isSelected() {
            return this.filesetConfig.isSelected();
        }

        public void setSelected(boolean bl) {
            this.filesetConfig.setSelected(bl);
        }

        public String getName() {
            return this.filesetConfig.getName();
        }

        public String getId() {
            return this.filesetConfig.getDisplayedId();
        }

        public String getInternalId() {
            return this.filesetConfig.getId();
        }
    }

    public static class InstallationComponentSetupImpl
    implements InstallationComponentSetup {
        public static final String VARIABLE_PREFIX = "sys.component.";
        private ComponentConfig componentConfig;

        public InstallationComponentSetupImpl(ComponentConfig componentConfig) {
            this.componentConfig = componentConfig;
        }

        public boolean isSelected() {
            return this.componentConfig.isSelected();
        }

        public void setSelected(boolean bl) {
            this.componentConfig.setSelected(bl);
        }

        public boolean isChangeable() {
            return this.componentConfig.isChangeable();
        }

        public void setChangeable(boolean bl) {
            this.componentConfig.setChangeable(bl);
        }

        public boolean isHidden() {
            return this.componentConfig.isHidden();
        }

        public void setHidden(boolean bl) {
            this.componentConfig.setHidden(bl);
        }

        public String getName() {
            return this.componentConfig.getName();
        }

        public String getId() {
            return this.componentConfig.getDisplayedId();
        }

        public boolean isDownloaded() {
            return this.componentConfig.isDownloaded();
        }

        public String getInternalId() {
            return this.componentConfig.getId();
        }

        public void initVariable() {
            String string = VARIABLE_PREFIX + this.getId();
            Object object = InstallerVariables.getVariable(string);
            if (object != null && object instanceof Boolean) {
                this.setSelected((Boolean)object);
            }
            InstallerVariables.registerVariableProvider(string, new InstallerVariables.VariableProvider(){

                public Object getVariable() {
                    return InstallationComponentSetupImpl.this.isSelected();
                }

                public void setVariable(Object object) {
                    if (object != null && object instanceof Boolean) {
                        InstallationComponentSetupImpl.this.setSelected((Boolean)object);
                    }
                }
            });
            InstallerVariables.registerResponseFileVariable(string);
        }
    }

    public static class LauncherSetupImpl
    implements LauncherSetup {
        private LauncherConfig launcherConfig;

        public LauncherSetupImpl(LauncherConfig launcherConfig) {
            this.launcherConfig = launcherConfig;
        }

        public String getRelativeFileName() {
            if (InstallerUtil.isWindows()) {
                return this.launcherConfig.getFile().replace('/', '\\');
            }
            return this.launcherConfig.getFile().replace('\\', '/');
        }

        public String getId() {
            return this.launcherConfig.getDisplayedId();
        }

        public String getInternalId() {
            return this.launcherConfig.getId();
        }

        public LauncherType getType() {
            return this.launcherConfig.getType();
        }

        public String getName() {
            return this.launcherConfig.getName();
        }

        public boolean isExcludeFromMenu() {
            return this.launcherConfig.isExcludeFromMenu();
        }

        public boolean isUninstaller() {
            return this.launcherConfig.isUninstaller();
        }

        public LauncherConfig getLauncherConfig() {
            return this.launcherConfig;
        }
    }

    private static class RemoteAction
    implements CommunicationAction {
        private RemoteCallable remoteCallable;

        private RemoteAction(RemoteCallable remoteCallable) {
            this.remoteCallable = remoteCallable;
        }

        public Response execute(ProcessCommunication processCommunication) {
            Logger.getInstance().info(null, "executing " + this.remoteCallable);
            Serializable serializable = null;
            try {
                serializable = this.remoteCallable.execute();
            }
            catch (Throwable throwable) {
                Logger.getInstance().log(throwable);
                return new RemoteResponse(false, serializable);
            }
            return new RemoteResponse(true, serializable);
        }
    }

    public static class RemoteResponse
    extends Response {
        private Serializable returnedObject;

        public RemoteResponse(boolean bl, Serializable serializable) {
            super(bl);
            this.returnedObject = serializable;
        }

        public Serializable getReturnedObject() {
            return this.returnedObject;
        }
    }
}

