/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.util.StringUtil;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Application {
    public static void main(String[] stringArray) {
        InstallerUtil.setInProcess(false);
        if (stringArray.length == 0) {
            System.err.println("Please provide the application id as first argument");
            System.exit(1);
        }
        String string = stringArray[0];
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        InstallerConfig.setCurrentApplicationId(string);
        Application.runApplication(stringArray2, false, null);
    }

    public static void runApplicationInProcess(String string, String[] stringArray, boolean bl, Window window) {
        FileInstaller.clearFileInstaller();
        InstallerConfig.clearCurrentApplication();
        InstallerConfig.setCurrentApplicationId(string);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringUtil.splitupCommandLine(arrayList, InstallerConfig.getCurrentApplication().getArguments());
        arrayList.addAll(Arrays.asList(stringArray));
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        Application.runApplication(stringArray, bl, window);
    }

    private static void runApplication(String[] stringArray, boolean bl, Window window) {
        try {
            ScreenExecutor screenExecutor = Installer.getScreenExecutor(stringArray, bl, window);
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            File file = new File(ResourceHelper.getRuntimeDir(), "..");
            if (Util.isMacOS() && installerConfig.getMacSpecificConfig().isSingleBundle()) {
                file = new File(file, "../../../..");
            }
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file = file.getAbsoluteFile();
            }
            installerConfig.setInstallationDirectory(file);
            if (screenExecutor != null) {
                ClasspathModificator.addCustomJarsToClasspath(screenExecutor.getContext());
            }
            new Controller(screenExecutor).start();
        }
        catch (Throwable throwable) {
            InstallerUtil.reportException(throwable);
            InstallerUtil.exit(1);
        }
    }
}

