/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.IndeterminateStateDisplay;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.VistaWorkaroundCheckbox;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import javax.swing.ButtonModel;

public class ComponentCheckBox
extends VistaWorkaroundCheckbox
implements IndeterminateStateDisplay {
    private boolean indeterminate;
    private InternalCheckBox indeterminateCheckbox;
    private float alpha;

    public ComponentCheckBox() {
        this.setOpaque(false);
        this.indeterminateCheckbox = new InternalCheckBox();
        this.indeterminateCheckbox.setOpaque(false);
        this.model.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ComponentCheckBox.this.indeterminate && !ComponentCheckBox.this.model.isSelected()) {
                    ComponentCheckBox.this.indeterminate = false;
                    ComponentCheckBox.this.setSelected(true);
                }
                ComponentCheckBox.this.indeterminate = false;
            }
        });
        if (InstallerUtil.isMacOS() || GUIHelper.isWindowsLaF() && this.isXP()) {
            this.initDisabled(0.5f);
        } else {
            this.initArmed();
        }
    }

    private void initDisabled(float f) {
        this.alpha = f;
        this.indeterminateCheckbox.setEnabled(false);
    }

    private void initArmed() {
        this.alpha = 1.0f;
        ButtonModel buttonModel = this.indeterminateCheckbox.getModel();
        buttonModel.setArmed(true);
        buttonModel.setPressed(true);
    }

    private boolean isXP() {
        if (System.getProperty("swing.noxp") != null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            Method method = clazz.getMethod("isClassicWindows", null);
            return (Boolean)method.invoke(null, null) == false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setSelected(boolean bl) {
        this.indeterminate = false;
        super.setSelected(bl);
    }

    public void setIndeterminate(boolean bl) {
        this.indeterminate = bl;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.indeterminate && this.model.isEnabled() && !this.model.isArmed()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
            this.indeterminateCheckbox.setBounds(this.getBounds());
            this.indeterminateCheckbox.paintComponent(graphics);
            graphics2D.setComposite(composite);
        }
    }

    private static class InternalCheckBox
    extends VistaWorkaroundCheckbox {
        public InternalCheckBox() {
            this.setSelected(true);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }

        public synchronized void addMouseListener(MouseListener mouseListener) {
        }
    }
}

