/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.frontend.components.DirectorySelector;
import com.install4j.runtime.installer.frontend.components.ProgramGroupSelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StandardProgramGroupScreen
extends SystemScreen {
    private boolean programGroupEnabled = true;
    private String programGroupName = "";
    private boolean allUsers = true;
    private boolean unixSymlinks = true;
    private String linkDirectory = "/usr/local/bin";
    private boolean allowUserChangeEnabled = true;
    private boolean allowUserChangeAllUsers = true;
    private boolean showWarningIfExists = false;

    public StandardProgramGroupScreen() {
        InstallerVariables.registerResponseFileVariable("sys.programGroupDisabled");
        if (InstallerUtil.isWindows()) {
            InstallerVariables.registerResponseFileVariable("sys.programGroupName");
            InstallerVariables.registerResponseFileVariable("sys.programGroupAllUsers");
        } else {
            InstallerVariables.registerResponseFileVariable("sys.symlinkDir");
        }
    }

    public boolean isProgramGroupEnabled() {
        return this.programGroupEnabled;
    }

    public void setProgramGroupEnabled(boolean bl) {
        this.programGroupEnabled = bl;
    }

    public String getProgramGroupName() {
        return StandardProgramGroupScreen.replaceVariables(this.programGroupName);
    }

    public void setProgramGroupName(String string) {
        this.programGroupName = string;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }

    public String getLinkDirectory() {
        return StandardProgramGroupScreen.replaceVariables(this.linkDirectory);
    }

    public boolean isUnixSymlinks() {
        return this.unixSymlinks;
    }

    public void setUnixSymlinks(boolean bl) {
        this.unixSymlinks = bl;
    }

    public void setLinkDirectory(String string) {
        this.linkDirectory = string;
    }

    public boolean isAllowUserChangeEnabled() {
        return this.allowUserChangeEnabled;
    }

    public void setAllowUserChangeEnabled(boolean bl) {
        this.allowUserChangeEnabled = bl;
    }

    public boolean isAllowUserChangeAllUsers() {
        return this.allowUserChangeAllUsers;
    }

    public void setAllowUserChangeAllUsers(boolean bl) {
        this.allowUserChangeAllUsers = bl;
    }

    public boolean isShowWarningIfExists() {
        return this.showWarningIfExists;
    }

    public void setShowWarningIfExists(boolean bl) {
        this.showWarningIfExists = bl;
    }

    protected SystemScreen.DefaultPanel createPanel() {
        if (Util.isWindowsInstaller()) {
            return new WindowsPanel();
        }
        return new UnixPanel();
    }

    public boolean isHidden() {
        boolean bl;
        boolean bl2 = Util.isWindowsInstaller() || Util.isUnixInstaller();
        boolean bl3 = Util.isUnixInstaller() && !this.isUnixSymlinks();
        boolean bl4 = bl = !bl2 || bl3;
        if (bl) {
            this.getContext().setVariable("sys.programGroupDisabled", Boolean.TRUE);
        }
        return bl;
    }

    public void willActivate() {
        super.willActivate();
        this.getPanel().willActivate();
    }

    public void activated() {
        super.activated();
        this.getPanel().activated();
    }

    public boolean next() {
        return this.getPanel().next() && super.next();
    }

    protected boolean checkCompleted() {
        return this.getPanel().checkCompleted() && super.checkCompleted();
    }

    public String getTitle() {
        return Util.isWindowsInstaller() ? this.getMessage("WizardSelectProgramGroup") : this.getMessage("WizardSelectLinkDir");
    }

    public String getSubTitle() {
        return Util.isWindowsInstaller() ? this.getMessage("SelectStartMenuFolderDesc") : MessageFormat.format(this.getMessage("SelectLinkDirDesc"), this.getApplicationName());
    }

    public boolean isFillVertical() {
        return Util.isWindowsInstaller();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        Context context = this.getContext();
        boolean bl = InstallerUtil.isWindows();
        if (this.allowUserChangeEnabled) {
            boolean bl2 = console.askYesNo(this.getMessage(bl ? "ConsoleProgramGroupCheck" : "ConsoleSymlinksCheck"), this.isProgramGroupEnabledOverridden(context));
            context.setVariable("sys.programGroupDisabled", !bl2);
            if (!bl2) {
                return true;
            }
        }
        if (bl) {
            String string;
            Boolean bl3 = null;
            do {
                string = console.askString(this.getMessage("SelectStartMenuFolderDesc"), this.getProgramGroupNameOverridden(context));
                if (!Util.hasFullAdminRights() || !this.allowUserChangeAllUsers) continue;
                bl3 = console.askYesNo(this.getMessage("ProgramGroupAllUsers"), this.isAllUsersOverridden(context));
            } while (!ProgramGroupSelector.checkProgramGroup(string, bl3 != null ? bl3.booleanValue() : this.isAllUsersOverridden(context), this.showWarningIfExists, null));
            context.setVariable("sys.programGroupName", string);
            if (bl3 != null) {
                context.setVariable("sys.programGroupAllUsers", bl3);
            }
        } else {
            context.setVariable("sys.symlinkDir", console.askString(MessageFormat.format(this.getMessage("SelectLinkDirLabel"), this.getApplicationName()), this.getLinkDirectoryOverridden(context)));
        }
        return true;
    }

    public boolean handleUnattended() {
        if (!super.handleUnattended()) {
            return false;
        }
        Context context = this.getContext();
        if (this.allowUserChangeEnabled) {
            boolean bl = this.isProgramGroupEnabledOverridden(context);
            context.setVariable("sys.programGroupDisabled", !bl);
            if (!bl) {
                return true;
            }
        }
        if (InstallerUtil.isWindows()) {
            context.setVariable("sys.programGroupName", this.getProgramGroupNameOverridden(context));
            context.setVariable("sys.programGroupAllUsers", this.isAllUsersOverridden(context));
        } else {
            context.setVariable("sys.symlinkDir", this.getLinkDirectoryOverridden(context));
        }
        return true;
    }

    private boolean isProgramGroupEnabledOverridden(Context context) {
        Object object = context.getVariable("sys.programGroupDisabled");
        boolean bl = object == null || !(object instanceof Boolean) ? this.programGroupEnabled : (Boolean)object == false;
        return bl;
    }

    private String getProgramGroupNameOverridden(Context context) {
        Object object = context.getVariable("sys.programGroupName");
        if (object == null) {
            object = this.getProgramGroupName();
        }
        return object.toString();
    }

    private boolean isAllUsersOverridden(Context context) {
        Object object = context.getVariable("sys.programGroupAllUsers");
        boolean bl = object == null || !(object instanceof Boolean) ? this.allUsers : (Boolean)object;
        return bl;
    }

    private String getLinkDirectoryOverridden(Context context) {
        Object object = context.getVariable("sys.symlinkDir");
        String string = object == null ? this.getLinkDirectory() : object.toString();
        return string;
    }

    private class UnixPanel
    extends SystemScreen.DefaultPanel
    implements ActionListener {
        private DirectorySelector directorySelector;
        private JCheckBox chkEnabled;

        private UnixPanel() {
            super(StandardProgramGroupScreen.this);
        }

        public boolean next() {
            Context context = StandardProgramGroupScreen.this.getContext();
            context.setVariable("sys.symlinkDir", this.directorySelector.getSelectedFile().getPath());
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                context.setVariable("sys.programGroupDisabled", !this.chkEnabled.isSelected());
            }
            return true;
        }

        public void willActivate() {
            super.willActivate();
            Context context = StandardProgramGroupScreen.this.getContext();
            this.directorySelector.setSelectedFile(new File(StandardProgramGroupScreen.this.getLinkDirectoryOverridden(context)));
            this.chkEnabled.setSelected(StandardProgramGroupScreen.this.isProgramGroupEnabledOverridden(context));
            this.checkEnabled();
        }

        public void activated() {
            super.activated();
            this.directorySelector.focusTextField();
        }

        public boolean checkCompleted() {
            return (!this.chkEnabled.isSelected() || this.directorySelector.checkSelectedDirectory()) && super.checkCompleted();
        }

        protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
            StandardProgramGroupScreen.this.addDisplayTextArea(MessageFormat.format(StandardProgramGroupScreen.this.getMessage("SelectLinkDirLabel"), StandardProgramGroupScreen.this.getApplicationName()), jPanel, gridBagConstraints);
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                jPanel.add((Component)this.chkEnabled, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.directorySelector, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 3;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.chkEnabled) {
                this.checkEnabled();
            }
        }

        protected void setupControls() {
            super.setupControls();
            this.directorySelector = new DirectorySelector(StandardProgramGroupScreen.this.getMessage("ReadyMemoDir").replace(':', ' ').trim(), false);
            this.directorySelector.activateNextScreenOnEnter(StandardProgramGroupScreen.this.getContext().getWizardContext());
            this.chkEnabled = new JCheckBox(StandardProgramGroupScreen.this.getMessage("SymlinksCheck"));
        }

        protected void setupComponent() {
            super.setupComponent();
            this.checkEnabled();
        }

        protected void setupEventHandlers() {
            super.setupEventHandlers();
            this.chkEnabled.addActionListener(this);
        }

        private void checkEnabled() {
            boolean bl = this.chkEnabled.isSelected();
            this.directorySelector.setEnabled(bl);
            JTextField jTextField = this.directorySelector.getTextField();
            if (bl) {
                jTextField.selectAll();
            } else {
                jTextField.setSelectionStart(0);
                jTextField.setSelectionEnd(0);
            }
        }
    }

    private class WindowsPanel
    extends SystemScreen.DefaultPanel
    implements ActionListener {
        private ProgramGroupSelector programGroupSelector;
        private JCheckBox chkEnabled;
        private JCheckBox chkAllUsers;

        private WindowsPanel() {
            super(StandardProgramGroupScreen.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.chkEnabled) {
                this.checkEnabled();
            } else if (object == this.chkAllUsers) {
                this.programGroupSelector.setAllUsers(this.chkAllUsers.isSelected());
            }
        }

        public boolean next() {
            Context context = StandardProgramGroupScreen.this.getContext();
            String string = this.programGroupSelector.getSelectedProgramGroup();
            boolean bl = this.chkAllUsers.isSelected();
            context.setVariable("sys.programGroupName", string);
            context.setVariable("sys.programGroupDir", new File(FolderInfo.getSpecialFolder(3, bl), string).getAbsolutePath());
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                context.setVariable("sys.programGroupDisabled", !this.chkEnabled.isSelected());
            }
            if (StandardProgramGroupScreen.this.allowUserChangeAllUsers) {
                context.setVariable("sys.programGroupAllUsers", bl);
            }
            return true;
        }

        public void willActivate() {
            super.willActivate();
            Context context = StandardProgramGroupScreen.this.getContext();
            boolean bl = StandardProgramGroupScreen.this.isAllUsersOverridden(context);
            this.programGroupSelector.setAllUsers(bl);
            this.chkAllUsers.setSelected(bl);
            this.programGroupSelector.setSelectedProgramGroup(StandardProgramGroupScreen.this.getProgramGroupNameOverridden(context));
            this.chkEnabled.setSelected(StandardProgramGroupScreen.this.isProgramGroupEnabledOverridden(context));
            this.checkEnabled();
        }

        public void activated() {
            this.programGroupSelector.focusTextField();
        }

        public boolean checkCompleted() {
            return !this.chkEnabled.isSelected() || this.programGroupSelector.checkSelectedProgramGroup();
        }

        protected void setupControls() {
            super.setupControls();
            this.programGroupSelector = new ProgramGroupSelector(true, StandardProgramGroupScreen.this.showWarningIfExists, StandardProgramGroupScreen.this.getContext().getWizardContext());
            this.chkEnabled = new JCheckBox(StandardProgramGroupScreen.this.getMessage("ProgramGroupCheck"));
            this.chkAllUsers = new JCheckBox(StandardProgramGroupScreen.this.getMessage("ProgramGroupAllUsers"));
            this.chkAllUsers.setSelected(true);
        }

        protected void setupComponent() {
            super.setupComponent();
            this.checkEnabled();
        }

        protected void setupEventHandlers() {
            super.setupEventHandlers();
            this.chkEnabled.addActionListener(this);
            this.chkAllUsers.addActionListener(this);
        }

        protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
            StandardProgramGroupScreen.this.addDisplayTextArea(StandardProgramGroupScreen.this.getMessage("SelectStartMenuFolderLabel"), jPanel, gridBagConstraints);
            if (StandardProgramGroupScreen.this.allowUserChangeEnabled) {
                jPanel.add((Component)this.chkEnabled, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)this.programGroupSelector, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            if (Util.hasFullAdminRights() && StandardProgramGroupScreen.this.allowUserChangeAllUsers) {
                gridBagConstraints.insets.bottom = 5;
                jPanel.add((Component)this.chkAllUsers, gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets.top = 0;
            }
        }

        private void checkEnabled() {
            boolean bl = this.chkEnabled.isSelected();
            this.programGroupSelector.setEnabled(bl);
            this.chkAllUsers.setEnabled(bl);
        }
    }
}

