/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.misc.ElevatedProcessType;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.Uninstaller;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.apiimpl.ApplicationLauncherImpl;
import com.install4j.runtime.installer.helper.comm.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.CommunicationReceiver;
import com.install4j.runtime.installer.helper.comm.ProcessCommunication;
import com.install4j.runtime.installer.platform.macos.MacosUserInfo;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import com.install4j.runtime.launcher.SwingWindowChecker;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;

public class RequestPrivilegesAction
extends SystemInstallOrUninstallAction {
    private boolean obtainIfAdminWin = true;
    private boolean obtainIfNormalWin = false;
    private ElevatedProcessType elevatedProcessTypeWin = ElevatedProcessType.MAIN;
    private boolean failIfNotObtainedWin = true;
    private boolean obtainIfAdminMac = false;
    private boolean obtainIfNormalMac = false;
    private ElevatedProcessType elevatedProcessTypeMac = ElevatedProcessType.HELPER;
    private boolean failIfNotObtainedMac = true;
    private boolean failIfNotRootUnix = false;
    private static boolean alreadyRestarted = false;

    public boolean isObtainIfAdminWin() {
        return this.obtainIfAdminWin;
    }

    public void setObtainIfAdminWin(boolean bl) {
        this.obtainIfAdminWin = bl;
    }

    public boolean isObtainIfNormalWin() {
        return this.obtainIfNormalWin;
    }

    public void setObtainIfNormalWin(boolean bl) {
        this.obtainIfNormalWin = bl;
    }

    public ElevatedProcessType getElevatedProcessTypeWin() {
        return this.elevatedProcessTypeWin;
    }

    public void setElevatedProcessTypeWin(ElevatedProcessType elevatedProcessType) {
        this.elevatedProcessTypeWin = elevatedProcessType;
    }

    public boolean isFailIfNotObtainedWin() {
        return this.failIfNotObtainedWin;
    }

    public void setFailIfNotObtainedWin(boolean bl) {
        this.failIfNotObtainedWin = bl;
    }

    public boolean isObtainIfAdminMac() {
        return this.obtainIfAdminMac;
    }

    public void setObtainIfAdminMac(boolean bl) {
        this.obtainIfAdminMac = bl;
    }

    public boolean isObtainIfNormalMac() {
        return this.obtainIfNormalMac;
    }

    public void setObtainIfNormalMac(boolean bl) {
        this.obtainIfNormalMac = bl;
    }

    public ElevatedProcessType getElevatedProcessTypeMac() {
        return this.elevatedProcessTypeMac;
    }

    public void setElevatedProcessTypeMac(ElevatedProcessType elevatedProcessType) {
        this.elevatedProcessTypeMac = elevatedProcessType;
    }

    public boolean isFailIfNotObtainedMac() {
        return this.failIfNotObtainedMac;
    }

    public void setFailIfNotObtainedMac(boolean bl) {
        this.failIfNotObtainedMac = bl;
    }

    public boolean isFailIfNotRootUnix() {
        return this.failIfNotRootUnix;
    }

    public void setFailIfNotRootUnix(boolean bl) {
        this.failIfNotRootUnix = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (Util.isWindows()) {
            return this.executeOnWindows(context);
        }
        if (Util.isMacOS()) {
            return this.executeOnMac(context);
        }
        if (this.failIfNotRootUnix && !Util.hasFullAdminRights()) {
            this.showFailureMessage(context);
            return false;
        }
        return true;
    }

    private boolean executeOnMac(Context context) throws UserCanceledException {
        boolean bl = true;
        if (Util.isAdminGroup()) {
            if (this.obtainIfAdminMac) {
                bl = Util.hasFullAdminRights() || this.restartOnMac(context);
            }
        } else if (this.obtainIfNormalMac) {
            bl = this.restartOnMac(context);
        }
        if (!bl && this.failIfNotObtainedMac) {
            this.showFailureMessage(context);
        }
        return bl;
    }

    private boolean executeOnWindows(Context context) throws UserCanceledException {
        boolean bl = true;
        if (Util.isAdminGroup()) {
            if (this.obtainIfAdminWin) {
                bl = Util.hasFullAdminRights() || this.restartOnWindows(context);
            }
        } else if (this.obtainIfNormalWin) {
            bl = this.restartOnWindows(context);
        }
        if (!bl && this.failIfNotObtainedWin) {
            this.showFailureMessage(context);
        }
        return bl;
    }

    private boolean restartOnMac(Context context) {
        if (!Util.isMacosInstaller()) {
            return false;
        }
        if (alreadyRestarted) {
            return true;
        }
        if (this.elevatedProcessTypeMac == ElevatedProcessType.MAIN) {
            if (InstallerUtil.isInProcess()) {
                return false;
            }
            String string = this.getModuleName();
            if (string == null) {
                return true;
            }
            File file = new File(string, "Contents/MacOS/JavaApplicationStub");
            if (!file.exists()) {
                Util.showMessage(MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not start elevated: " + file), 0);
                return false;
            }
            alreadyRestarted = RequestPrivilegesAction.elevateMain(context, file.toString(), null);
        } else {
            ProcessCommunication processCommunication = ProcessCommunication.getInstance();
            String string = processCommunication.createListener(true);
            if (string == null) {
                return false;
            }
            alreadyRestarted = MacosUserInfo.executeElevated(new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), " -classpath \"" + System.getProperty("java.class.path") + "\"" + " -Xdock:name=\"" + InstallerConfig.getCurrentInstance().getApplicationName() + " Installer\"" + " -Xdock:icon=../app.icns" + " -Duser.language=" + context.getLanguageId() + " -D" + "install4j.language" + "=" + context.getLanguageId() + " -D" + "install4j.commIdentifier" + "=" + string + " -D" + "install4j.elevatedHelper" + "=true" + " com.install4j.runtime.installer.Installer -q", System.getProperty("user.dir"), null) && processCommunication.connect();
        }
        return alreadyRestarted;
    }

    private void showFailureMessage(Context context) throws UserCanceledException {
        String string = context instanceof InstallerContext ? (Util.isWindows() ? "AdminPrivilegesRequired" : "RootPrivilegesRequired") : "OnlyAdminCanUninstall";
        GUIHelper.showMessage(null, Messages.getMessages().getString(string), 0);
        throw new UserCanceledException("not admin");
    }

    public boolean isRollbackSupported() {
        return false;
    }

    private boolean restartOnWindows(Context context) {
        if (!Util.isAtLeastWindowsVista()) {
            return false;
        }
        if (alreadyRestarted) {
            return true;
        }
        String string = this.getModuleName();
        if (string == null) {
            return true;
        }
        if (!new File(string).exists()) {
            Util.showMessage(MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not start elevated: " + string), 0);
            return false;
        }
        ProcessCommunication processCommunication = ProcessCommunication.getInstance();
        String string2 = processCommunication.createListener(this.elevatedProcessTypeWin == ElevatedProcessType.HELPER);
        if (string2 == null) {
            return false;
        }
        CommunicationReceiver communicationReceiver = this.getListener(context);
        if (this.elevatedProcessTypeWin == ElevatedProcessType.MAIN) {
            if (InstallerUtil.isInProcess()) {
                return false;
            }
            alreadyRestarted = RequestPrivilegesAction.elevateMain(context, string, string2);
            if (alreadyRestarted) {
                ContextImpl.getContextImpl(context).closeWindows();
                processCommunication.receiveActions(communicationReceiver);
                int n = ProcessCommunication.getInstance().waitForFinish();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                System.exit(n);
            }
        } else {
            boolean bl = alreadyRestarted = Win32UserInfo.executeElevated(string, "__i4j_lang_restart -q -Duser.language=" + context.getLanguageId() + " -D" + "install4j.language" + "=" + context.getLanguageId() + " -D" + "exe4j.unextractedPositionRestart" + "=" + Integer.getInteger("exe4j.unextractedPosition", 0) + " -D" + "install4j.commIdentifier" + "=" + string2 + (WinDel.SEMAPHORE_NAME == null ? "" : " \"-Dexe4j.semaphoreName=" + WinDel.SEMAPHORE_NAME) + "\"" + " -D" + "install4j.elevatedHelper" + "=true", System.getProperty("user.dir")) && processCommunication.connect();
        }
        if (communicationReceiver != null) {
            communicationReceiver.actionReceived(null);
        }
        return alreadyRestarted;
    }

    private String getModuleName() {
        String string;
        if (InstallerUtil.isInProcess()) {
            string = ApplicationLauncherImpl.getExeFile((ApplicationWithPath)InstallerConfig.getCurrentApplication()).getAbsolutePath();
        } else {
            string = System.getProperty("exe4j.moduleName");
            if (string == null) {
                Util.showMessage("No elevation can be performed for debug installers. Continuing without elevation.", 1);
            }
        }
        return string;
    }

    private static boolean elevateMain(Context context, String string, String string2) {
        String string3;
        File file = null;
        try {
            file = File.createTempFile("i4jres", ".varfile");
            if (Util.isWindows()) {
                file.deleteOnExit();
            }
            InstallerVariables.writeResponseFile(file, null);
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        Logger.getInstance().switchToSecondaryProcess();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < InstallerUtil.getCommandLineParameters().length; ++i) {
            string3 = InstallerUtil.getCommandLineParameters()[i];
            stringBuffer.append(' ');
            if (string3.indexOf(32) > -1) {
                stringBuffer.append('\"').append(string3).append('\"');
                continue;
            }
            stringBuffer.append(string3);
        }
        if (Util.isWindows()) {
            if (Win32UserInfo.executeElevated(string, "__i4j_lang_restart" + stringBuffer.toString() + " -Duser.language=" + context.getLanguageId() + " -D" + "install4j.language" + "=" + context.getLanguageId() + " -D" + "exe4j.unextractedPositionRestart" + "=" + Integer.getInteger("exe4j.unextractedPositionRestart", Integer.getInteger("exe4j.unextractedPosition", 0)) + " -D" + "install4j.commIdentifier" + "=" + string2 + (WinDel.SEMAPHORE_NAME == null ? "" : " \"-Dexe4j.semaphoreName=" + WinDel.SEMAPHORE_NAME + "\"") + (file == null ? " -Dinstall4j.responseFileFailure=true" : " -Dinstall4j.restartResponseFile=" + FolderInfo.getShortPathName(file.getAbsolutePath())), System.getProperty("user.dir"))) {
                InstallerUtil.registerStarted(true);
                return true;
            }
        } else {
            Application application = InstallerConfig.getCurrentApplication();
            if (InstallerConfig.isInstaller()) {
                string3 = " -Xdock:name=\"" + InstallerConfig.getCurrentInstance().getApplicationName() + " Installer\"" + " -Xdock:icon=../app.icns " + Installer.class.getName();
            } else {
                ApplicationWithPath applicationWithPath = (ApplicationWithPath)application;
                string3 = " " + ApplicationLauncherImpl.getDockOptions(InstallerConfig.getCurrentInstance(), applicationWithPath, InstallerConfig.getCurrentApplicationId(), ApplicationLauncherImpl.getExeFile(applicationWithPath)) + " ";
                string3 = InstallerConfig.isUninstaller() ? string3 + Uninstaller.class.getName() : string3 + com.install4j.runtime.installer.Application.class.getName() + " " + InstallerConfig.getCurrentApplicationId();
            }
            if (MacosUserInfo.executeElevated(new File(System.getProperty("java.home"), "bin/java").getAbsolutePath(), application.getVmParameters() + " " + " -classpath \"" + System.getProperty("java.class.path") + "\"" + " -Duser.language=" + context.getLanguageId() + " -D" + "install4j.language" + "=" + context.getLanguageId() + " -D" + "install4j.commIdentifier" + "=" + string2 + " -D" + "install4j.elevatedHelper" + "=true" + " -D" + "install4j.restartedBy" + "=" + System.getProperty("user.name") + string3 + (file == null ? " -Dinstall4j.responseFileFailure=true" : " -Dinstall4j.restartResponseFile \"" + file.getAbsolutePath() + "\""), System.getProperty("user.dir"), null)) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                System.exit(0);
            }
        }
        return false;
    }

    private CommunicationReceiver getListener(Context context) {
        CommunicationReceiver communicationReceiver = null;
        if (!(InstallerConfig.isInstaller() && !((InstallerApplication)InstallerConfig.getCurrentApplication()).isSuppressProgressDialog() || context.isConsole() || context.isUnattended() || SwingWindowChecker.hasVisibleWindows())) {
            String string = "install4j";
            if (context.getWizardContext() instanceof WizardScreenExecutor) {
                string = ((WizardScreenExecutor)context.getWizardContext()).getWindowTitle();
            }
            final SplashProgressInterface splashProgressInterface = new SplashProgressInterface(string, false, false, null, false, null);
            splashProgressInterface.setStatusMessage(Messages.getMessages().getString("ProcessElevationTitle"));
            try {
                Runnable runnable = new Runnable(){

                    public void run() {
                        splashProgressInterface.setIndeterminateProgress(true);
                        splashProgressInterface.setVisible(true);
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            communicationReceiver = new CommunicationReceiver(){

                public void actionReceived(CommunicationAction communicationAction) {
                    splashProgressInterface.setVisible(false);
                }
            };
        }
        return communicationReceiver;
    }

    public boolean isAllRequested() {
        return this.obtainIfAdminWin && this.obtainIfNormalWin && this.obtainIfAdminMac && this.obtainIfNormalMac;
    }

    public void setAllRequested() {
        this.obtainIfAdminWin = true;
        this.obtainIfNormalWin = true;
        this.obtainIfAdminMac = true;
        this.obtainIfNormalMac = true;
        this.failIfNotObtainedWin = true;
        this.failIfNotObtainedMac = true;
        this.failIfNotRootUnix = true;
    }
}

