/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

public class LoadResponseFileAction
extends SystemInstallOrUninstallAction {
    private File file = null;
    private String[] excludedVariables;

    public File getFile() {
        return LoadResponseFileAction.replaceVariables(this.file);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String[] getExcludedVariables() {
        return this.excludedVariables;
    }

    public void setExcludedVariables(String[] stringArray) {
        this.excludedVariables = stringArray;
    }

    public boolean execute(Context context) throws UserCanceledException {
        File file = context.getDestinationFile(this.getFile());
        boolean bl = false;
        if (file == null) {
            file = new File(ContextImpl.getContextImpl(context).getRuntimeDirectory(), "response.varfile");
            bl = true;
        }
        if (!file.exists()) {
            Logger.getInstance().log(this, "Response file " + file.getPath() + " does not exist", bl);
            return bl;
        }
        try {
            InstallerVariables.loadResponseFile(file, true, this.excludedVariables == null ? Collections.EMPTY_LIST : Arrays.asList(this.excludedVariables));
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return false;
        }
        return true;
    }
}

