/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AutoUninstallHandler {
    private static final String AUTO_UNINSTALL_FILE_PREFIX = "autoUninstall.";
    private static final String ELEMENT_ROOT = "autoUninstall";
    private static final String ELEMENT_ACTION = "action";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ATTRIBUTE_CLASS_NAME = "className";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";

    public static void saveProperties(List list, File file) throws IOException {
        File file2;
        if (list.size() == 0) {
            return;
        }
        Document document = XmlHelper.createDocument();
        Element element = document.createElement(ELEMENT_ROOT);
        document.appendChild(element);
        for (int i = list.size() - 1; i >= 0; --i) {
            AutoUninstallAction autoUninstallAction = (AutoUninstallAction)list.get(i);
            Element element2 = document.createElement(ELEMENT_ACTION);
            element2.setAttribute(ATTRIBUTE_CLASS_NAME, autoUninstallAction.getClass().getName());
            Properties properties = autoUninstallAction.getPersistentProperties();
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Element element3 = document.createElement(ELEMENT_PROPERTY);
                element3.setAttribute(ATTRIBUTE_NAME, (String)entry.getKey());
                element3.setAttribute(ATTRIBUTE_VALUE, (String)entry.getValue());
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        int n = 0;
        while ((file2 = new File(file, AUTO_UNINSTALL_FILE_PREFIX + n++)).exists()) {
        }
        XmlHelper.writeFile(file2, document);
        FileInstaller.getInstance().registerUninstallFile(file2);
    }

    public static List getAutoUninstallActions(File file) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < file.listFiles().length; ++i) {
            File file2 = file.listFiles()[i];
            String string = file2.getName();
            if (!string.startsWith(AUTO_UNINSTALL_FILE_PREFIX)) continue;
            try {
                int n = Integer.parseInt(string.substring(AUTO_UNINSTALL_FILE_PREFIX.length()));
                arrayList.add(new Integer(n));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        Collections.sort(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            int n = (Integer)arrayList.get(i);
            File file3 = new File(file, AUTO_UNINSTALL_FILE_PREFIX + n);
            AutoUninstallHandler.addAutoUninstallActionsFromFile(file3, arrayList2);
        }
        return arrayList2;
    }

    private static void addAutoUninstallActionsFromFile(File file, List list) throws IOException {
        Element element = XmlHelper.parseFile(file).getDocumentElement();
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            AutoUninstallAction autoUninstallAction;
            Element element2;
            block4: {
                element2 = (Element)iterator.next();
                autoUninstallAction = null;
                try {
                    autoUninstallAction = (AutoUninstallAction)Class.forName(element2.getAttribute(ATTRIBUTE_CLASS_NAME)).newInstance();
                }
                catch (Throwable throwable) {
                    if (!Boolean.getBoolean("install4j.debugAutoUninstall")) break block4;
                    throwable.printStackTrace();
                }
            }
            if (autoUninstallAction == null) continue;
            Properties properties = new Properties();
            Iterator iterator2 = XmlHelper.childElements(element2);
            while (iterator2.hasNext()) {
                Element element3 = (Element)iterator2.next();
                properties.setProperty(element3.getAttribute(ATTRIBUTE_NAME), element3.getAttribute(ATTRIBUTE_VALUE));
            }
            autoUninstallAction.setPersistentProperties(properties);
            list.add(autoUninstallAction);
        }
    }
}

